/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.workspace;

import com.agilent.tntd.eclipse.bottomlayer.localdomain.ApplicationDomainInitialiser;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.BottomButtonPanel;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.InstrumentKeyHandlers;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.WindowSelector;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMainMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.popuputilities.MultiInstrumentMainMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.popuputilities.VirtualInstrumentMainMenu;

public abstract class WorkspaceElements {
    private EclPanePage theSummaryPanel;
    private EclPanePage theLEDPanel;
    private EclipsePopupMenu theMainMenu;
    private EclipsePopupMenu theSmartTestMenu;
    private InstrumentKeyHandlers theKeyHandlers;
    private InternalWindow defaultLeftWindow;
    private InternalWindow defaultRightWindow;
    private InternalWindow defaultFullWindow;
    private String showMoreWindowName;
    private String resetKeyVariableName;
    private String singleErrorKeyVariableName;
    private String runStopKeyVariableName;
    private EclMainMenu theInstrumentMainMenu;
    private String historyLEDVariableName = "FP_LED_HISTORY_DISP";
    private String runStopLEDVariableName = "FP_LED_GATING_DISP";

    public WorkspaceElements() {
        this.initialiseProperties();
    }

    void connectElements(EclipseWorkspace eclipseWorkspace) {
        WindowManager.instance().clearContextSensitiveMenuItems();
        this.getMainPopup().finishInitialise();
        this.getSmartTestPopup().finishInitialise();
        WindowManager.instance().notifyCompletedRecordingContextSensitiveMenuItems();
        this.defaultLeftWindow.connectWithWorkspace(eclipseWorkspace);
        this.defaultLeftWindow.finishInitialise();
        this.defaultRightWindow.connectWithWorkspace(eclipseWorkspace);
        this.defaultRightWindow.finishInitialise();
        if (this.defaultFullWindow != null) {
            this.defaultFullWindow.connectWithWorkspace(eclipseWorkspace);
            this.defaultFullWindow.finishInitialise();
        }
        this.getKeyHandlers().finishInitialise();
    }

    protected abstract EclPanePage createLEDPanel();

    protected abstract EclPanePage createSummaryPanel();

    void disconnectElements(WindowSelector windowSelector) {
        windowSelector.unregisterWindows(false);
        this.hideRemoveUnregister(this.getSummaryPanel());
        if (this.theLEDPanel != null) {
            this.hideRemoveUnregister(this.theLEDPanel);
        }
        this.getMainPopup().getEclipseMenuComponent().setVisible(false);
        this.getMainPopup().unregister();
        this.getSmartTestPopup().getEclipseMenuComponent().setVisible(false);
        this.getSmartTestPopup().unregister();
        this.getKeyHandlers().unregister();
        this.unloadElements();
    }

    InstrumentKeyHandlers getKeyHandlers() {
        return this.theKeyHandlers;
    }

    EclipsePopupMenu getMainPopup() {
        if (this.theMainMenu == null) {
            this.theMainMenu = this.theInstrumentMainMenu.getRootPopupMenu();
        }
        return this.theMainMenu;
    }

    EclPanePage getRightLEDPanel() {
        if (this.theLEDPanel == null) {
            this.theLEDPanel = this.createLEDPanel();
        }
        return this.theLEDPanel;
    }

    EclipsePopupMenu getSmartTestPopup() {
        return this.theSmartTestMenu;
    }

    EclPanePage getSummaryPanel() {
        if (this.theSummaryPanel == null) {
            this.theSummaryPanel = this.createSummaryPanel();
        }
        return this.theSummaryPanel;
    }

    private void hideRemoveUnregister(EclPanePage eclPanePage) {
        eclPanePage.setVisible(false);
        eclPanePage.getParent().remove(eclPanePage);
        eclPanePage.unregister();
    }

    void initialiseBottomPanel(BottomButtonPanel bottomButtonPanel) {
        bottomButtonPanel.setLEDsVariable(this.runStopLEDVariableName, this.historyLEDVariableName);
    }

    void initialiseElements(EclipseWorkspace eclipseWorkspace) {
        this.loadElements();
        WindowManager.instance().initialise(eclipseWorkspace, this.defaultLeftWindow, this.defaultRightWindow, this.defaultFullWindow);
        if (this.theKeyHandlers == null) {
            this.theKeyHandlers = new InstrumentKeyHandlers(eclipseWorkspace, this.runStopKeyVariableName, this.resetKeyVariableName, this.singleErrorKeyVariableName, this.showMoreWindowName);
        }
    }

    protected abstract void initialiseProperties();

    protected abstract void loadElements();

    protected abstract void populateLocalDomain(ApplicationDomainInitialiser var1);

    protected abstract void registerCompositeDataReaders();

    protected void setBottomPanelLEDs(String string, String string2) {
        if (string != null) {
            this.runStopLEDVariableName = string;
        }
        if (string2 != null) {
            this.historyLEDVariableName = string2;
        }
    }

    protected void setDefaultWindows(InternalWindow internalWindow, InternalWindow internalWindow2, InternalWindow internalWindow3) {
        this.defaultFullWindow = internalWindow3;
        this.defaultLeftWindow = internalWindow;
        this.defaultRightWindow = internalWindow2;
    }

    protected void setFrontPanelKeysProperties(String string, String string2, String string3, String string4) {
        this.runStopKeyVariableName = string;
        this.singleErrorKeyVariableName = string2;
        this.resetKeyVariableName = string3;
        this.showMoreWindowName = string4;
    }

    public void setInstrumentMainMenu(EclMainMenu eclMainMenu) {
        this.theInstrumentMainMenu = eclMainMenu;
    }

    void setMultiInstrumentProperties(String string, EclMainMenu eclMainMenu, String string2, boolean bl) {
        this.theMainMenu = new MultiInstrumentMainMenu(string, eclMainMenu, string2, this.theInstrumentMainMenu, bl);
    }

    public void setSmartTestMainMenu(EclMainMenu eclMainMenu) {
        this.theSmartTestMenu = eclMainMenu.getRootPopupMenu();
    }

    void setVirtualInstrumentMainMenu() {
        this.theMainMenu = new VirtualInstrumentMainMenu(this.theInstrumentMainMenu);
    }

    String testMenusExist() {
        String string = null;
        if (this.theInstrumentMainMenu == null) {
            string = "The Main popup menu has not been created by the project.";
        }
        if (this.theSmartTestMenu == null) {
            string = "The Smart test popup menu has not been created by the project.";
        }
        return string;
    }

    protected abstract void unloadElements();
}

