/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.containers.workspace;

import com.agilent.tntd.eclipse.bottomlayer.localdomain.ApplicationDomainInitialiser;
import com.agilent.tntd.eclipse.bottomlayer.localdomain.LocalDomain;
import com.agilent.tntd.eclipse.bottomlayer.localdomain.ProxyApplicationData;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.issdb.client.IssAccess;
import com.agilent.tntd.eclipse.issdb.client.IssApplicationDomain;
import com.agilent.tntd.eclipse.issdb.client.IssServerUnavailableException;
import com.agilent.tntd.eclipse.issdb.client.ThreadScheduler;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpController;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpLanguageWrapper;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.language.LanguageManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.language.LanguageObserver;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclWorkspaceDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.MenuPathSelector;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.PopupContainerFactory;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.StandAloneMainMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.statusline.StatusLineApplication;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePageModel;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.BottomButtonPanel;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.InstrumentMultiInstrumentData;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.MultiInstrumentData;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.RemoteMultiInstrumentData;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.WindowSelector;
import com.agilent.tntd.eclipse.viewlayer.containers.workspace.WorkspaceElements;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMainMenu;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class WorkspaceSwingFrame
extends JFrame
implements EclipseWorkspace,
UnconsumedKeyHandler,
ContextHelpController,
LanguageObserver {
    private transient EclLabel contextHelpLabel = null;
    private transient String currentHelpId = null;
    private transient ContextHelpLanguageWrapper contextHelp = new ContextHelpLanguageWrapper();
    private transient LanguageManager languageManager = new LanguageManager();
    private static final Color CONTEXT_HELP_TEXT_COLOUR = Color.blue.darker();
    static final Rectangle CONTEXT_HELP_BOUNDS = new Rectangle(0, 438, 640, 20);
    private static final Rectangle STATUS_LINE_BOUNDS = new Rectangle(0, 458, 640, 20);
    private transient Point topLeftUsableScreen;
    private transient WindowSelector windowSelector;
    private boolean isVirtualInstrument = false;
    private WorkspaceElements theCurrentElements;
    private Object elementsLock = new Object();
    private BottomButtonPanel theBottomPanel;

    protected WorkspaceSwingFrame() {
        this.initialise();
    }

    public void addInternalWindow(InternalWindow internalWindow, int n, UnconsumedKeyHandler unconsumedKeyHandler) {
        this.getWindowSelector().addInternalWindow(internalWindow, n, unconsumedKeyHandler);
    }

    public void closingWindow() {
        EclipseSystem.instance().exit();
    }

    private ApplicationDomainInitialiser createLocalDomain() {
        LocalDomain localDomain = new LocalDomain("LOCAL");
        ApplicationManager.instance().add(localDomain);
        ApplicationDomainInitialiser applicationDomainInitialiser = new ApplicationDomainInitialiser(localDomain);
        applicationDomainInitialiser.createMaskedIntegerVariable("ONLY_AVAILABLE_ON_INSTRUMENT", EclipseSystem.instance().isOnInstrument() ? 1 : 0, 2);
        applicationDomainInitialiser.createMaskedIntegerVariable("MRS_SESSION_DELETE_RADIOBUTTON", 0, 2);
        applicationDomainInitialiser.createKnownLengthStringVariable("MRS_SESSION_SELECTED_NAME", null, 72);
        applicationDomainInitialiser.createMaskedIntegerVariable("LANGUAGE", 0, 2);
        applicationDomainInitialiser.createMaskedIntegerVariable("MRS_ADD_REMOVE_PANE", 0, 2);
        return applicationDomainInitialiser;
    }

    private EclMainMenu createMultiInstrumentPopup(Class clazz) {
        EclMainMenu eclMainMenu = null;
        String string = null;
        try {
            eclMainMenu = ((StandAloneMainMenu)clazz.newInstance()).getMainMenu();
        }
        catch (ClassCastException classCastException) {
            string = " " + clazz.toString() + " is not an instance of StandAloneMainMenu.";
        }
        catch (InstantiationException instantiationException) {
            string = " " + clazz.toString() + " cannot be instanciated.";
        }
        catch (IllegalAccessException illegalAccessException) {
            string = " " + clazz.toString() + " is not an accessible class.";
        }
        if (eclMainMenu == null) {
            if (string == null) {
                string = " " + clazz.toString() + " does not return a main menu (check your code).";
            }
            throw new NullPointerException("Cannot create instance of the MultiInstrument Popup menu using the class passed as a parameter in the main method." + string);
        }
        return eclMainMenu;
    }

    private MultiInstrumentData createMultiInstrumentVariable(WorkspaceElements[] workspaceElementsArray) {
        MultiInstrumentData multiInstrumentData = EclipseSystem.instance().isOnInstrument() ? new InstrumentMultiInstrumentData(workspaceElementsArray, this) : new RemoteMultiInstrumentData(workspaceElementsArray, this);
        return multiInstrumentData;
    }

    private void createStatusLineDisplay() {
        EclPanePage eclPanePage = new EclPanePage();
        eclPanePage.setEclModel(new EclPanePageModel(true, true, true, true, 2));
        eclPanePage.setBackground(Color.lightGray);
        eclPanePage.setBounds(STATUS_LINE_BOUNDS);
        this.getContentPane().add(eclPanePage);
        StatusLineApplication.getInstance().registerDisplayArea(eclPanePage, this);
    }

    private String createSummaryPanel(WorkspaceElements workspaceElements) {
        String string = null;
        EclPanePage eclPanePage = workspaceElements.getSummaryPanel();
        if (eclPanePage == null) {
            string = "This project did not provide a Summary Panel.";
        } else if (eclPanePage.getBounds().width != 636 || eclPanePage.getBounds().height != 115) {
            string = "The Summary Panel provided is not of the right size: width=636 and height=115.";
        } else {
            eclPanePage.setLocation(2, 321);
            this.getContentPane().add(eclPanePage);
            eclPanePage.finishInitialise();
            eclPanePage.setVisible(true);
        }
        return string;
    }

    private String createVirtualInstrumentLayout(WorkspaceElements workspaceElements) {
        String string = null;
        EclPanePage eclPanePage = workspaceElements.getRightLEDPanel();
        if (eclPanePage == null) {
            string = "This project did not provide the Panel with LEDs.";
        } else if (eclPanePage.getBounds().width != 128 || eclPanePage.getBounds().height != 476) {
            string = "The panel with LEDs provided is not of the right size: width=128 and height=476.";
        } else {
            eclPanePage.setLocation(643, 2);
            this.getContentPane().add(eclPanePage);
            eclPanePage.finishInitialise();
            eclPanePage.setVisible(true);
        }
        if (this.theBottomPanel == null) {
            this.theBottomPanel = new BottomButtonPanel();
            this.theBottomPanel.setUnconsumedKeyHandler(this);
            this.theBottomPanel.setLocation(0, 480);
            this.getContentPane().add(this.theBottomPanel);
        }
        workspaceElements.initialiseBottomPanel(this.theBottomPanel);
        this.theBottomPanel.finishInitialise();
        return string;
    }

    protected WorkspaceElements createWorkspaceElements(String string) {
        WorkspaceElements workspaceElements = null;
        try {
            workspaceElements = (WorkspaceElements)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Impossible to instanciate this WorkspaceElements because: " + classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Impossible to instanciate this WorkspaceElements because: " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Impossible to instanciate this WorkspaceElements because: " + illegalAccessException.toString());
        }
        catch (ClassCastException classCastException) {
            System.out.println("Impossible to instanciate this WorkspaceElements because: " + classCastException.toString());
        }
        return workspaceElements;
    }

    public final void disconnect() {
        ((Component)((Object)this)).setVisible(false);
        if (this.windowSelector != null) {
            this.windowSelector.unregisterWindows(true);
            this.windowSelector = null;
        }
        Component[] componentArray = this.getContentPane().getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof CcComponent && !(componentArray[n] instanceof InternalWindow)) {
                ((CcComponent)((Object)componentArray[n])).unregister();
            }
            ++n;
        }
        StatusLineApplication.getInstance().unregister();
        this.languageManager.unregister();
        WindowManager.instance().unregister();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        ApplicationManager.instance().removeAllDomains();
    }

    public void displayContextHelp(String string) {
        if (string != this.currentHelpId) {
            this.currentHelpId = string;
            this.showContextHelpLine(string == null ? "" : this.contextHelp.mapIdToString(string));
        }
    }

    private void displayGUI(WorkspaceElements workspaceElements) {
        StatusLineApplication.getInstance().finishInitialise();
        ApplicationManager.instance().request("ISS", 0, "END", null);
        ThreadScheduler.instance().goToBarrier();
        if (EclipseSystem.instance().isOnInstrument()) {
            ((Container)((Object)this)).remove(((Container)((Object)this)).getComponent(0));
            this.setRootPaneCheckingEnabled(true);
            this.getContentPane().setVisible(true);
        } else {
            ((Component)((Object)this)).setVisible(true);
        }
        this.getWindowSelector().selectTopWindow();
        this.theCurrentElements = workspaceElements;
    }

    private WorkspaceElements getElements() {
        Object object = this.elementsLock;
        synchronized (object) {
            return this.theCurrentElements;
        }
    }

    private WindowSelector getWindowSelector() {
        if (this.windowSelector == null) {
            this.windowSelector = new WindowSelector(this.getContentPane());
        }
        return this.windowSelector;
    }

    private void initialise() {
        EclipseSystem.instance().initialise(this);
    }

    void initialise(ProxyApplicationData proxyApplicationData, WorkspaceElements[] workspaceElementsArray, int n, String string) {
        Object object = this.elementsLock;
        synchronized (object) {
            ApplicationDomainInitialiser applicationDomainInitialiser = this.loadElements(workspaceElementsArray[n]);
            applicationDomainInitialiser.loadData(string, proxyApplicationData);
            StatusLineApplication.getInstance().initialiseMultiInstrument(string);
            if (applicationDomainInitialiser != null) {
                int n2 = 0;
                while (n2 < workspaceElementsArray.length) {
                    if (n2 != n) {
                        workspaceElementsArray[n2].registerCompositeDataReaders();
                        workspaceElementsArray[n2].populateLocalDomain(applicationDomainInitialiser);
                    }
                    ++n2;
                }
            }
            this.displayGUI(workspaceElementsArray[n]);
        }
    }

    private void initialiseContextHelp() {
        this.languageManager.addObserver(this.contextHelp);
        EclPanePage eclPanePage = new EclPanePage();
        eclPanePage.setEclModel(new EclPanePageModel(true, true, true, true, 2));
        eclPanePage.setBackground(Color.lightGray);
        eclPanePage.setBounds(CONTEXT_HELP_BOUNDS);
        this.contextHelpLabel = new EclLabel();
        this.contextHelpLabel.setForeground(CONTEXT_HELP_TEXT_COLOUR);
        this.contextHelpLabel.setEclModel(new EclLabelModel(null, null, new String[][]{{""}}));
        this.contextHelpLabel.setBounds(4, 0, eclPanePage.getSize().width - 8, eclPanePage.getSize().height);
        eclPanePage.add(this.contextHelpLabel);
        this.getContentPane().add(eclPanePage);
    }

    private ApplicationDomainInitialiser loadElements(WorkspaceElements workspaceElements) {
        ApplicationDomainInitialiser applicationDomainInitialiser = null;
        try {
            String string = null;
            string = workspaceElements.testMenusExist();
            if (string == null) {
                ThreadScheduler.instance().createInitialisationBarrier();
                ApplicationManager.instance().request("ISS", 0, "BEGIN", null);
                if (this.theCurrentElements == null) {
                    applicationDomainInitialiser = this.createLocalDomain();
                    EclipseSystem.instance().initialiseControlVariable();
                } else {
                    this.theCurrentElements.disconnectElements(this.getWindowSelector());
                    if (this.theBottomPanel != null) {
                        this.theBottomPanel.unregister();
                    }
                }
                workspaceElements.initialiseElements(this);
                if (this.theCurrentElements == null) {
                    workspaceElements.registerCompositeDataReaders();
                    workspaceElements.populateLocalDomain(applicationDomainInitialiser);
                }
                if (this.isVirtualInstrument) {
                    string = this.createVirtualInstrumentLayout(workspaceElements);
                }
                if (string == null && (string = this.createSummaryPanel(workspaceElements)) == null) {
                    workspaceElements.connectElements(this);
                    if (this.theCurrentElements == null) {
                        WindowManager.instance().finishInitialise();
                        this.languageManager.finishInitialise();
                        this.languageManager.addObserver(this);
                    }
                }
            }
            if (string != null) {
                EclipseSystem.instance().exitWithError(string);
            }
        }
        catch (Throwable throwable) {
            String string = "Exception: " + throwable.toString() + " occurred in starting GUI client";
            throwable.printStackTrace(System.out);
            EclipseSystem.instance().exitWithError(string);
            applicationDomainInitialiser = null;
        }
        return applicationDomainInitialiser;
    }

    public void notifyLanguageSelection(String string) {
        String string2 = this.currentHelpId;
        this.displayContextHelp(null);
        this.displayContextHelp(string2);
    }

    protected String onStartup(String string, String string2) {
        String string3 = null;
        try {
            IssAccess issAccess;
            InetAddress inetAddress = InetAddress.getByName(string);
            if (string2 != null) {
                int n = Integer.parseInt(string2);
                issAccess = new IssAccess(inetAddress, n);
            } else {
                issAccess = new IssAccess(inetAddress);
            }
            IssApplicationDomain issApplicationDomain = new IssApplicationDomain(issAccess, "ISS");
            issAccess.attachDomain(issApplicationDomain);
            ApplicationManager.instance().add(issApplicationDomain);
        }
        catch (NumberFormatException numberFormatException) {
            string3 = "The port number has not a valid value: " + string2;
        }
        catch (UnknownHostException unknownHostException) {
            string3 = "Can't find machine named " + string;
        }
        catch (IssServerUnavailableException issServerUnavailableException) {
            string3 = String.valueOf(issServerUnavailableException.getMessage()) + string;
        }
        return string3;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.processUnconsumedKeyEvents(keyEvent, (Component)((Object)this));
    }

    public void processUnconsumedKeyEvents(KeyEvent keyEvent, Component component) {
        if (this.getWindowSelector().getSelectedKeyHandlerWindowInfo().getKeyHandler() != null) {
            this.getWindowSelector().getSelectedKeyHandlerWindowInfo().getKeyHandler().processUnconsumedKeyEvents(keyEvent, component);
        }
        if (!keyEvent.isConsumed()) {
            this.getElements().getKeyHandlers().processUnconsumedKeyEvents(keyEvent, component);
        }
        if (!keyEvent.isConsumed() && keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 38: {
                    EclipseFocusManager.getInstance().focusAboveComponent(component);
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    EclipseFocusManager.getInstance().focusPreviousComponent(component);
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    EclipseFocusManager.getInstance().focusBelowComponent(component);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    EclipseFocusManager.getInstance().focusNextComponent(component);
                    keyEvent.consume();
                    break;
                }
                case 112: {
                    if (this.isVirtualInstrument) {
                        EclipseSystem.instance().beep();
                    } else {
                        this.getElements().getMainPopup().getEclipseMenuComponent().setVisible(false);
                        this.getWindowSelector().toggleOnLineHelp();
                    }
                    keyEvent.consume();
                    break;
                }
                case 107: {
                    if (this.getElements().getMainPopup().getEclipseMenuComponent().isVisible()) {
                        if (component instanceof EclipseMenuElement) {
                            ((EclipseMenuElement)((Object)component)).hideAllPopupInSelectedPath(true);
                        }
                    } else if (this.getElements().getSmartTestPopup().getEclipseMenuComponent().isVisible()) {
                        if (component instanceof EclipseMenuElement) {
                            ((EclipseMenuElement)((Object)component)).hideAllPopupInSelectedPath(false);
                        }
                        this.showPopupMenu(this.getElements().getSmartTestPopup(), this.getElements().getSmartTestPopup().getComponentFocusableOnClose());
                    } else {
                        this.showPopupMenu(this.getElements().getMainPopup(), component);
                    }
                    keyEvent.consume();
                    break;
                }
                case 119: {
                    if (this.getElements().getSmartTestPopup().getEclipseMenuComponent().isVisible()) {
                        if (component instanceof EclipseMenuElement) {
                            ((EclipseMenuElement)((Object)component)).hideAllPopupInSelectedPath(true);
                        }
                    } else if (this.getElements().getMainPopup().getEclipseMenuComponent().isVisible()) {
                        if (component instanceof EclipseMenuElement) {
                            ((EclipseMenuElement)((Object)component)).hideAllPopupInSelectedPath(false);
                        }
                        this.showPopupMenu(this.getElements().getSmartTestPopup(), this.getElements().getMainPopup().getComponentFocusableOnClose());
                    } else {
                        this.showPopupMenu(this.getElements().getSmartTestPopup(), component);
                    }
                    keyEvent.consume();
                    break;
                }
                case 113: {
                    this.getWindowSelector().nextWindowAction();
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed() && keyEvent.getKeyCode() == 9) {
            keyEvent.consume();
        }
    }

    private void readCommandLineParameters(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length > 3) {
            System.out.println("Wrong number of arguments in the command line.\nSpecify the machine name as a parameter");
            System.exit(0);
        }
        try {
            String string = null;
            String string2 = null;
            if (stringArray.length == 3) {
                string2 = this.onStartup(stringArray[0], stringArray[1]);
                string = stringArray[2].substring(3);
                this.isVirtualInstrument = true;
            } else if (stringArray.length == 2) {
                if (!stringArray[1].startsWith("vi=")) {
                    ((Frame)((Object)this)).setTitle(stringArray[0]);
                    string2 = this.onStartup(stringArray[0], stringArray[1]);
                } else {
                    string2 = this.onStartup(stringArray[0], null);
                    string = stringArray[1].substring(3);
                    this.isVirtualInstrument = true;
                }
            } else {
                ((Frame)((Object)this)).setTitle(stringArray[0]);
                string2 = this.onStartup(stringArray[0], null);
            }
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setBackground(EclWorkspaceDefaults.background);
            EclipseFocusManager.getInstance().initialise(this.getWindowSelector());
            if (string2 == null) {
                this.initialiseContextHelp();
                if (this.isVirtualInstrument && string2 == null) {
                    jPanel.setPreferredSize(new Dimension(772, 545));
                    ((Frame)((Object)this)).setTitle(string);
                } else {
                    jPanel.setPreferredSize(new Dimension(640, 480));
                }
                ((Window)((Object)this)).pack();
            }
            if (EclipseSystem.instance().isOnInstrument()) {
                this.setRootPaneCheckingEnabled(false);
                EclPanePage eclPanePage = new EclPanePage();
                eclPanePage.setBackground(Color.gray);
                eclPanePage.setBounds(0, 0, 3000, 3000);
                ((Container)((Object)this)).add((Component)eclPanePage, 0);
                jPanel.setVisible(false);
                ((Component)((Object)this)).setVisible(true);
            }
            PopupContainerFactory.getInstance().registerParent((Container)jPanel);
            this.createStatusLineDisplay();
            if (string2 != null) {
                ((Component)((Object)this)).setVisible(true);
                EclipseSystem.instance().exitWithError(string2);
            }
        }
        catch (Throwable throwable) {
            ((Component)((Object)this)).setVisible(true);
            String string = "Exception: " + throwable.toString() + " occurred in starting GUI client";
            throwable.printStackTrace(System.out);
            EclipseSystem.instance().exitWithError(string);
        }
    }

    public void removeContextHelp(String string) {
        if (string == this.currentHelpId) {
            this.showContextHelpLine("");
            this.currentHelpId = null;
        }
    }

    public boolean removeWindow(InternalWindow internalWindow, boolean bl) {
        boolean bl2 = false;
        if (internalWindow != null) {
            bl2 = this.getWindowSelector().removeWindow(internalWindow, bl);
        }
        return bl2;
    }

    public void selectWindow(InternalWindow internalWindow) {
        this.getWindowSelector().selectWindow(internalWindow);
    }

    public void setElements(WorkspaceElements workspaceElements) {
        Object object = this.elementsLock;
        synchronized (object) {
            this.loadElements(workspaceElements);
            this.theCurrentElements = workspaceElements;
        }
        ApplicationManager.instance().request("ISS", 0, "END", null);
        ThreadScheduler.instance().goToBarrier();
        this.getWindowSelector().selectTopWindow();
    }

    private void showContextHelpLine(String string) {
        this.contextHelpLabel.setEclModel(new EclLabelModel(null, null, new String[][]{{string}}));
        this.contextHelpLabel.repaint();
    }

    private void showPopupMenu(EclipsePopupMenu eclipsePopupMenu, Component component) {
        eclipsePopupMenu.setComponentFocusableOnClose(component);
        eclipsePopupMenu.showRelativeToComponent(this.getContentPane(), EclWorkspaceDefaults.mainMenuLocation.x, EclWorkspaceDefaults.mainMenuLocation.y);
        MenuPathSelector menuPathSelector = null;
        if (this.getWindowSelector().getSelectedWindow() != null) {
            menuPathSelector = WindowManager.instance().getMenuElement(this.getWindowSelector().getSelectedWindow().getClass().getName());
        }
        if (menuPathSelector == null || !menuPathSelector.attemptSelectPopupPath(eclipsePopupMenu)) {
            eclipsePopupMenu.getEclipseMenuComponent().requestFocus();
        }
    }

    protected void startApplication(String[] stringArray, WorkspaceElements[] workspaceElementsArray, String[] stringArray2, String string, Class clazz, String string2) {
        boolean bl = !stringArray[0].equals("localhost");
        int n = 0;
        while (n < workspaceElementsArray.length) {
            workspaceElementsArray[n].setMultiInstrumentProperties(string, this.createMultiInstrumentPopup(clazz), stringArray2[n], bl);
            ++n;
        }
        this.readCommandLineParameters(stringArray);
        MultiInstrumentData multiInstrumentData = this.createMultiInstrumentVariable(workspaceElementsArray);
        try {
            MultiInstrumentData multiInstrumentData2 = multiInstrumentData;
            synchronized (multiInstrumentData2) {
                multiInstrumentData.connect(string2);
                multiInstrumentData.wait();
            }
            multiInstrumentData.doInitialisation();
        }
        catch (InterruptedException interruptedException) {
            EclipseSystem.instance().exitWithError("Waiting on the selected multi instrument variable should not be interrupted. " + interruptedException.toString());
        }
    }

    protected void startApplication(String[] stringArray, WorkspaceElements workspaceElements) {
        if (!stringArray[0].equals("localhost")) {
            workspaceElements.setVirtualInstrumentMainMenu();
        }
        this.readCommandLineParameters(stringArray);
        Object object = this.elementsLock;
        synchronized (object) {
            this.loadElements(workspaceElements);
            this.displayGUI(workspaceElements);
        }
    }
}

