/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.hooks;

import com.agilent.tntd.eclipse.bottomlayer.localdomain.AbstractLocalApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.ChangeResponseReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.hooks.AbstractHook;

public class HookApplicationObject
extends AbstractLocalApplicationObject
implements ApplicationObjectObserver {
    private final AbstractHook theHook;
    private ApplicationData theMainData;
    private ApplicationObject theApplicationObject;
    private ErrorReporter theMainVariableReport;
    private ApplicationData theDataForChange;
    private ChangeResponseReceiver theChangeResponseReceiver;

    public HookApplicationObject(String string, ApplicationDomain applicationDomain, String string2, int n, AbstractHook abstractHook) {
        super(string, applicationDomain);
        this.theHook = abstractHook;
        ApplicationManager.instance().request(n, 0, string2, (ApplicationObjectObserver)this);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() != 1 && errorReporter.getErrorStatus() != 3) {
            this.theApplicationObject = applicationObject;
        } else {
            this.notifyObserversStateChanged(errorReporter);
        }
        this.theMainVariableReport = errorReporter;
    }

    public void asyncChange(ApplicationData applicationData, ChangeResponseReceiver changeResponseReceiver) {
        this.theDataForChange = applicationData;
        this.theChangeResponseReceiver = changeResponseReceiver;
        this.theHook.trigger();
    }

    public void canAction(boolean bl) {
        if (bl) {
            this.theChangeResponseReceiver.processChangeResponse(this.theApplicationObject.change(this.theDataForChange));
        } else {
            this.theChangeResponseReceiver.processChangeResponse(false);
        }
    }

    public final boolean change(ApplicationData applicationData) {
        EclipseSystem.instance().exitWithError(String.valueOf(this.toString()) + " doesn't support synchronous change.");
        return false;
    }

    protected ApplicationData getData() {
        return this.theMainData;
    }

    public int getInitialisationState() {
        if (this.theMainVariableReport.getErrorStatus() != 0) {
            return this.theApplicationObject.getInitialisationState();
        }
        return this.theHook.getInitialisationState();
    }

    public void notifyDataStateChange() {
        if (this.theHook.getInitialisationState() == 1) {
            ErrorReporter errorReporter = new ErrorReporter(1);
            this.notifyObserversStateChanged(errorReporter);
        }
    }

    public String toString() {
        return "HookApplicationObject[" + this.getName() + "] from " + this.getDomain().toString();
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        if (applicationObject == this.theApplicationObject) {
            this.theMainData = applicationData;
            this.asyncUpdate();
        }
    }
}

