/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.hooks.confirmationdialog;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.RegistrableData;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import com.agilent.tntd.eclipse.viewlayer.hooks.AbstractHook;
import com.agilent.tntd.eclipse.viewlayer.hooks.HookApplicationObject;
import com.agilent.tntd.eclipse.viewlayer.hooks.confirmationdialog.ConfirmationDialogModel;

public class ConfirmationDialog
extends AbstractHook
implements ApplicationObjectObserver,
RegistrableData,
MaskedIntegerDataReceiver,
DialogEventReceiver {
    private ConfirmationDialogModel eclModel;
    private transient boolean hasTrappedTransientError = false;
    private transient HookApplicationObject theHookApplicationObject;
    private transient ApplicationObject theContextApplicationObject = null;
    private transient MaskedIntegerValue thePreviousContextValue = null;

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.theContextApplicationObject = applicationObject;
        }
        if (this.theHookApplicationObject != null) {
            this.theHookApplicationObject.notifyDataStateChange();
        }
    }

    public ApplicationObject createApplicationObject(ApplicationDomain applicationDomain, String string) {
        this.theHookApplicationObject = this.eclModel == null ? null : this.eclModel.createApplicationObject(applicationDomain, string);
        return this.theHookApplicationObject;
    }

    public void finishInitialise() {
        this.getEclModel().finishInitialise();
    }

    public ConfirmationDialogModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new ConfirmationDialogModel();
            this.eclModel.setController(this);
        }
        return this.eclModel;
    }

    public int getInitialisationState() {
        return this.theContextApplicationObject == null ? 1 : this.theContextApplicationObject.getInitialisationState();
    }

    public void notifyEvent(int n, EclDialog eclDialog) {
        eclDialog.removeFromWorkspace();
        if (n == 1) {
            this.theHookApplicationObject.canAction(false);
        } else {
            this.theHookApplicationObject.canAction(true);
        }
    }

    void permanentError() {
        HookApplicationObject hookApplicationObject = this.theHookApplicationObject;
        this.unregister();
        if (hookApplicationObject != null) {
            hookApplicationObject.notifyDataStateChange();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theContextApplicationObject) {
            this.thePreviousContextValue = maskedIntegerValue;
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setEclModel(ConfirmationDialogModel confirmationDialogModel) {
        this.eclModel = confirmationDialogModel;
        if (confirmationDialogModel != null) {
            this.eclModel.setController(this);
        }
    }

    public String toString() {
        return "ConfirmationDialog" + this.getEclModel().toString();
    }

    public void trigger() {
        if (this.thePreviousContextValue.getValue() == 0) {
            this.theHookApplicationObject.canAction(true);
        } else if (this.thePreviousContextValue.getValue() == 1) {
            this.getEclModel().createDialog();
        } else {
            EclipseSystem.instance().exitWithError("Confirmation Dialog value unsupported = " + this.thePreviousContextValue.getValue());
        }
    }

    public void unregister() {
        if (this.theHookApplicationObject != null) {
            this.theHookApplicationObject.getDomain().unloadData(this.theHookApplicationObject.getName());
            this.theHookApplicationObject = null;
        }
        if (this.theContextApplicationObject != null) {
            this.theContextApplicationObject.unregister(this);
            this.theContextApplicationObject = null;
            this.thePreviousContextValue = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

