/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.menus;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclMenusDefaults;
import com.agilent.tntd.eclipse.viewlayer.menus.EclActionMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.MenuElementViewer;
import com.agilent.tntd.eclipse.viewlayer.menus.SelfInitialisedMenuElement;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EclConnectedMenuItem
extends EclActionMenuItem
implements CcComponent,
ApplicationObjectObserver,
SelfInitialisedMenuElement {
    static final long serialVersionUID = 2012201991906240087L;
    private String databaseVariable;
    private transient ApplicationObject theApplicationObject;

    public EclConnectedMenuItem(String string, String string2) {
        super(string);
        this.setListener(new ConnectedMenuItemActionHandler(this));
        this.databaseVariable = string2;
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.theApplicationObject = applicationObject;
        }
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("ISS", 0, this.databaseVariable, (ApplicationObjectObserver)this);
    }

    public String getInitialisationString() {
        String string = this.databaseVariable != null && this.databaseVariable.length() > 0 ? "\"" + this.databaseVariable + "\"" : "null";
        return "new " + this.getClass().getName() + "(\"" + this.getText() + "\", " + string + ")";
    }

    public void informViewer(MenuElementViewer menuElementViewer) {
        menuElementViewer.initialiseViewer(this.getText(), this.databaseVariable);
    }

    private void permanentError() {
        this.setBackground(EclMenusDefaults.permanentErrorColour);
        this.unregister();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.setText((String)objectInputStream.readObject());
                this.databaseVariable = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclConnectedMenuItem";
                throw new IOException(string);
            }
        }
    }

    public String toString() {
        return this.getText();
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        EventLog.instance().log(String.valueOf(this.toString()) + " should not receive an data from  " + applicationObject.toString());
        this.permanentError();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(this.getText());
        objectOutputStream.writeObject(this.databaseVariable);
    }

    static ApplicationObject access$theApplicationObject(EclConnectedMenuItem eclConnectedMenuItem) {
        return eclConnectedMenuItem.theApplicationObject;
    }

    private class ConnectedMenuItemActionHandler
    implements ActionListener {
        /* synthetic */ EclConnectedMenuItem this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            EclConnectedMenuItem.access$theApplicationObject(this.this$0).change(null);
            this.this$0.hideAllPopupInSelectedPath(true);
        }

        ConnectedMenuItemActionHandler(EclConnectedMenuItem eclConnectedMenuItem) {
            this.this$0 = eclConnectedMenuItem;
        }
    }
}

