/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.menus;

import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclMenusDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.PopupVisibilityObserver;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import com.agilent.tntd.eclipse.viewlayer.menus.EclPopupMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.MenuElementViewer;
import com.agilent.tntd.eclipse.viewlayer.menus.SelfInitialisedMenuElement;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EclMenu
extends Container
implements SelfInitialisedMenuElement,
CcComponent,
EclipseMenu,
MouseActionnedComponent,
PopupVisibilityObserver {
    static final long serialVersionUID = 6485110927293133598L;
    private int numberOfMenuElements;
    private String text;
    private String databaseVariableName = null;
    private transient EclipsePopupMenu thePopupMenu;
    private transient Dimension preferredSize;
    private transient boolean hasFocus = false;
    private transient Point textPosition;
    private transient int spaceforIcon = 10;
    private transient boolean remainFocused;
    protected static transient MouseActionnedComponentHandler theMouseHandler = null;

    public EclMenu(int n, String string, String string2) {
        this.numberOfMenuElements = n;
        this.text = string;
        this.databaseVariableName = string2;
        this.initialise();
    }

    EclMenu(EclMenu eclMenu, int n) {
        this(n, eclMenu.text, eclMenu.databaseVariableName);
    }

    public void addEclipseMenuElement(EclipseMenuElement eclipseMenuElement) {
        this.getPopupMenu().addEclipseMenuElement(eclipseMenuElement);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == null || !(component instanceof EclipseMenuElement)) {
            EventLog.instance().log(String.valueOf(this.toString()) + " cannot add " + component.toString() + " as one of its menu elements.");
        } else {
            this.addEclipseMenuElement((EclipseMenuElement)((Object)component));
        }
    }

    protected void createMouseHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        this.enableEvents(16L);
    }

    public void doLeftClickAction() {
    }

    public void doRightClickAction() {
    }

    public void finishInitialise() {
        String string = ((EclPopupMenu)this.getParent()).getDomainName();
        this.getPopupMenu().setDomainName(string);
        this.getPopupMenu().finishInitialise();
    }

    public EclipsePopupMenu getChildPopupMenu() {
        return this.thePopupMenu;
    }

    public Component getComponent() {
        return this;
    }

    public final Component getEclipseMenuComponent() {
        return this;
    }

    public String getInitialisationString() {
        String string = this.databaseVariableName != null && this.databaseVariableName.length() > 0 ? "\"" + this.databaseVariableName + "\"" : "null";
        return "new " + this.getClass().getName() + "(" + this.numberOfMenuElements + ", \"" + this.text + "\", " + string + ")";
    }

    public Dimension getMaximumSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    private EclipsePopupMenu getPopupMenu() {
        if (this.getChildPopupMenu() == null) {
            if (this.getParent() != null) {
                this.thePopupMenu = new EclPopupMenu(this, this, ((EclPopupMenu)this.getParent()).isAWTType(), this.databaseVariableName);
            } else {
                EventLog.instance().log(String.valueOf(this.toString()) + " doesn't know its parent when creating a popup menu, so cannot query isAWTType().");
                this.thePopupMenu = new EclPopupMenu(this, this, false, this.databaseVariableName);
            }
        }
        return this.getChildPopupMenu();
    }

    public EclipsePopupMenu getPopupParent() {
        return (EclipsePopupMenu)((Object)this.getParent());
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void hideAllPopupInSelectedPath(boolean bl) {
        if (this.getChildPopupMenu() != null) {
            this.getChildPopupMenu().getEclipseMenuComponent().setVisible(false);
        }
        EclipsePopupMenu eclipsePopupMenu = this.getPopupParent();
        eclipsePopupMenu.getEclipseMenuComponent().setVisible(false);
        while (eclipsePopupMenu.getCreator() != null) {
            eclipsePopupMenu = eclipsePopupMenu.getCreator().getPopupParent();
            eclipsePopupMenu.getEclipseMenuComponent().setVisible(false);
        }
        if (bl) {
            eclipsePopupMenu.getComponentFocusableOnClose().requestFocus();
        }
    }

    public void informViewer(MenuElementViewer menuElementViewer) {
        menuElementViewer.initialiseViewer(this.text, this.databaseVariableName);
    }

    private void initialise() {
        this.enableEvents(12L);
        this.createMouseHandler();
        FontMetrics fontMetrics = this.getFontMetrics(EclMenusDefaults.font);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n2 = fontMetrics.stringWidth(this.text) + 24 + this.spaceforIcon;
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent() + 2;
        this.preferredSize = new Dimension(n2, n3);
        this.textPosition = new Point(12, (n3 - n) / 2 + fontMetrics.getMaxAscent());
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void notifyPopupVisibilityChange(boolean bl) {
        if (this.remainFocused != bl) {
            this.remainFocused = bl;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.remainFocused || this.hasFocus()) {
            graphics.setColor(EclMenusDefaults.focusColour);
            graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            graphics.setFont(EclMenusDefaults.font);
            graphics.setColor(EclMenusDefaults.focusFontColor);
            graphics.drawString(this.text, this.textPosition.x, this.textPosition.y);
        } else {
            graphics.setFont(EclMenusDefaults.font);
            graphics.setColor(this.isEnabled() ? EclMenusDefaults.foreground : EclMenusDefaults.shadow);
            graphics.drawString(this.text, this.textPosition.x, this.textPosition.y);
        }
        int n = this.getBounds().width - 12 - 3;
        int n2 = (this.getBounds().height + 5) / 2;
        graphics.drawLine(n, n2 - 5, n, n2);
        graphics.drawLine(++n, n2 - 4, n, n2 - 1);
        graphics.drawLine(++n, n2 - 3, n, n2 - 2);
    }

    public int populateYourself(SelfInitialisedMenuElement[] selfInitialisedMenuElementArray, int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < this.numberOfMenuElements) {
            this.addEclipseMenuElement(selfInitialisedMenuElementArray[n2]);
            n2 = selfInitialisedMenuElementArray[n2].populateYourself(selfInitialisedMenuElementArray, n2 + 1);
            ++n3;
        }
        return n2;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.hasFocus) break;
                this.showPopupMenuForMenu();
                this.hasFocus = true;
                super.requestFocus();
                break;
            }
            case 1005: {
                if (focusEvent.isTemporary()) {
                    this.hideAllPopupInSelectedPath(true);
                    break;
                }
                this.hasFocus = false;
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 10: 
                case 39: {
                    this.showPopupMenuForMenu();
                    this.remainFocused = true;
                    this.getPopupMenu().getEclipseMenuComponent().requestFocus();
                    keyEvent.consume();
                    break;
                }
                case 27: 
                case 107: 
                case 119: {
                    this.hideAllPopupInSelectedPath(true);
                    keyEvent.consume();
                    break;
                }
                case 113: {
                    this.hideAllPopupInSelectedPath(true);
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            ((EclPopupMenu)this.getParent()).processKeyEvent(keyEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        theMouseHandler.processMouseEvent(mouseEvent, this, this.hasFocus, this.isEnabled());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.numberOfMenuElements = objectInputStream.readInt();
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.text = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclMenu";
                throw new IOException(string);
            }
        }
    }

    public final void removeNotify() {
        super.removeNotify();
        if (this.hasFocus) {
            this.processFocusEvent(new FocusEvent(this, 1005));
        }
    }

    public void requestFocus() {
        if (!this.hasFocus && EclipseFocusManager.getInstance().canRequestFocus(this)) {
            super.requestFocus();
        }
    }

    public boolean selectPath(EclipsePopupMenu eclipsePopupMenu) {
        boolean bl = false;
        if (this.isEnabled()) {
            if (this.getPopupParent().getCreator() != null) {
                if (this.getPopupParent().getCreator().selectPath(eclipsePopupMenu)) {
                    this.remainFocused = true;
                    this.showPopupMenuForMenu();
                    bl = true;
                }
            } else if (this.getPopupParent() == eclipsePopupMenu) {
                this.remainFocused = true;
                this.showPopupMenuForMenu();
                bl = true;
            }
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        if (!bl && this.getChildPopupMenu() != null && this.getChildPopupMenu().getEclipseMenuComponent().isVisible()) {
            this.requestFocus();
            this.getChildPopupMenu().getEclipseMenuComponent().setVisible(false);
        }
        super.setEnabled(bl);
        if (!bl && this.hasFocus() && this.getParent().isVisible()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void setVisible(boolean bl) {
        if (!bl && this.getPopupMenu().getEclipseMenuComponent().isVisible()) {
            this.requestFocus();
            this.getPopupMenu().getEclipseMenuComponent().setVisible(false);
        }
        super.setVisible(bl);
        if (!bl && this.hasFocus() && this.getParent().isVisible()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    private void showPopupMenuForMenu() {
        this.getPopupMenu().setComponentFocusableOnClose(this);
        this.getPopupMenu().showRelativeToComponent(this, this.getBounds().width - 3, 0);
    }

    public String toString() {
        return this.text;
    }

    public void unregister() {
        this.getPopupMenu().unregister();
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeInt(this.numberOfMenuElements);
        objectOutputStream.writeObject(this.databaseVariableName);
        objectOutputStream.writeObject(this.text);
    }
}

