/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.menus;

import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclMenusDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import com.agilent.tntd.eclipse.viewlayer.menus.EclPopupMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.SelfInitialisedMenuElement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public abstract class EclMenuItem
extends Component
implements EclipseMenuElement,
MouseActionnedComponent {
    static final long serialVersionUID = -7870809508126914113L;
    private String text;
    private transient Dimension preferredSize;
    private transient boolean hasFocus = false;
    private transient Point textPosition;
    protected static transient MouseActionnedComponentHandler theMouseHandler = null;

    public EclMenuItem(String string) {
        this.text = string;
        this.setFont(EclMenusDefaults.font);
        if (this.isFocusTraversable()) {
            this.enableEvents(12L);
            this.createButtonHandler();
        }
        this.initialisePreferredSizeAndTextPosition();
    }

    protected void createButtonHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        this.enableEvents(16L);
    }

    protected abstract void doAction();

    public final void doLeftClickAction() {
        this.genericAction();
        this.doAction();
    }

    public void doRightClickAction() {
    }

    private void genericAction() {
        this.hideAllPopupInSelectedPath(false);
    }

    public Component getComponent() {
        return this;
    }

    public final Component getEclipseMenuComponent() {
        return this;
    }

    public Dimension getMaximumSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }

    public EclipsePopupMenu getPopupParent() {
        return (EclipsePopupMenu)((Object)this.getParent());
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    protected String getText() {
        return this.text;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void hideAllPopupInSelectedPath(boolean bl) {
        EclipsePopupMenu eclipsePopupMenu = this.getPopupParent();
        eclipsePopupMenu.getEclipseMenuComponent().setVisible(false);
        while (eclipsePopupMenu.getCreator() != null) {
            eclipsePopupMenu = eclipsePopupMenu.getCreator().getPopupParent();
            eclipsePopupMenu.getEclipseMenuComponent().setVisible(false);
        }
        if (bl) {
            eclipsePopupMenu.getComponentFocusableOnClose().requestFocus();
        }
    }

    private void initialisePreferredSizeAndTextPosition() {
        FontMetrics fontMetrics = this.getFontMetrics(EclMenusDefaults.font);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n2 = fontMetrics.stringWidth(this.text) + 24;
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent() + 2;
        this.preferredSize = new Dimension(n2, n3);
        this.textPosition = new Point(12, (n3 - n) / 2 + fontMetrics.getMaxAscent());
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.getFont());
        if (this.hasFocus()) {
            graphics.setColor(EclMenusDefaults.focusColour);
            graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            graphics.setColor(EclMenusDefaults.focusFontColor);
        } else {
            graphics.setColor(this.isEnabled() ? this.getForeground() : EclMenusDefaults.shadow);
        }
        graphics.drawString(this.text, this.textPosition.x, this.textPosition.y);
    }

    public int populateYourself(SelfInitialisedMenuElement[] selfInitialisedMenuElementArray, int n) {
        return n;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                this.hasFocus = true;
                break;
            }
            case 1005: {
                if (focusEvent.isTemporary()) {
                    this.hideAllPopupInSelectedPath(true);
                    break;
                }
                this.hasFocus = false;
            }
        }
        this.repaint();
    }

    protected final void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 27: 
                case 107: {
                    this.hideAllPopupInSelectedPath(true);
                    keyEvent.consume();
                    break;
                }
                case 113: {
                    this.hideAllPopupInSelectedPath(true);
                    break;
                }
                case 10: {
                    this.genericAction();
                    this.doAction();
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            ((EclPopupMenu)this.getParent()).processKeyEvent(keyEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        theMouseHandler.processMouseEvent(mouseEvent, this, this.hasFocus, this.isEnabled());
    }

    public final void removeNotify() {
        super.removeNotify();
        if (this.hasFocus) {
            this.processFocusEvent(new FocusEvent(this, 1005));
        }
    }

    public void requestFocus() {
        if (!this.hasFocus && EclipseFocusManager.getInstance().canRequestFocus(this)) {
            super.requestFocus();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.hasFocus() && this.getParent().isVisible()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    protected void setText(String string) {
        this.text = string;
        this.initialisePreferredSizeAndTextPosition();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.hasFocus() && this.getParent().isVisible()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }
}

