/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.menus;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers.MenuLayout;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclMenusDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenuParent;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.PopupContainerFactory;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.PopupVisibilityObserver;
import com.agilent.tntd.eclipse.viewlayer.menus.EclSeparatorMenuItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class EclPopupMenu
extends Container
implements EclipsePopupMenu,
MaskedIntegerDataReceiver {
    private transient EclipseMenu thePopupCreator;
    private transient Component componentFocusableOnClose;
    private static transient UnconsumedKeyHandler theMainKeyController;
    private transient Container visibleContainer;
    private transient Insets insets = new Insets(4, 4, 4, 4);
    private transient ApplicationObject theApplicationObject = null;
    private transient MaskedIntegerValue currentValue = null;
    private transient String domainName = "ISS";
    private transient PopupVisibilityObserver theVisibilityObserver;
    private transient boolean hasFocus = false;
    private transient EclipsePopupMenuParent thePopupParent;
    private transient boolean hasTrappedTransientError = false;
    private transient String theDatabaseVariableName = null;

    public EclPopupMenu(EclipseMenu eclipseMenu, PopupVisibilityObserver popupVisibilityObserver, boolean bl, String string) {
        this.theDatabaseVariableName = string;
        this.thePopupCreator = eclipseMenu;
        int n = EclipseSystem.instance().isOnInstrument() ? 2 : 0;
        this.setLayout(new MenuLayout(n));
        this.theVisibilityObserver = popupVisibilityObserver;
        if (bl) {
            this.visibleContainer = new Panel();
            this.visibleContainer.setLayout(new BorderLayout());
            this.visibleContainer.add((Component)this, "Center");
        } else {
            this.visibleContainer = this;
        }
        this.enableEvents(12L);
        this.setBackground(EclMenusDefaults.background);
        this.setVisible(false);
    }

    public EclPopupMenu(boolean bl) {
        this(bl, null);
    }

    public EclPopupMenu(boolean bl, String string) {
        this(null, null, bl, string);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.hasTrappedTransientError = true;
            this.theApplicationObject = applicationObject;
        }
    }

    public void addEclipseMenuElement(EclipseMenuElement eclipseMenuElement) {
        this.add(eclipseMenuElement.getEclipseMenuComponent());
    }

    public void addEclipseMenuElement(EclipseMenuElement eclipseMenuElement, int n) {
        this.add(eclipseMenuElement.getEclipseMenuComponent(), n);
    }

    public void finishInitialise() {
        if (this.theDatabaseVariableName != null) {
            ApplicationManager.instance().request(this.getDomainName(), 0, this.theDatabaseVariableName, (ApplicationObjectObserver)this);
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).finishInitialise();
            }
            ++n;
        }
    }

    private void fitMenuInsideParent(int n) {
        boolean bl;
        Rectangle rectangle = this.visibleContainer.getBounds();
        Dimension dimension = this.visibleContainer.getParent().getSize();
        boolean bl2 = rectangle.x + rectangle.width > dimension.width;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        if (bl2) {
            n2 = dimension.width - rectangle.width - 8;
        }
        boolean bl3 = bl = rectangle.y + rectangle.height > dimension.height;
        if (bl && (n3 = rectangle.y + n - rectangle.height - 2) < 0) {
            n3 = 0;
        }
        this.visibleContainer.setLocation(n2, n3);
    }

    public Component getComponentFocusableOnClose() {
        return this.componentFocusableOnClose;
    }

    public Container getContainer() {
        return this.visibleContainer;
    }

    public EclipseMenu getCreator() {
        return this.thePopupCreator;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public final Component getEclipseMenuComponent() {
        return this;
    }

    public Insets getInsets() {
        return this.insets;
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclPopupMenu.theMainKeyController != null) break block2;
            var1_1 = this.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclPopupMenu.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclPopupMenu.theMainKeyController;
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    private boolean hasFocus() {
        return this.hasFocus;
    }

    protected boolean hasTrappedTransientError() {
        return this.hasTrappedTransientError;
    }

    private void hideAllPopupInSelectedPath(boolean bl) {
        EclipsePopupMenu eclipsePopupMenu = this;
        eclipsePopupMenu.getEclipseMenuComponent().setVisible(false);
        while (eclipsePopupMenu.getCreator() != null) {
            eclipsePopupMenu = eclipsePopupMenu.getCreator().getPopupParent();
            eclipsePopupMenu.getEclipseMenuComponent().setVisible(false);
        }
        if (bl) {
            eclipsePopupMenu.getComponentFocusableOnClose().requestFocus();
        }
    }

    public boolean isAWTType() {
        return this.visibleContainer != this;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.hasTrappedTransientError()) {
            graphics.setColor(EclMenusDefaults.transientErrorColour);
        } else {
            graphics.setColor(EclMenusDefaults.background);
        }
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        super.paint(graphics);
        int n = rectangle.width - 1;
        int n2 = rectangle.height - 1;
        int n3 = 0;
        while (n3 < 4) {
            graphics.setColor(EclMenusDefaults.highlight);
            graphics.drawLine(n3, n3, n - n3, n3);
            graphics.drawLine(n3, n3, n3, n2 - n3);
            graphics.setColor(EclMenusDefaults.shadow);
            graphics.drawLine(n - n3, n3, n - n3, n2 - n3);
            graphics.drawLine(n3, n2 - n3, n - n3, n2 - n3);
            ++n3;
        }
    }

    private void permanentError() {
        this.setBackground(EclMenusDefaults.permanentErrorColour);
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.currentValue = null;
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                this.hasFocus = true;
                break;
            }
            case 1005: {
                if (focusEvent.isTemporary()) {
                    this.hideAllPopupInSelectedPath(true);
                    break;
                }
                this.hasFocus = false;
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 37: {
                    if (this.getCreator() != null) {
                        this.getCreator().getEclipseMenuComponent().requestFocus();
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, keyEvent.getComponent());
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.currentValue)) {
                this.currentValue = maskedIntegerValue;
                Component[] componentArray = this.getComponents();
                int n = maskedIntegerValue.getValue();
                int n2 = 0;
                int n3 = 0;
                int n4 = componentArray.length;
                while (n2 != n4 && componentArray[n2] instanceof EclSeparatorMenuItem) {
                    ++n2;
                }
                while (n3 != n && n2 != n4) {
                    componentArray[n2].setEnabled(maskedIntegerValue.getStateMask().query(n3));
                    componentArray[n2].setVisible(maskedIntegerValue.getOptionMask().query(n3));
                    ++n3;
                    ++n2;
                    while (n2 != n4 && componentArray[n2] instanceof EclSeparatorMenuItem) {
                        ++n2;
                    }
                }
                this.trapTransientError(n3 != n || n2 != n4);
                this.visibleContainer.setSize(this.getPreferredSize());
                this.visibleContainer.doLayout();
                this.visibleContainer.repaint();
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public final void removeNotify() {
        super.removeNotify();
        if (this.hasFocus) {
            this.processFocusEvent(new FocusEvent(this, 1005));
        }
    }

    public void requestFocus() {
        int n = 0;
        while (n < this.getComponentCount()) {
            if (this.getComponent(n).isFocusTraversable() && this.getComponent(n).isVisible() && this.getComponent(n).isEnabled()) {
                this.getComponent(n).requestFocus();
                return;
            }
            ++n;
        }
        if (this.getCreator() != null) {
            this.getCreator().getEclipseMenuComponent().requestFocus();
        } else if (!this.hasFocus && EclipseFocusManager.getInstance().canRequestFocus(this)) {
            super.requestFocus();
        }
    }

    public void setBackground(Color color) {
        if (this.visibleContainer == this) {
            super.setBackground(color);
        } else {
            this.visibleContainer.setBackground(color);
        }
    }

    public void setComponentFocusableOnClose(Component component) {
        this.componentFocusableOnClose = component;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    void setVisibilityObserver(PopupVisibilityObserver popupVisibilityObserver) {
        this.theVisibilityObserver = popupVisibilityObserver;
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() != bl) {
            super.setVisible(bl);
            if (this.visibleContainer != this) {
                this.visibleContainer.setVisible(bl);
            }
            if (this.theVisibilityObserver != null) {
                this.theVisibilityObserver.notifyPopupVisibilityChange(bl);
            }
            if (this.thePopupParent != null) {
                this.thePopupParent.notifyPopupVisibilityChanged(bl, this);
            }
        }
    }

    public void showRelativeToComponent(Component component, int n, int n2) {
        if (this.isAWTType()) {
            this.visibleContainer.setLocation(-200, -200);
        }
        this.thePopupParent = PopupContainerFactory.getInstance().addEclipsePopupMenu(this);
        this.visibleContainer.setSize(this.getPreferredSize());
        int n3 = 0;
        if (component != this.visibleContainer.getParent()) {
            Point point = component.getLocationOnScreen();
            this.visibleContainer.getParent().setVisible(true);
            Point point2 = this.visibleContainer.getParent().getLocationOnScreen();
            int n4 = point.x + n - point2.x;
            int n5 = point.y + n2 - point2.y;
            this.visibleContainer.setLocation(n4, n5);
            n3 = -n2;
        } else {
            this.visibleContainer.setLocation(n, n2);
        }
        this.fitMenuInsideParent(n3);
        this.setVisible(true);
        this.visibleContainer.validate();
        this.visibleContainer.doLayout();
    }

    public String toString() {
        String string = this.getCreator() == null ? "" : "[" + this.getCreator().toString() + "]";
        String string2 = this.getName();
        if (string2 == null) {
            string2 = "EclPopupMenu";
        }
        return String.valueOf(string2) + string;
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.currentValue = null;
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof CcComponent) {
                ((CcComponent)((Object)componentArray[n])).unregister();
            }
            ++n;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

