/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.menus;

import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.MenuPathSelector;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.MenuElementViewer;
import com.agilent.tntd.eclipse.viewlayer.menus.SelfInitialisedMenuElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class EclWindowMenuItem
extends EclMenuItem
implements SelfInitialisedMenuElement,
MenuPathSelector,
CcComponent {
    static final long serialVersionUID = 4622009226612409888L;
    private String completeClassName;
    private transient InternalWindow theObserver;

    public EclWindowMenuItem(String string, String string2) {
        super(string);
        this.completeClassName = string2;
    }

    public boolean attemptSelectPopupPath(EclipsePopupMenu eclipsePopupMenu) {
        if (this.isEnabled() && this.isVisible()) {
            EclipseMenu eclipseMenu = this.getPopupParent().getCreator();
            if (eclipseMenu != null) {
                if (eclipseMenu.selectPath(eclipsePopupMenu)) {
                    this.requestFocus();
                    return true;
                }
            } else if (eclipsePopupMenu == this.getPopupParent()) {
                this.requestFocus();
                return true;
            }
        }
        return false;
    }

    public void changeAssociatedWindow(String string, String string2) {
        this.setText(string);
        this.completeClassName = string2;
    }

    protected void doAction() {
        WindowManager.instance().createWindow(this.completeClassName);
    }

    public void finishInitialise() {
        WindowManager.instance().recordMenuItem(this.completeClassName, this);
    }

    public String getInitialisationString() {
        return "new " + this.getClass().getName() + "(\"" + this.getText() + "\", \"" + this.completeClassName + "\")";
    }

    public void informViewer(MenuElementViewer menuElementViewer) {
        menuElementViewer.initialiseViewer(this.getText(), this.completeClassName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.setText((String)objectInputStream.readObject());
                this.completeClassName = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclWindowMenuItem";
                throw new IOException(string);
            }
        }
    }

    public void registerObserver(InternalWindow internalWindow) {
        this.theObserver = internalWindow;
        this.theObserver.notifyContextChange(this.isEnabled());
    }

    public void setEnabled(boolean bl) {
        if (this.theObserver != null && this.isEnabled() != bl) {
            this.theObserver.notifyContextChange(bl);
        }
        super.setEnabled(bl);
    }

    public String toString() {
        return this.getText();
    }

    public void unregister() {
    }

    public void unregisterObserver(InternalWindow internalWindow) {
        if (internalWindow == this.theObserver) {
            this.theObserver = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(0);
        objectOutputStream.writeObject(this.getText());
        objectOutputStream.writeObject(this.completeClassName);
    }
}

