/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.menus.popuputilities;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclMenusDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.PopupPropertiesReceiver;
import com.agilent.tntd.eclipse.viewlayer.menus.EclActionMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.EclPopupMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.EclSeparatorMenuItem;
import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class PopupMenuElementsManager
implements PopupPropertiesReceiver,
CcConnectedComponent,
MaskedIntegerDataReceiver {
    private EclPopupMenu thePopup;
    private String theDatabaseVariableName;
    private String theDomainName;
    private ApplicationObject theApplicationObject;
    private transient MaskedIntegerValue currentValue = null;
    private ArrayList theItems = new ArrayList();
    private Component[] components;
    private boolean hasTrappedTransientError = false;

    public PopupMenuElementsManager(EclPopupMenu eclPopupMenu) {
        this.thePopup = eclPopupMenu;
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.hasTrappedTransientError = true;
            this.theApplicationObject = applicationObject;
        }
    }

    public void addEclipseMenuElement(EclipseMenuElement eclipseMenuElement) {
        this.thePopup.addEclipseMenuElement(eclipseMenuElement);
        this.theItems.add((Object)eclipseMenuElement.getEclipseMenuComponent());
    }

    public EclipseMenuElement createExitMenuItem() {
        return new EclActionMenuItem("Exit", new ExitMenuHandler(this));
    }

    public void finishInitialise() {
        if (this.theDatabaseVariableName != null) {
            ApplicationManager.instance().request(this.theDomainName, 0, this.theDatabaseVariableName, (ApplicationObjectObserver)this);
        }
    }

    private Component[] getComponents() {
        if (this.components == null) {
            this.components = new Component[this.theItems.size()];
            this.theItems.toArray((Object[])this.components);
            this.theItems.clear();
            this.theItems = null;
        }
        return this.components;
    }

    boolean hasTrappedTransientError() {
        return this.hasTrappedTransientError;
    }

    private void permanentError() {
        this.thePopup.setBackground(EclMenusDefaults.permanentErrorColour);
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.currentValue = null;
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.currentValue)) {
                this.currentValue = maskedIntegerValue;
                Component[] componentArray = this.getComponents();
                int n = maskedIntegerValue.getValue();
                int n2 = 0;
                int n3 = 0;
                int n4 = componentArray.length;
                while (n2 != n4 && componentArray[n2] instanceof EclSeparatorMenuItem) {
                    ++n2;
                }
                while (n3 != n && n2 != n4) {
                    componentArray[n2].setEnabled(maskedIntegerValue.getStateMask().query(n3));
                    componentArray[n2].setVisible(maskedIntegerValue.getOptionMask().query(n3));
                    ++n3;
                    ++n2;
                    while (n2 != n4 && componentArray[n2] instanceof EclSeparatorMenuItem) {
                        ++n2;
                    }
                }
                this.trapTransientError(n3 != n || n2 != n4);
                this.thePopup.getContainer().setSize(this.thePopup.getPreferredSize());
                this.thePopup.getContainer().doLayout();
                this.thePopup.getContainer().repaint();
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setVariableProperties(String string, String string2) {
        this.theDatabaseVariableName = string2;
        this.theDomainName = string;
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.currentValue = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }

    private class ExitMenuHandler
    implements ActionListener {
        /* synthetic */ PopupMenuElementsManager this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            EclipseSystem.instance().exit();
        }

        ExitMenuHandler(PopupMenuElementsManager popupMenuElementsManager) {
            this.this$0 = popupMenuElementsManager;
        }
    }
}

