/*
 * Decompiled with CFR 0.152.
 */
package test.domainemulation.core;

import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.GenericApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import java.io.IOException;
import java.util.Random;
import test.domainemulation.core.GraphInfoGenerator;

public class GraphDataGenerator
extends GenericApplicationData {
    private int dataValue = 0;
    private GraphInfoGenerator theGraphInfoGenerator;

    public GraphDataGenerator(GraphInfoGenerator graphInfoGenerator) {
        this.theGraphInfoGenerator = graphInfoGenerator;
    }

    private ApplicationData createData(int n, String string, String string2, String string3, float f, float f2) {
        ApplicationGenericData applicationGenericData;
        float f3 = this.getGraphInfoGenerator().getEndOfData();
        if (f2 > f3) {
            f2 = f3;
        }
        if (f2 < f) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createData: Invalid parameters passed by client; maxX is less than minX!");
            applicationGenericData = new ApplicationGenericData(null);
        } else {
            int n2 = this.getGraphInfoGenerator().isXAxisLogScale() ? (int)(Math.round(Math.log(f2 - f) / Math.log(10.0)) + 1L) : Math.round(f2 - f) + 1;
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            try {
                simpleTypesWriter.write(n);
                simpleTypesWriter.write(n2);
                new Random();
                int n3 = Math.round(f);
                int n4 = this.getGraphInfoGenerator().isXAxisLogScale() ? (int)Math.round(Math.log(n3) / Math.log(10.0)) : n3;
                int n5 = this.getGraphInfoGenerator().isXAxisLogScale() ? (int)Math.round(Math.log(n3) / Math.log(10.0)) + n2 : n3 + n2;
                int n6 = n4;
                while (n6 < n5) {
                    float f4 = this.getGraphInfoGenerator().isXAxisLogScale() ? (float)Math.pow(10.0, n6) : (float)n6;
                    float f5 = (float)this.dataValue + f4 + (float)((int)this.getGraphInfoGenerator().getYMin());
                    if (f5 > this.getGraphInfoGenerator().getYMax()) {
                        f5 = this.dataValue;
                    }
                    simpleTypesWriter.write(f4);
                    simpleTypesWriter.write(f5);
                    if (n == 2) {
                        simpleTypesWriter.write(0.0f);
                    } else {
                        simpleTypesWriter.write(1.0f);
                    }
                    ++n6;
                }
                this.dataValue = this.getGraphInfoGenerator().isXAxisLogScale() ? (this.dataValue *= 10) : (this.dataValue += 25);
                if ((float)this.dataValue > this.getGraphInfoGenerator().getYMax()) {
                    this.dataValue = 0;
                }
                applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            }
            catch (IOException iOException) {
                applicationGenericData = new ApplicationGenericData(null);
            }
        }
        return applicationGenericData;
    }

    private GraphInfoGenerator getGraphInfoGenerator() {
        return this.theGraphInfoGenerator;
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        ApplicationData applicationData;
        ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)this.description();
        SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
        simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
        try {
            int n = simpleTypesReader.readInt();
            String string = simpleTypesReader.readString();
            String string2 = simpleTypesReader.readString();
            String string3 = simpleTypesReader.readString();
            float f = simpleTypesReader.readFloat();
            float f2 = simpleTypesReader.readFloat();
            applicationData = this.createData(n, string, string2, string3, f, f2);
        }
        catch (IOException iOException) {
            EventLog.instance().log("GraphDataGenerator could not read this version of the meta data.");
            applicationData = new ApplicationGenericData(null);
        }
        applicationData.receivedBy(applicationDataReceiver, applicationDataSender);
    }
}

