/*
 * Decompiled with CFR 0.152.
 */
package test.domainemulation.core;

import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.GenericApplicationData;
import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import java.io.IOException;
import test.domainemulation.core.GenericDataCreator;

public class GraphInfoGenerator
extends GenericApplicationData
implements GenericDataCreator {
    private boolean initialized = false;
    private int newDataCount = 0;
    private float theEnd = 0.0f;
    private float eod = 0.0f;
    private boolean xAxisLog = false;
    private boolean yAxisLog = false;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;

    public GraphInfoGenerator() {
        this.initialize();
    }

    private ApplicationData createData(int n) {
        ApplicationGenericData applicationGenericData;
        SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
        simpleTypesWriter.initialiseByteArrayToWrite();
        if (!this.initialized) {
            try {
                simpleTypesWriter.write(n);
                simpleTypesWriter.write(this.xMin);
                simpleTypesWriter.write(this.xMax);
                simpleTypesWriter.write(this.yMin);
                simpleTypesWriter.write(this.yMax);
                simpleTypesWriter.write(this.xAxisLog);
                simpleTypesWriter.write(this.yAxisLog);
                simpleTypesWriter.write(this.eod);
                float f = this.eod - 10.0f;
                if (f < 0.0f && (f = this.eod - 1.0f) < 0.0f) {
                    f = 0.0f;
                }
                simpleTypesWriter.write(f);
                applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
                this.initialized = true;
            }
            catch (IOException iOException) {
                applicationGenericData = new ApplicationGenericData(null);
            }
        } else if (this.newDataCount < 25) {
            try {
                if (this.eod < this.theEnd) {
                    this.eod = this.xAxisLog ? (this.eod *= 10.0f) : (this.eod += 1.0f);
                }
                simpleTypesWriter.write(0);
                simpleTypesWriter.write(this.eod);
                applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
                ++this.newDataCount;
            }
            catch (IOException iOException) {
                applicationGenericData = new ApplicationGenericData(null);
            }
        } else {
            applicationGenericData = null;
        }
        return applicationGenericData;
    }

    public ApplicationData getDataButDifferent(RawDataID rawDataID, ApplicationMetaData applicationMetaData) {
        ApplicationData applicationData = null;
        if (this.initialized) {
            applicationData = this.createData(0);
        }
        return applicationData;
    }

    public float getEndOfData() {
        return this.eod;
    }

    float getYMax() {
        return this.yMax;
    }

    float getYMin() {
        return this.yMin;
    }

    private void initialize() {
        if (this.xAxisLog) {
            this.theEnd = 400000.0f;
            this.eod = 10000.0f;
            this.xMin = 10.0f;
            this.xMax = 400000.0f;
        } else {
            this.theEnd = 100.0f;
            this.eod = 85.0f;
            this.xMin = 0.0f;
            this.xMax = 100.0f;
        }
        if (this.yAxisLog) {
            this.yMin = 0.1f;
            this.yMax = 20.0f;
        } else {
            this.yMin = -500.0f;
            this.yMax = 500.0f;
        }
    }

    public boolean isXAxisLogScale() {
        return this.xAxisLog;
    }

    public boolean isYAxisLogScale() {
        return this.yAxisLog;
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        ApplicationData applicationData;
        ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)this.description();
        SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
        simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
        try {
            int n = simpleTypesReader.readInt();
            applicationData = this.createData(n);
        }
        catch (IOException iOException) {
            EventLog.instance().log("GraphInfoGenerator could not read this version of the meta data.");
            applicationData = new ApplicationGenericData(null);
        }
        applicationData.receivedBy(applicationDataReceiver, applicationDataSender);
    }
}

