/*
 * Decompiled with CFR 0.152.
 */
package test.domainemulation.core;

import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.GenericApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import java.io.IOException;
import java.util.Random;
import test.domainemulation.core.SessionDataGenerator;

public class MRSGraphDataGenerator
extends GenericApplicationData {
    private final int numDataPts = 60;
    private int sawToothValue = 0;
    private final SessionDataGenerator sessionDataGenerator;

    public MRSGraphDataGenerator(SessionDataGenerator sessionDataGenerator) {
        this.sessionDataGenerator = sessionDataGenerator;
    }

    private ApplicationData createData(int n, String string, String string2, long l, long l2, long l3) {
        ApplicationGenericData applicationGenericData;
        int n2;
        long l4 = this.getSessionDataGenerator().getEndOfData();
        long l5 = 0L;
        if (l2 == l) {
            l5 = l4;
        } else {
            long l6 = l5 = l4 < l2 ? l4 : l2;
        }
        if (l5 < l) {
            l5 = l;
        }
        n2 = (n2 = Math.round((l5 - l) / l3)) < 60 ? n2 + 1 : 61;
        SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
        simpleTypesWriter.initialiseByteArrayToWrite();
        try {
            simpleTypesWriter.write(n);
            simpleTypesWriter.write(n2);
            if (string2.equalsIgnoreCase("Histogram") || string2.equals("CUM")) {
                Random random = new Random();
                int n3 = 0;
                while (n3 < n2) {
                    float f = Math.abs(random.nextInt()) + 1;
                    if (f > 0.0f) {
                        simpleTypesWriter.write(f);
                    } else {
                        EventLog.instance().log("ERROR: GraphDataGenerator: Invalid data created for Histogram");
                    }
                    ++n3;
                }
            } else if (string2.equalsIgnoreCase("Alarms") || string2.equals("LOS") || string2.equals("LOF") || string2.equals("OOF") || string2.equals("MS_AIS") || string2.equals("MS_RDI") || string2.equals("POWER_FAIL")) {
                Random random = new Random();
                int n4 = 0;
                while (n4 < n2) {
                    float f = Math.round(random.nextFloat());
                    simpleTypesWriter.write(f);
                    ++n4;
                }
            } else if (string2.equalsIgnoreCase("Continuous") || string2.equals("TU_PTR")) {
                int n5 = 0;
                while (n5 < n2) {
                    float f = (float)Math.sin((double)((long)n5 + l) * 6.0 * (double)l3);
                    simpleTypesWriter.write(f);
                    ++n5;
                }
            } else {
                int n6 = 0;
                while (n6 < n2) {
                    float f = this.sawToothValue;
                    simpleTypesWriter.write(f);
                    this.sawToothValue = this.sawToothValue > 5500 ? 0 : (this.sawToothValue += 500);
                    ++n6;
                }
            }
            applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            applicationGenericData = new ApplicationGenericData(null);
        }
        return applicationGenericData;
    }

    private SessionDataGenerator getSessionDataGenerator() {
        return this.sessionDataGenerator;
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        ApplicationData applicationData;
        ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)this.description();
        SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
        simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
        try {
            int n = simpleTypesReader.readInt();
            String string = simpleTypesReader.readString();
            String string2 = simpleTypesReader.readString();
            long l = simpleTypesReader.readLong();
            long l2 = simpleTypesReader.readLong();
            long l3 = simpleTypesReader.readLong();
            applicationData = this.createData(n, string, string2, l, l2, l3);
        }
        catch (IOException iOException) {
            EventLog.instance().log("GraphDataGenerator could not read this version of the meta data.");
            applicationData = new ApplicationGenericData(null);
        }
        applicationData.receivedBy(applicationDataReceiver, applicationDataSender);
    }
}

