/*
 * Decompiled with CFR 0.152.
 */
package test.domainemulation.core;

import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.FrameAnonymousUpdateNotify;
import com.agilent.tntd.eclipse.issdb.common.IssCmdKnownObjectChangeNotify;
import com.agilent.tntd.eclipse.middleware.MessageHandler;
import com.agilent.tntd.eclipse.middleware.WcMessage;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseThread;
import test.domainemulation.core.GenericDataCreator;

public class MessageGenerator
extends Thread
implements EclipseThread {
    private MessageHandler handler;
    private boolean stopped;
    private final Object lock = new Object();
    private RawDataID id;
    private GenericDataCreator dataAccessor;

    public MessageGenerator(MessageHandler messageHandler) {
        super(EclipseSystem.instance().getEclipseThreadGroup(), "Messages Generator");
        this.setPriority(10);
        this.handler = messageHandler;
        this.stopped = false;
    }

    private synchronized boolean isActive() {
        return !this.stopped;
    }

    public void run() {
        if (this.id == null) {
            EventLog.instance().log("Message Generator: id is null");
        }
        while (this.isActive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                EventLog.instance().log("Interrupted the sleep of the Message Generator.");
            }
            this.scheduleMessage(new FrameAnonymousUpdateNotify(2, 0));
            if (this.id == null) continue;
            ApplicationData applicationData = null;
            if (this.dataAccessor != null) {
                applicationData = this.dataAccessor.getDataButDifferent(this.id, null);
            }
            this.scheduleMessage(new IssCmdKnownObjectChangeNotify(this.id, applicationData));
        }
    }

    public void scheduleMessage(WcMessage wcMessage) {
        Object object = this.lock;
        synchronized (object) {
            this.handler.handleMessage(wcMessage);
        }
    }

    public synchronized void stopEclipseThread() {
        this.stopped = true;
    }

    public void update(RawDataID rawDataID, GenericDataCreator genericDataCreator) {
        if (this.id != null) {
            System.out.println(String.valueOf(this.toString()) + " cannot set more than 1 id for known change.");
            System.exit(0);
        }
        this.id = rawDataID;
        this.dataAccessor = genericDataCreator;
    }
}

