/*
 * Decompiled with CFR 0.152.
 */
package test.domainemulation.core;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReader;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataGroup;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.client.GenericIssDataAccessor;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.FrameAnonymousUpdateNotify;
import com.agilent.tntd.eclipse.issdb.common.FrameGroupMessage;
import com.agilent.tntd.eclipse.issdb.common.IssCmdKnownObjectChangeNotify;
import com.agilent.tntd.eclipse.issdb.common.IssCmdRequestObjectIDHandler;
import com.agilent.tntd.eclipse.issdb.common.IssDataID;
import com.agilent.tntd.eclipse.issdb.common.IssRspAsyncQuery;
import com.agilent.tntd.eclipse.issdb.common.IssRspAsyncRequestObjectID;
import com.agilent.tntd.eclipse.issdb.common.IssRspChange;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.WcMessage;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Random;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.StringTokenizer;
import test.domainemulation.core.CollectionOfMessages;
import test.domainemulation.core.CompositeDataReaderExample;
import test.domainemulation.core.DatabaseEmulator;
import test.domainemulation.core.GenericDataCreator;
import test.domainemulation.core.GraphDataGenerator;
import test.domainemulation.core.GraphInfoGenerator;
import test.domainemulation.core.MRSGraphDataGenerator;
import test.domainemulation.core.MessageGenerator;
import test.domainemulation.core.PaddedString;
import test.domainemulation.core.SessionAgentDataGenerator;
import test.domainemulation.core.SessionDataGenerator;
import test.domainemulation.core.SessionInfoGenerator;
import test.domainemulation.core.StatusLineData;
import test.domainemulation.core.TableDataGenerator;

public class TestDataAccess
extends GenericIssDataAccessor
implements GenericDataCreator,
IssCmdRequestObjectIDHandler {
    private DatabaseEmulator myDatabase;
    private HashMap theNameToID = new HashMap();
    private HashMap theIdToName = new HashMap();
    private MessageGenerator generator;

    public TestDataAccess(byte by) {
        this.setClientID(by);
        this.initialise();
    }

    private void addSizedText(StringBuffer stringBuffer, String string, int n, boolean bl) {
        int n2 = n - string.length();
        if (n2 > 0) {
            if (bl) {
                stringBuffer.append(string);
            }
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(" ");
                ++n3;
            }
            if (!bl) {
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(",");
    }

    private void createApplicationDataGroup(String string, int n, int n2, String[] stringArray) {
        this.storeIDforName(string, new IssDataID(n2, 0, n));
        ApplicationDataGroup applicationDataGroup = new ApplicationDataGroup();
        int n3 = 0;
        while (n3 < stringArray.length) {
            applicationDataGroup.add(stringArray[n3]);
            ++n3;
        }
        this.myDatabase.addApplicationData(string, applicationDataGroup);
    }

    protected WcMessage createAsyncQuery(RawDataID rawDataID, ApplicationMetaData applicationMetaData) throws IOException {
        String string = (String)this.theIdToName.get((Object)rawDataID);
        if (string != null && string.equals("QUERYVALUEEXCEPTION_2")) {
            throw new IOException("QUERYVALUEEXCEPTION_2 will always throw this exception when query value");
        }
        ApplicationData applicationData = this.myDatabase.requestData(string, applicationMetaData);
        if (rawDataID.getType() == 2) {
            KnownLengthStringValue knownLengthStringValue = (KnownLengthStringValue)applicationData;
            int n = Integer.parseInt(knownLengthStringValue.getValue());
            n = n == Integer.MAX_VALUE ? Integer.MIN_VALUE : ++n;
            applicationData = new KnownLengthStringValue("" + n);
            applicationData.describe(applicationMetaData);
            this.myDatabase.change(string, applicationData);
        }
        return new IssRspAsyncQuery(rawDataID, applicationData);
    }

    protected WcMessage createChangeRequest(RawDataID rawDataID, ApplicationData applicationData) throws IOException {
        WcMessage wcMessage;
        String string = (String)this.theIdToName.get((Object)rawDataID);
        if (string != null && string.lastIndexOf("CHANGEEXCEPTION") != -1) {
            throw new IOException("CHANGEEXCEPTION will always throw this exception when trying to change its value");
        }
        boolean bl = this.myDatabase.change(string, applicationData);
        if (bl) {
            CollectionOfMessages collectionOfMessages = new CollectionOfMessages(GenericIssDataAccessor.getClientID());
            if (this.myDatabase.shouldGenerateKnownChange()) {
                wcMessage = new IssCmdKnownObjectChangeNotify(rawDataID, this.myDatabase.requestData(string, null));
                collectionOfMessages.add(wcMessage);
            } else {
                wcMessage = rawDataID.getType() == 0 ? new FrameAnonymousUpdateNotify(1, GenericIssDataAccessor.getClientID()) : new FrameAnonymousUpdateNotify(rawDataID.getType(), GenericIssDataAccessor.getClientID());
                collectionOfMessages.add(wcMessage);
            }
            collectionOfMessages.add(new IssRspChange(bl));
            wcMessage = collectionOfMessages;
        } else {
            wcMessage = new IssRspChange(bl);
        }
        return wcMessage;
    }

    private void createGraphData(String string, int n, int n2, GraphInfoGenerator graphInfoGenerator) {
        this.storeIDforName(string, new IssDataID(n2, 1, n));
        GraphDataGenerator graphDataGenerator = new GraphDataGenerator(graphInfoGenerator);
        this.myDatabase.addApplicationData(string, graphDataGenerator);
    }

    private void createKnownLengthStringValue(String string, int n, int n2, String[] stringArray, int n3) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], ",", true);
        String[] stringArray2 = new String[]{"", "", "", "", "", "", "", "", ""};
        int n4 = 0;
        int n5 = 4;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(",")) {
                if (n4 == 0) {
                    stringArray2[0] = string3;
                } else if (n4 > 0 && n4 < 5) {
                    stringArray2[n4 + 4] = string3;
                } else {
                    stringArray2[n4 - 4] = string3;
                }
                ++n4;
            } else if (string3.equals(string2)) {
                ++n4;
            }
            string2 = string3;
        }
        if (n4 < 5) {
            n5 = 0;
        }
        int n6 = Math.max(stringArray2[0].length(), stringArray2[1].length());
        n6 = Math.max(n6, stringArray2[2].length());
        n6 = Math.max(n6, stringArray2[3].length());
        n6 = Math.max(n6, stringArray2[4].length());
        this.createKnownLengthStringValue(string, n, n2, stringArray2, n5, n6, false);
    }

    private void createKnownLengthStringValue(String string, int n, int n2, String[] stringArray, int n3, int n4, boolean bl) {
        this.storeIDforName(string, new IssDataID(n2, 0, n));
        StringBuffer stringBuffer = new StringBuffer((n4 + 1) * 5 + 40);
        this.addSizedText(stringBuffer, stringArray[0], n4, bl);
        int n5 = 0;
        while (n5 < 4) {
            if (n5 < n3) {
                this.addSizedText(stringBuffer, stringArray[n5 + 1], n4, bl);
            } else {
                this.addSizedText(stringBuffer, "", n4, bl);
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < 4) {
            if (n5 < stringArray.length - (n3 + 1)) {
                stringBuffer.append(stringArray[n5 + n3 + 1]);
            }
            stringBuffer.append(",");
            ++n5;
        }
        this.myDatabase.addApplicationData(string, new PaddedString(stringBuffer.toString(), n4, bl));
    }

    private void createKnownLengthStringValue(String string, int n, int n2, String string2) {
        this.storeIDforName(string, new IssDataID(n2, 0, n));
        this.myDatabase.addApplicationData(string, new KnownLengthStringValue(string2));
    }

    private void createMaskedIntegerValue(String string, int n, int n2, int n3, int n4) {
        long l = 1L;
        int n5 = 1;
        while (n5 <= n4) {
            l *= 2L;
            ++n5;
        }
        this.storeIDforName(string, new IssDataID(n2, 0, n));
        this.myDatabase.addApplicationData(string, new MaskedIntegerValue(n3, --l, l));
    }

    private void createMRSGraphData(String string, int n, int n2, SessionDataGenerator sessionDataGenerator) {
        this.storeIDforName(string, new IssDataID(n2, 1, n));
        MRSGraphDataGenerator mRSGraphDataGenerator = new MRSGraphDataGenerator(sessionDataGenerator);
        this.myDatabase.addApplicationData(string, mRSGraphDataGenerator);
    }

    protected WcMessage createRequestObjectID(String string) throws IOException {
        if (string != null && string.equals("QUERYIDEXCEPTION_2")) {
            throw new IOException("QUERYIDEXCEPTION_2 will always throw this exception when request ID");
        }
        return new IssRspAsyncRequestObjectID((RawDataID)this.theNameToID.get((Object)string), string);
    }

    private void createSessionAgentData(String string, int n, int n2) {
        this.storeIDforName(string, new IssDataID(n2, 0, n));
        this.myDatabase.addApplicationData(string, new SessionAgentDataGenerator());
    }

    private void createSessionInfo(String string, int n, int n2, String string2, SessionDataGenerator sessionDataGenerator) {
        this.storeIDforName(string, new IssDataID(n2, 1, n));
        SessionInfoGenerator sessionInfoGenerator = new SessionInfoGenerator(string2, sessionDataGenerator);
        this.myDatabase.addApplicationData(string, sessionInfoGenerator);
    }

    private void createTableData(String string, int n, int n2) {
        this.storeIDforName(string, new IssDataID(n2, 1, n));
        TableDataGenerator tableDataGenerator = new TableDataGenerator();
        this.myDatabase.addApplicationData(string, tableDataGenerator);
    }

    private void createUserEvent(String string, int n, int n2) {
        this.storeIDforName(string, new IssDataID(n2, 4, n));
    }

    public void disconnectFromDomain() {
        this.generator.stopEclipseThread();
        this.generator = null;
        ((Component)((Object)this.myDatabase)).setVisible(false);
        ((Window)((Object)this.myDatabase)).dispose();
        this.myDatabase = null;
        super.disconnectFromDomain();
    }

    public ApplicationData getDataButDifferent(RawDataID rawDataID, ApplicationMetaData applicationMetaData) {
        ApplicationData applicationData;
        String string = (String)this.theIdToName.get((Object)rawDataID);
        ApplicationData applicationData2 = applicationData = this.myDatabase == null ? null : this.myDatabase.requestData(string, applicationMetaData);
        if (applicationData instanceof ApplicationGenericData) {
            applicationData = new ApplicationGenericData(new byte[]{(byte)new Random().nextInt()});
            applicationData.describe(applicationMetaData);
        } else if (applicationData instanceof MaskedIntegerValue) {
            applicationData = new MaskedIntegerValue(new Random().nextInt() % 32);
            applicationData.describe(applicationMetaData);
        }
        return applicationData;
    }

    private RawDataID initCompositeData(String string, int n, int n2, byte by, ApplicationData applicationData, CompositeDataReader compositeDataReader) {
        ApplicationManager.instance().registerCompositeDataReader(null, string, compositeDataReader);
        return this.initGenericData(string, n, n2, by, applicationData);
    }

    private RawDataID initGenericData(String string, int n, int n2, byte by, ApplicationData applicationData) {
        IssDataID issDataID = new IssDataID(n2, by, n);
        this.storeIDforName(string, issDataID);
        this.myDatabase.addApplicationData(string, applicationData);
        return issDataID;
    }

    private void initialise() {
        int n = 10;
        this.myDatabase = new DatabaseEmulator();
        this.myDatabase.initialise(this);
        this.generator = new MessageGenerator(this);
        int n2 = 0;
        this.createMaskedIntegerValue("MASKEDINT1_1", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("MASKEDINT2_2", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("MASKEDINT3_3", n2++, 0, 0, 3);
        this.createMaskedIntegerValue("MASKEDINT4_4", n2++, 0, 1, 4);
        this.createMaskedIntegerValue("MASKEDINT5_5", n2++, 0, 0, 5);
        this.createMaskedIntegerValue("MASKEDINT6_6", n2++, 0, 1, 6);
        this.createMaskedIntegerValue("MASKEDINTCHANGEEXCEPTION_2", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("MASKEDINTCANNOTCHANGE_2", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("GREY_VARIABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("GREY_VARIABLE1", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("GREY_VARIABLE2", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("GREY_VARIABLE3", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("GREY_VARIABLE4", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("GREY_VARIABLE5", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("STANDARD_VARIABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("DATA_TYPE", n2++, 0, 0, 11);
        this.createKnownLengthStringValue("VALID_DATE", n2++, 1, new String[]{"23-01-2001"}, 0);
        this.createKnownLengthStringValue("ALMOST_VALID_DATE", n2++, 1, new String[]{"40-20-2001"}, 0);
        this.createKnownLengthStringValue("INVALID_DATE", n2++, 1, new String[]{"Rubbish!!!"}, 0);
        this.createKnownLengthStringValue("VALID_TIME", n2++, 1, new String[]{"10:46"}, 0);
        this.createKnownLengthStringValue("ALMOST_VALID_TIME", n2++, 1, new String[]{"25:70"}, 0);
        this.createKnownLengthStringValue("INVALID_TIME", n2++, 1, new String[]{"Crap!"}, 0);
        this.createKnownLengthStringValue("VALID_DURATION", n2++, 1, new String[]{"01:01:01:01"}, 0);
        this.createKnownLengthStringValue("ALMOST_VALID_DURATION", n2++, 1, new String[]{"01:30:70:70"}, 0);
        this.createKnownLengthStringValue("INVALID_DURATION", n2++, 1, new String[]{"Rubbish!!!!"}, 0);
        this.createKnownLengthStringValue("VALID_IP", n2++, 1, new String[]{"015.144.179.038"}, 0);
        this.createKnownLengthStringValue("ALMOST_VALID_IP", n2++, 1, new String[]{"600.500.400.300"}, 0);
        this.createKnownLengthStringValue("INVALID_IP", n2++, 1, new String[]{"Utter Rubbish!!"}, 0);
        this.createKnownLengthStringValue("VALID_MAC", n2++, 1, new String[]{"00-00-00-00-00-00"}, 0);
        this.createKnownLengthStringValue("INVALID_MAC", n2++, 1, new String[]{"Invalid MAC addr!"}, 0);
        this.createKnownLengthStringValue("VALID_FILENAME", n2++, 1, new String[]{"FILE_001"}, 0);
        this.createKnownLengthStringValue("INVALID_FILENAME", n2++, 1, new String[]{"*File/001"}, 0);
        this.createMaskedIntegerValue("QUERYIDEXCEPTION_2", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("QUERYVALUEEXCEPTION_2", n2++, 0, 1, 2);
        this.createKnownLengthStringValue("KLSTRCHANGEEXCEPTION", n2++, 1, new String[]{"SALUT,,,,,,,,"}, 0);
        this.createKnownLengthStringValue("KLSTRCANNOTCHANGE", n2++, 1, new String[]{"S,Pr1,Pr2,Pr3,,H1,H2,H3,H4"}, 0);
        this.createKnownLengthStringValue("DECIMAL_STR_1", n2++, 1, new String[]{"1398", "44", "5"}, 1, 5, false);
        this.createKnownLengthStringValue("DECIMAL_STR_2", n2++, 1, new String[]{"45", "124", "25", "43", "65"}, 4, 5, false);
        this.createKnownLengthStringValue("DECIMAL_STR_3", n2++, 1, new String[]{"87654", "0", "2", "3", "4"}, 0, 10, false);
        this.createKnownLengthStringValue("BINARY_STR_1", n2++, 1, new String[]{"00100", "0", "01", "0010", "01001"}, 0, 10, false);
        this.createKnownLengthStringValue("HEXADECIMAL_STR_1", n2++, 1, new String[]{"AFFF01", "F012", "2", "3", "4"}, 0, 10, false);
        this.createKnownLengthStringValue("KLSTR1", n2++, 1, new String[]{"SAL", "H1", "H2ooo", "H3", "H4"}, 4, 10, true);
        this.createKnownLengthStringValue("KLSTR2", n2++, 1, new String[]{"SALUt", "Pr1", "Preset 2", "Pr3", "Pr4"}, 0, 10, true);
        this.createKnownLengthStringValue("INTEGER_STRING", n2++, 1, new String[]{"12345", "11111", "22222", "33333", "44444"}, 4, 25, false);
        this.createKnownLengthStringValue("FLOAT_STRING", n2++, 1, new String[]{"12.34", ".1111", "2.222", "33.33", "444.4"}, 1, 25, false);
        this.createKnownLengthStringValue("INTEGER_STRING1", n2++, 1, new String[]{"11111,,,,,11111,22222,33333,44444"}, 0);
        this.createKnownLengthStringValue("INTEGER_STRING2", n2++, 1, new String[]{"22222,,,,,,,,"}, 0);
        this.createKnownLengthStringValue("INTEGER_STRING3", n2++, 1, new String[]{"33333,,,,,11111,22222,33333,44444"}, 0);
        this.createKnownLengthStringValue("INTEGER_STRING4", n2++, 1, new String[]{"44444,,,,,,,,"}, 0);
        this.createKnownLengthStringValue("INTEGER_STRING5", n2++, 1, new String[]{"55555,,,,,11111,22222,33333,44444"}, 0);
        this.createKnownLengthStringValue("LED_STRING_0", n2++, 1, new String[]{"0"}, 0);
        this.createKnownLengthStringValue("LED_STRING_1", n2++, 1, new String[]{"1"}, 0);
        this.createKnownLengthStringValue("LED_STRING_2", n2++, 1, new String[]{"2"}, 0);
        this.createKnownLengthStringValue("RESULT1", n2++, 2, new Integer(2147483622).toString());
        this.createKnownLengthStringValue("RESULT2", n2++, 2, "10");
        this.createKnownLengthStringValue("RESULT3", n2++, 2, "20");
        this.createKnownLengthStringValue("RESULT4", n2++, 2, "30");
        this.createKnownLengthStringValue("RESULT5", n2++, 2, "40");
        this.createKnownLengthStringValue("RESULT6", n2++, 2, "50");
        this.createKnownLengthStringValue("RESULT7", n2++, 2, "60");
        this.createKnownLengthStringValue("RESULT8", n2++, 2, "70");
        this.createKnownLengthStringValue("RESULT9", n2++, 2, "80");
        this.createKnownLengthStringValue("RESULT10", n2++, 2, "100");
        this.createKnownLengthStringValue("RESULT11", n2++, 2, "110");
        this.createKnownLengthStringValue("RESULT12", n2++, 2, "120");
        this.createKnownLengthStringValue("RESULT13", n2++, 2, "130");
        this.createKnownLengthStringValue("RESULT14", n2++, 2, "140");
        this.createKnownLengthStringValue("RESULT15", n2++, 2, "150");
        this.createKnownLengthStringValue("RESULT16", n2++, 2, "160");
        this.createKnownLengthStringValue("RESULT17", n2++, 2, "170");
        this.createKnownLengthStringValue("RESULT18", n2++, 2, "180");
        this.createKnownLengthStringValue("RESULT19", n2++, 2, "190");
        this.createKnownLengthStringValue("RESULT20", n2++, 2, "200");
        this.createApplicationDataGroup("EMPTY_GROUP", n2++, 1, new String[0]);
        this.createApplicationDataGroup("GROUP_1", n2++, 1, new String[]{"UN"});
        this.createApplicationDataGroup("GROUP_2", n2++, 1, new String[]{"UN", "DEUX"});
        this.createApplicationDataGroup("GROUP_3", n2++, 1, new String[]{"ONE", "TWO", "THREE"});
        this.createMaskedIntegerValue("ST_RUNNING_GREY", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_SELECTED_TEST_GREY", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_SELECTED_TEST_INDEX", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_CUST_SELECTION", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("ST_MODE", n2++, 0, 0, 3);
        this.createMaskedIntegerValue("ST_MODE_GREY", n2++, 0, 1, 2);
        this.createApplicationDataGroup("ST_ALL_TESTS", n2++, 1, new String[]{"Test 1", "Test 2"});
        this.createApplicationDataGroup("ST_INCLUDED_TESTS", n2++, 1, new String[]{"Test 1", "Test 2"});
        this.createApplicationDataGroup("ST_EXCLUDED_TESTS", n2++, 1, new String[]{"Test 3", "Test 4"});
        this.createApplicationDataGroup("ST_INCLUDED_SUBTESTS", n2++, 1, new String[]{"Subtest 1", "Subtest 2"});
        this.createApplicationDataGroup("ST_EXCLUDED_SUBTESTS", n2++, 1, new String[]{"Subtest 3", "Subtest 4"});
        this.createMaskedIntegerValue("ST_INCLUDED_TEST_INDEX", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDED_TEST_INDEX", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_INCLUDED_SUBTEST_INDEX", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDED_SUBTEST_INDEX", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_INCLUDE_SELECTED_TEST", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDE_SELECTED_TEST", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDE_SELECTED_TEST_ENABLE", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_SHOW_CUSTOMER_TESTS", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_SHOW_CUSTOMER_TESTS_ENABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_SHOW_MANUF_TESTS", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_SHOW_MANUF_TESTS_ENABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_SHOW_VERIF_TESTS", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_SHOW_VERIF_TESTS_ENABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_INCLUDE_ALL_TESTS", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_INCLUDE_SELECTED_SUBTEST", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDE_SELECTED_SUBTEST", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDE_SELECTED_SUBTEST_ENABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_INCLUDE_ALL_SUBTESTS", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDE_ALL_SUBTESTS", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_EXCLUDE_ALL_SUBTESTS_ENABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_LOGGING", n2++, 0, 0, 3);
        this.createMaskedIntegerValue("ST_LOGGING_FLAG", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("ST_LOGGING_DESTINATION", n2++, 0, 0, 3);
        this.createMaskedIntegerValue("ST_TEST_LIMITS", n2++, 0, 0, 3);
        this.createMaskedIntegerValue("ST_TEST_LIMITS_INDEX", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("ST_AUTO_PAUSE", n2++, 0, 0, 3);
        this.createMaskedIntegerValue("ST_PAUSE_ON_FAILURE_GREY", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("ST_PAUSE_AT_SUBTEST_GREY", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("ST_REPEAT_AT_END_OF_RUN", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("ST_PAUSE_BEFORE_TEST_INDEX", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("ST_PAUSE_BEFORE_SUBTEST_INDEX", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("SELF_CABLING_CFG", n2++, 0, 0, 11);
        this.createMaskedIntegerValue("SELF_CABLING_VISIBLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_STATE", n2++, 0, 0, 6);
        this.createMaskedIntegerValue("ST_START", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_START_STOP", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_START_STOP_ENABLE", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("ST_STOP", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_PAUSE", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_RESUME", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_SINGLE", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("ST_REPEAT", n2++, 0, 0, 1);
        this.createKnownLengthStringValue("ST_TEST_TIME_HOURS", n2++, 1, new String[]{"4"}, 0);
        this.createKnownLengthStringValue("ST_TEST_TIME_MINUTES", n2++, 1, new String[]{"57"}, 0);
        this.createKnownLengthStringValue("ST_TIME_REMAINING_HOURS", n2++, 1, new String[]{"2"}, 0);
        this.createKnownLengthStringValue("ST_TIME_REMAINING_MINUTES", n2++, 1, new String[]{"12"}, 0);
        this.createKnownLengthStringValue("ST_CURRENT_TEST", n2++, 1, new String[]{"Test 2"}, 0);
        this.createKnownLengthStringValue("ST_CURRENT_SUBTEST", n2++, 1, new String[]{"Subtest 2"}, 0);
        this.createKnownLengthStringValue("ST_NUM_FAILURES", n2++, 1, new String[]{"1"}, 0);
        this.createKnownLengthStringValue("ST_FAILURES_FOUND", n2++, 1, new String[]{"2"}, 0);
        this.createKnownLengthStringValue("ST_TEST_REPEAT_NUMBER", n2++, 1, new String[]{"1"}, 0);
        this.createMaskedIntegerValue("ST_TESTS_OR_SUBTESTS", n2++, 0, 0, 2);
        this.createApplicationDataGroup("ST_DATE_COLUMN", n2++, 1, new String[]{"02 Feb 2001", "02 Feb 2001", "", "", "", ""});
        this.createApplicationDataGroup("ST_TIME_COLUMN", n2++, 1, new String[]{"10:39", "14:16", "", "", "", ""});
        this.createApplicationDataGroup("ST_TEST_COLUMN", n2++, 1, new String[]{"Test 1", "Test 2", "", "", "", ""});
        this.createApplicationDataGroup("ST_SUBTEST_COLUMN", n2++, 1, new String[]{"Subtest 2", "Subtest 1", "", "", "", ""});
        this.createApplicationDataGroup("ST_FAILURE_COLUMN", n2++, 1, new String[]{"FAILED", "BROKE", "", "", "", ""});
        this.createApplicationDataGroup("ST_FAILURE_CODE_COLUMN", n2++, 1, new String[]{"FD-7F-21", "00-00-00", "", "", "", ""});
        this.createMaskedIntegerValue("PROGRESS", n2++, 0, 50, 100);
        this.createMaskedIntegerValue("STORED_SETTINGS_INDEX", n2++, 0, 0, 5);
        this.createMaskedIntegerValue("STORED_SETTINGS_SAVE_GREY", n2++, 0, 1, 2);
        this.createMaskedIntegerValue("STORED_SETTINGS_RECALL_OK", n2++, 0, 0, 1);
        this.createMaskedIntegerValue("STORED_SETTINGS_SAVE_OK", n2++, 0, 0, 1);
        this.createKnownLengthStringValue("STORED_SETTINGS_NAME_1", n2++, 1, new String[]{"Untitled"}, 0);
        this.createKnownLengthStringValue("STORED_SETTINGS_NAME_2", n2++, 1, new String[]{"Untitled"}, 0);
        this.createKnownLengthStringValue("STORED_SETTINGS_NAME_3", n2++, 1, new String[]{"Untitled"}, 0);
        this.createKnownLengthStringValue("STORED_SETTINGS_NAME_4", n2++, 1, new String[]{"Untitled"}, 0);
        this.createMaskedIntegerValue("LOG_OFF_ON", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("LOG_DESTINATION", n2++, 0, 0, 4);
        this.createMaskedIntegerValue("LOG_INTERVAL", n2++, 0, 0, 4);
        this.createMaskedIntegerValue("LOG_FILTER_ON", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("INST_PREF_SIGNAL_STD", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("RX_SIGNAL_SDH", n2++, 0, 0, 11);
        this.createMaskedIntegerValue("RX_SIGNAL_SONET", n2++, 0, 0, 13);
        this.createMaskedIntegerValue("INST_SIG_STDS_MODE", n2++, 0, 0, 2);
        this.createUserEvent("KEY_RESET", n2++, 5);
        this.createUserEvent("KEY_RUN_STOP", n2++, 5);
        this.createUserEvent("KEY_SINGLE_ERROR", n2++, 5);
        this.initGenericData("STATUS_LINE", n2++, 6, (byte)0, new StatusLineData());
        this.createMaskedIntegerValue("TX_ROCKET_GUI_CONF_DIALOG", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("RX_ROCKET_GUI_CONF_DIALOG", n2++, 0, 0, 2);
        this.createMaskedIntegerValue("TX_ROCKET_GUI_TYPE", n2++, 0, 25, 27);
        this.createMaskedIntegerValue("TX_ROCKET_GUI_RATE", n2++, 0, 4, 8);
        this.createMaskedIntegerValue("TX_ROCKET_GUI_AU", n2++, 0, 1, 7);
        this.createMaskedIntegerValue("TX_ROCKET_GUI_TU", n2++, 0, 1, 4);
        this.createMaskedIntegerValue("TX_ROCKET_GUI_VT", n2++, 0, 1, 3);
        this.createMaskedIntegerValue("TX_ROCKET_GUI_PAYLOAD", n2++, 0, 0, 9);
        this.createMaskedIntegerValue("RX_ROCKET_GUI_TYPE", n2++, 0, 26, 27);
        this.createMaskedIntegerValue("RX_ROCKET_GUI_RATE", n2++, 0, 4, 8);
        this.createMaskedIntegerValue("RX_ROCKET_GUI_AU", n2++, 0, 1, 7);
        this.createMaskedIntegerValue("RX_ROCKET_GUI_TU", n2++, 0, 1, 4);
        this.createMaskedIntegerValue("RX_ROCKET_GUI_VT", n2++, 0, 1, 3);
        this.createMaskedIntegerValue("RX_ROCKET_GUI_PAYLOAD", n2++, 0, 0, 9);
        this.createMaskedIntegerValue("STEST_TOP_MENU", n2++, 0, 4, 4);
        this.createMaskedIntegerValue("STEST_TOP_SHORTCUTS_MENU", n2++, 0, 6, 6);
        this.createUserEvent("STEST_TOP_STOP", n2++, 5);
        this.createUserEvent("STEST_TOP_RESET_INST", n2++, 5);
        RawDataID rawDataID = this.initCompositeData("COMPOSITE_TEST_1", n2++, 10, (byte)2, new ApplicationGenericData(null), new CompositeDataReaderExample());
        this.generator.update(rawDataID, this);
        this.createMaskedIntegerValue("INST_ONLINE_HELP_STATUS", n2++, 0, 1, 2);
        this.createKnownLengthStringValue("INST_ONLINE_HELP_MODE", n2++, 1, "sdh");
        this.createTableData("TABLE2_DATA", n2++, n++);
        this.createMaskedIntegerValue("MRS_SESSION_TOTAL_MEM_USAGE", n2++, 0, 90, 100);
        this.createKnownLengthStringValue("MRS_SESSION_LATEST_MEM_USAGE", n2++, 1, "10");
        this.createMaskedIntegerValue("GRAPH_PANE", n2++, 3, 0, 1);
        this.createApplicationDataGroup("MRS_SESSION_LIST", n2++, 3, new String[]{"session1", "session2", "session3"});
        this.createMaskedIntegerValue("MRS_SESSION_LIST_INDEX", n2++, 3, 0, 3);
        this.createApplicationDataGroup("MRS_SESSION_LIST_MEM_USAGE", n2++, 3, new String[]{"40", "20", "20"});
        this.createMaskedIntegerValue("MRS_SESSION_LATEST_STATE", n2++, 3, 0, 3);
        SessionDataGenerator sessionDataGenerator = new SessionDataGenerator();
        this.createMRSGraphData("MRS_GRAPH_DATA", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_0", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_1", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_2", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_3", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_4", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_5", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_6", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_7", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_8", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_9", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_0_10", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_0", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_1", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_2", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_3", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_4", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_5", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_6", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_7", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_8", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_9", n2++, 3, sessionDataGenerator);
        this.createMRSGraphData("MRS_GRAPH_DATA_1_10", n2++, 3, sessionDataGenerator);
        this.createSessionInfo("MRS_SESSION_INFO", n2++, 3, "session1", sessionDataGenerator);
        this.createSessionAgentData("MRS_SESSION_AGENT", n2++, 3);
        this.createMaskedIntegerValue("TX_PAYLOAD_LOCATION", n2++, 0, 0, 2);
        GraphInfoGenerator graphInfoGenerator = new GraphInfoGenerator();
        this.createGraphData("GRAPH_DATA_0", n2++, 3, graphInfoGenerator);
        this.createGraphData("GRAPH_DATA_1", n2++, 3, graphInfoGenerator);
        this.createGraphData("GRAPH_DATA_2", n2++, 3, graphInfoGenerator);
        this.generator.start();
        ((Component)((Object)this.myDatabase)).setVisible(true);
    }

    public void scheduleChange(String string, ApplicationData applicationData) {
        try {
            RawDataID rawDataID = (RawDataID)this.theNameToID.get((Object)string);
            if (this.myDatabase.shouldGenerateKnownChange()) {
                CollectionOfMessages collectionOfMessages = new CollectionOfMessages(0);
                collectionOfMessages.add(new IssCmdKnownObjectChangeNotify(rawDataID, applicationData));
                this.transact(collectionOfMessages);
            } else if (rawDataID.getType() == 0) {
                this.transact(new FrameAnonymousUpdateNotify(1, 0));
            } else {
                this.transact(new FrameAnonymousUpdateNotify(rawDataID.getType(), 0));
            }
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException in scheduldeChange, this should never happen in the emulator");
        }
    }

    public void sendEvent(RawDataID rawDataID, ApplicationData applicationData) {
        System.out.println("A client event has been sent to the server for this id = " + rawDataID.toString() + " with data = " + (applicationData == null ? "null" : applicationData.toString()));
    }

    protected void sendQueue(List list) throws IOException {
        List list2 = list;
        synchronized (list2) {
            WcMessage wcMessage = new FrameGroupMessage((short)(list.size() - 1), GenericIssDataAccessor.getClientID());
            list.set(0, (Object)wcMessage);
            while (!list.isEmpty()) {
                wcMessage = (WcMessage)list.remove(0);
                this.transact(wcMessage);
            }
        }
    }

    private RawDataID storeGraphInfo(String string, int n, int n2, boolean bl, GraphInfoGenerator graphInfoGenerator) {
        IssDataID issDataID = new IssDataID(n2, 1, n);
        this.storeIDforName(string, issDataID);
        this.myDatabase.addApplicationData(string, graphInfoGenerator);
        if (bl) {
            this.generator.update(issDataID, graphInfoGenerator);
        }
        return issDataID;
    }

    private void storeIDforName(String string, RawDataID rawDataID) {
        if (string.equals("DOES_NOT_EXIST")) {
            System.out.println("Cannot initialise this database with this database variable name " + string);
            System.exit(0);
        } else if (this.theNameToID.containsKey((Object)string) || this.theIdToName.containsKey((Object)rawDataID)) {
            System.out.println("Cannot initialise this database with this database variable name twice: " + string + " or the same id twice: " + rawDataID.toString());
            System.exit(0);
        } else {
            this.theNameToID.put((Object)string, (Object)rawDataID);
            this.theIdToName.put((Object)rawDataID, (Object)string);
        }
    }

    private RawDataID storeSessionData(String string, int n, int n2, SessionDataGenerator sessionDataGenerator) {
        IssDataID issDataID = new IssDataID(n2, 1, n);
        this.storeIDforName(string, issDataID);
        this.myDatabase.addApplicationData(string, sessionDataGenerator);
        return issDataID;
    }

    protected void transact(WcMessage wcMessage) throws IOException {
        this.generator.scheduleMessage(wcMessage);
    }
}

