/*
 * Decompiled with CFR 0.152.
 */
package espial.axl.awt;

import espial.axl.awt.XComponent;
import espial.axl.awt.XPanel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.lang.reflect.Method;

public class XDoubleBufferPanel
extends XPanel {
    private transient boolean m_update = false;
    private transient boolean m_inUpdate = false;
    private transient boolean m_dblBufEnabled = false;
    private boolean m_dblBufEnabledSet = false;
    private static boolean m_doBuffChecked = false;
    private static boolean m_doBuff = true;
    private static Image m_offScrBuffer = null;

    public final boolean isDoubleBuffered() {
        return this.m_dblBufEnabled;
    }

    public final synchronized void setDoubleBufferingEnabled(boolean bl) {
        this.m_dblBufEnabled = bl;
        this.m_dblBufEnabledSet = true;
    }

    public final void update(Graphics graphics) {
        Dimension dimension;
        if (!this.m_dblBufEnabledSet) {
            XDoubleBufferPanel xDoubleBufferPanel = this;
            synchronized (xDoubleBufferPanel) {
                if (!this.m_dblBufEnabledSet) {
                    this.m_dblBufEnabled = XDoubleBufferPanel.doDoubleBuffering(this) && !XComponent.isLightweight(this);
                    this.m_dblBufEnabledSet = true;
                }
            }
        }
        this.m_inUpdate = true;
        if (this.m_dblBufEnabled && !this.m_update && this.isShowing()) {
            dimension = this.getSize();
            if (XDoubleBufferPanel.mgrPaint(graphics, this, 0, 0, dimension.width, dimension.height)) {
                return;
            }
        }
        if (this.m_dblBufEnabled && XComponent.isLightweight(this)) {
            dimension = this.getSize();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        }
        super.update(graphics);
        this.m_inUpdate = false;
    }

    public final void paint(Graphics graphics) {
        if (!this.m_update && !this.m_inUpdate) {
            this.update(graphics);
            return;
        }
        this.prePaint(graphics);
        super.paint(graphics);
        this.postPaint(graphics);
    }

    protected void prePaint(Graphics graphics) {
    }

    protected void postPaint(Graphics graphics) {
    }

    private final void doPaint(Graphics graphics) {
        this.m_update = true;
        this.update(graphics);
        this.m_update = false;
    }

    private static final boolean mgrPaint(Graphics graphics, XDoubleBufferPanel xDoubleBufferPanel, int n, int n2, int n3, int n4) {
        if (XDoubleBufferPanel.doDoubleBuffering(xDoubleBufferPanel)) {
            if (m_offScrBuffer == null) {
                m_offScrBuffer = xDoubleBufferPanel.createImage(n3, n4);
                int n5 = n3;
                int n6 = n4;
            } else {
                int n7 = m_offScrBuffer.getWidth(xDoubleBufferPanel);
                int n8 = m_offScrBuffer.getHeight(xDoubleBufferPanel);
                if (n7 < n3 || n8 < n4) {
                    m_offScrBuffer.flush();
                    n7 = Math.max(n7, n3);
                    n8 = Math.max(n8, n4);
                    m_offScrBuffer = xDoubleBufferPanel.createImage(n7, n8);
                }
            }
            Graphics graphics2 = m_offScrBuffer.getGraphics();
            if (graphics2 != null) {
                Rectangle rectangle = graphics.getClipBounds();
                graphics2.setClip(rectangle);
                graphics2.setColor(graphics.getColor());
                graphics2.setFont(graphics.getFont());
                xDoubleBufferPanel.doPaint(graphics2);
                graphics.drawImage(m_offScrBuffer, n, n2, n3, n4, 0, 0, n3, n4, xDoubleBufferPanel);
                graphics2.dispose();
                return true;
            }
        }
        return false;
    }

    private static final boolean doDoubleBuffering(XDoubleBufferPanel xDoubleBufferPanel) {
        if (!m_doBuffChecked) {
            boolean bl = false;
            String string = null;
            try {
                string = System.getProperty("doublebuffering.disabled");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            m_doBuff = string != null ? !(bl = Boolean.valueOf(string).booleanValue()) : !XDoubleBufferPanel.isAWTDoubleBuffered(xDoubleBufferPanel);
            m_doBuffChecked = true;
        }
        return m_doBuff || xDoubleBufferPanel.m_dblBufEnabled;
    }

    private static final boolean isAWTDoubleBuffered(XDoubleBufferPanel xDoubleBufferPanel) {
        Class<?> clazz = xDoubleBufferPanel.getClass();
        try {
            Method method = clazz.getMethod("isDoubleBuffered", new Class[0]);
            Boolean bl = (Boolean)method.invoke((Object)xDoubleBufferPanel, null);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

