/*
 * Decompiled with CFR 0.152.
 */
package espial.axl.util;

import com.sun.util.PTimer;
import com.sun.util.PTimerSpec;
import com.sun.util.PTimerWentOffEvent;
import com.sun.util.PTimerWentOffListener;
import espial.axl.util.XTimerListener;

public class XTimerTask
extends PTimerSpec
implements PTimerWentOffListener {
    private int m_ID;
    private XTimerListener m_listener;
    static final PTimer TIMER = PTimer.getTimer();

    public XTimerTask(int n, XTimerListener xTimerListener) {
        this.m_ID = n;
        this.m_listener = xTimerListener;
        this._init();
    }

    public final int getID() {
        return this.m_ID;
    }

    public final boolean isRepeating() {
        return this.isRepeat();
    }

    public final void schedule(long l) {
        this._sched(l, false, false);
    }

    public final void scheduleRepeat(long l) {
        this._sched(l, true, false);
    }

    public final void scheduleAtFixedRate(long l) {
        this._sched(l, true, true);
    }

    public final void cancel() {
        this._cancel();
    }

    public final void destroy() {
        this._cancel();
        XTimerTask xTimerTask = this;
        synchronized (xTimerTask) {
            this.m_listener = null;
            this.removePTimerWentOffListener(this);
        }
    }

    public final void timerWentOff(PTimerWentOffEvent pTimerWentOffEvent) {
        this.m_listener.timeout(this.m_ID);
    }

    private final void _init() {
        this.addPTimerWentOffListener(this);
    }

    private final synchronized void _cancel() {
        TIMER.deschedule((PTimerSpec)this);
    }

    private final synchronized void _sched(long l, boolean bl, boolean bl2) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        if (this.m_listener == null) {
            throw new IllegalStateException("TimerTask destroyed.");
        }
        this._cancel();
        this.setDelayTime(l);
        this.setRegular(bl2);
        this.setRepeat(bl);
        TIMER.schedule((PTimerSpec)this);
    }
}

