package espial.escape3.parsers.css;

import java.io.*;

/**
  * This is the lexical analyzer for CSS.
  * It returns tokens as defined in the constant list of this class.
  * If a token is less than XXX, it is a character.  Else it's a token.
  */
  
/**
  * @kumanan0001 - 5 sep 2000
  *    all units are not case insensitive
  */
%%

%unicode
%class CssLexer
%implements CssLexTokens
%final
%int

%{
  ///**
  // * Runs the scanner on input files.
  // *
  // * This is a standalone scanner, i.e. it will print any unmatched
  // * text to System.out unchanged.
  // *
  // * @param argv   the command line, contains the filenames to run
  // *               the scanner on.
  // */
  //public static void main(String argv[]) {
  //	for (int i = 0; i < argv.length; i++) {
  //		CssLexer scanner = null;
  //		try {
  //			scanner = new CssLexer( new java.io.FileReader(argv[i]) );
  //		}
  //		catch (java.io.FileNotFoundException e) {
  //			System.out.println("File not found : \""+argv[i]+"\"");
  //			System.exit(1);
  //		}
  //		catch (java.io.IOException e) {
  //			System.out.println("Error opening file \""+argv[i]+"\"");
  //			System.exit(1);
  //		}
  //		catch (ArrayIndexOutOfBoundsException e) {
  //			System.out.println("Usage : java CssLexer <inputfile>");
  //			System.exit(1);
  //		}
//
  //		try {
  //			while ( !scanner.yy_atEOF ) {
  //			System.out.println (scanner.yylex() + " " + scanner.yytext ());
  //			}
  //		}
  //		catch (java.io.IOException e) {
  //			System.out.println("An I/O error occured while scanning : \n"+e);
  //			System.exit(1);
  //		}
  //		catch (Exception e) {
  //			e.printStackTrace();
  //			System.exit(1);
  //		}
  //	}
  //}
//
//
%}
h =   [0-9a-f]
nonascii = [\200-\377]
unicode =  \\{h}{1,6}[ \t\r\n\f]?
escape  =  {unicode}|\\[ -~\200-\377]
nmstart =  [a-zA-Z]|{nonascii}|{escape}
nmchar  =  [a-zA-Z0-9-]|{nonascii}|{escape}
string1 =  \"([\t !#$%&(-~]|\\{nl}|\'|{nonascii}|{escape})*\"
string2 =  \'([\t !#$%&(-~]|\\{nl}|\"|{nonascii}|{escape})*\'

ident  =   {nmstart}{nmchar}*
name = {nmchar}+
num = [0-9]+|[0-9]*"."[0-9]+

string  =  {string1}|{string2}
url = ([!#$%&*-~]|{nonascii}|{escape})*
w =  [ \t\r\n\f]*
nl = \n|\r\n|\r|\f
range =    \?{1,6}|{h}(\?{0,5}|{h}(\?{0,4}|{h}(\?{0,3}|{h}(\?{0,2}|{h}(\??|{h})))))


comment = "/*" [^*]* "*" ("*" | [^*/] [^*]* "*")* "/"


%%

[ \t\r\n\f]+   { yybegin (YYINITIAL); return S;}

{comment}   { /* ignore comments */ }

"<!--"   {return CDO;}
"-->"    {return CDC;}
"~="    {return INCLUDES;}
"|="    {return DASHMATCH;}

{string}    {return STRING;}

"#"{name}   {return HASH;}

"@import"  {return ATIMPORT;}
"@media"  {return ATMEDIA;}
"@page"  {return ATPAGE;}
"@font-face"  {return ATFONT_FACE;}
"@charset"  {return ATCHARSET;}

"@"{ident}  {return ATKEYWORD;}

{ident}"("  {return FUNCTION;}
{ident}     {return IDENT;}

"!"{w}"important"   {return IMPORTANT_SYM;}


{num}[eE][mM]     {return EMS;}
{num}[eE][xX]     {return EXS;}
{num}[pP][xX]     {return LENGTH_PX;}
{num}[cC][mM]     {return LENGTH_CM;}
{num}[mM][mM]     {return LENGTH_MM;}
{num}[iI][nN]     {return LENGTH_IN;}
{num}[pP][tT]     {return LENGTH_PT;}
{num}[pP][cC]     {return LENGTH_PC;}
{num}[dD][eE][gG]    {return ANGLE;}
{num}[rR][aA][dD]    {return ANGLE;}
{num}[gG][rR][aA][dD]   {return ANGLE;}
{num}[mM][sS]     {return TIME;}
{num}[sS]      {return TIME;}
{num}[hH][zZ]     {return FREQ;}
{num}[kK][hH][zZ]    {return FREQ;}
{num}{ident} {return DIMEN;}
{num}%       {return PERCENTAGE;}
{num}        {return NUMBER;}

[uU][rR][lL]"("{w}{string}{w}")" {return URI_STR;}
[uU][rR][lL]"("{w}{url}{w}")"    {return URI_URL;}

U\+{range}  {return UNICODE_RANGE;}
U\+{h}{1,6}-{h}{1,6}    {return UNICODE_RANGE;}

.     {return yychar ();}
