/* ahXXX.c                  --Agilent BioSolids--            

              3D hXXX (hCCC), first with HX CP followed by X (d3) evolution, a
              first choice of mixing periods followed by X (d2) evolution, 
              followed by DARR mixing, followed by acquisition and a 
              constant-time decoupling period. Choose 2-angle SPINAL or TPPM
              decoupling during d2, d3 and acquisition.

              Both d2 and d3 use simple delays.
              
              Select one of 5 XX mixing choices, DARR, PARIS, RFDR, C7 and SPC5 
              for the first mixing period.  The RFDR, C7 and SPC5 mixing are
              enclosed in a rotor-synchronized pair of Z-filter periods with 
              a variable decoupler level. The C7 and SPC5 can be executed as a 
              double quantum filter by setting the flag dqfX (i.e dqfXspc5 etc).
              The number of executed elements qX doubles. The mixing time tX is
              returned as a message parameter with the suffix "ret"
              (i.e tXspc5ret). The DARR and PARIS mixing periods are tXmix. 

              The C7, SPC5 (and dqf versions) have their own H decoupling levels
              (identified by "mix", i.e. aHmixspc5). The RFDR uses aHrfdr.  
              DARR and PARIS are H irradiation sequences using aHmix and
              aHparis respectively.
              
              Select only DARR for the second mixing period. The period is 
              tXmix1 and the DARR level is also aHmix. 

              HX CP is executed with a standard CP module, allowing constant, 
              linear and tangent CP.  

              FLAGS: 

              The program calculates the value of the d2 or d3 evolution times
              as d2_or d3_. These calculations use the value of d2_init or 
              d3_init, the values entered as "d2" or "d3". The values of d2_ 
              and d3_ are returned as message parameters d2acqret and d3acqret.
              Also the d2 dwell, 1.0/sw1 and the d3 dwell 1.0/sw2 are returned
              as d2dwret and d3wret.

              Set ctd = 'y' to choose constant-time decoupling over no 
              constant-time decoupling (ctd = 'n'). The parameter tRFmax inputs
              a proposed maximum decoupling period tRF after acquisition. The
              values of d2 and d3 are subtracted from this value. The sequence
              sets tRFmax to the sum of the F1 and F2 acquisition times if 
              tRFmax is less than this value. The putCmd statement is used to
              reset the parameter tRFmax. The putcmd statement is used to set 
              tRFmax=0.0.

              Set ddec2 = 'y' to choose Y decoupling during F3 or'n' for no Y 
              decoupling during F3. The Y channel is blanked if no decoupling
              is used and if ampmode for the channel is 'p'. The choices for 
              Y decoupling are TPPM, 2-angle SPINAL abd WALTZ. 

              The value mMix = 'darr','c7','spc5','rfdr' or 'paris' tp set 
              the forst mixing period.  The value mMix1 is forced to be 'darr'
              to set the second mixing period which can also be used as a 
              Z-filter. 
              
              The first mix period is tMix for DARR and PARIS.  The second 
              mixing period is tXmix1 for DARR. Both values are rotor 
              synchronized using the value of 1.0/srate and the putCmd 
              statement is used to reset these parameters. 

              This sequence was derived from hXXX provided by C. Rienstra, UIUC.
                                                                             */
#include "standard.h"
#include "solidstandard.h"
#include "pboxpulse.h"
#include <CompSens.h> 

// Define Static Value to Hold d2 of First Increment

static double d2_init;
static double d3_init;

// Define Values for Phasetables

static int table1[8] = {3,1,3,1,3,1,3,1};           // phH90
static int table2[8] = {0,0,0,0,0,0,0,0};           // phHhx
static int table3[8] = {0,0,0,0,0,0,0,0};           // phXhx
static int table4[8] = {1,1,1,1,1,1,1,1};           // ph1Xmix
static int table5[8] = {1,3,1,3,1,3,1,3};           // ph2Xmix;
static int table6[8] = {2,2,0,0,2,2,0,0};           // phRec;  
static int table7[8] = {0,0,0,0,0,0,0,0};	    // phXrcpl
static int table8[8] = {0,1,0,1,0,1,0,1};	    // phXrcplref
static int table9[8] = {1,0,1,0,1,0,1,0};           // phXmixdqf;
static int table10[8] ={0,0,0,0,0,0,0,0};	    // ph3Xmix
static int table11[8] ={0,0,2,2,0,0,2,2};	    // ph4Xmix

#define phH90 t1
#define phHhx t2
#define phXhx t3
#define ph1Xmix t4
#define ph2Xmix t5
#define phRec t6
#define phXrcpl t7
#define phXrcplref t8
#define phXmixdqf t9
#define ph3Xmix t10
#define ph4Xmix t11

pulsesequence() {

// Add NUS for this Sequence for SPARSE='y' and: 
//     (ni > 1) and (nimax > ni + 1) or  
//     (ni2 > 1) and (nimax > ni2 + 1)  

   char sparseval[MAXSTR];
   getstr("SPARSE",sparseval);
   double ni2 = getval("ni2");
   if (sparseval[A] == 'y' && ((getval("ni") > 1.0 && getval("nimax") >= getval("ni") + 1.0) || 
      (ni2 > 1.0 && getval("ni2max") >= ni2 + 1.0))) {
      (void) set_RS(0);
      ni = getval("nimax");
      if (ni < 1) ni = 1;
      ni2= getval("ni2max"); 
      if (ni2 < 1) ni2 = 1;
      sw1 = getval("sw1");
      sw2 = getval("sw2");
   }

// Else Force SPARSE='n'.

   else {                     
      strncpy(sparseval,"n",3);
      putCmd("SPARSE='n'\n");   
      printf("No F1 Array - Set SPARSE='n'\n");
   }

// Define Variables and Objects and Get Parameter Values

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",4);
   putCmd("frHX='dec'\n"); 
   putCmd("toHX='obs'\n");

   DSEQ dec = getdseq2("H");

// Choose DEC2 Decoupling

   char ddec2[MAXSTR];
   getstr("ddec2",ddec2);

   DSEQ dec2;
   if (!strcmp(ddec2,"y")) dec2 = getdseq2("Y");

// Choose the First Mixing Sequence 

   char mMix[MAXSTR];
   getstr("mMix",mMix);

// Set the Second Mixing Sequence as DARR
   
   char mMix1[MAXSTR];
   getstr("mMix1",mMix1);  
   strncpy(mMix1,"darr",5);
   putCmd("mMix1='darr'\n");

// Define Optional SPC5 and C7 First Mixing Sequences

   MPSEQ spc5;
   MPSEQ spc5ref;
   char dqfXspc5[MAXSTR];
   double tXspc5ret = 0.0;

   if (!strcmp(mMix,"spc5")) {
      getstr("dqfXspc5",dqfXspc5);
      spc5 = getspc5("spc5X",0,0.0,0.0,0,1);
      tXspc5ret = spc5.t;
      strncpy(spc5.ch,"obs",3);
      if (!strcmp(dqfXspc5,"y")) {
         spc5ref = getspc5("spc5X",spc5.iSuper,spc5.phAccum,spc5.phInt,1,1); 
         strncpy(spc5ref.ch,"obs",3);
         tXspc5ret = tXspc5ret + spc5.t;
      }
      putCmd("chXspc5='obs'\n");
      putCmd("tXspc5ret = %f\n",tXspc5ret*1.0e6); 
   }

   MPSEQ c7;
   MPSEQ c7ref;
   char dqfXc7[MAXSTR];
   double tXc7ret = 0.0;

   if (!strcmp(mMix,"c7")) {
      getstr("dqfXc7",dqfXc7);
      c7 = getpostc7("c7X",0,0.0,0.0,0,1);
      tXc7ret = c7.t;
      strncpy(c7.ch,"obs",3);
      if (!strcmp(dqfXc7,"y")) {
         c7ref = getpostc7("c7X",c7.iSuper,c7.phAccum,c7.phInt,1,1);
         strncpy(c7ref.ch,"obs",3);
         tXc7ret = tXc7ret + c7.t;
      }
      putCmd("chXc7='obs'\n");
      putCmd("tXc7ret = %f\n",tXc7ret*1.0e6);
   }
   
// Define Optional RFDR and Paris Mixing Sequences

   MPSEQ rfdr;
   double tXrfdrret = 0.0;

   if (!strcmp(mMix,"rfdr")) {
      rfdr = getrfdrxy8("rfdrX",0,0.0,0.0,0,1);
      tXrfdrret = rfdr.t;
      strncpy(rfdr.ch,"obs",3);
      putCmd("chXrfdr='obs'\n");
      putCmd("tXrfdrret = %f\n",tXrfdrret*1.0e6);
   }

   PARIS paris;

   if (!strcmp(mMix,"paris")) {
      paris = getparis("Hm");
   }

// Determine taur, One Rotor Cycle

   double srate = getval("srate");
   double taur = 0.0;
   if (srate >= 500.0)
      taur = roundoff((1.0/srate), 0.125e-6);
   else {
      printf("ABORT: Spin Rate (srate) must be greater than 500\n");
      psg_abort(1);
   }

// Set the First Mixing Period to N Rotor Cycles

   double tXmix = getval("tXmix");
   tXmix = roundoff(tXmix,taur);
   putCmd("tXmix = %f\n",tXmix*1.0e6);
   
// Set the Second Mixing Period to N Rotor Cycles

   double tXmix1 = getval("tXmix1");
   tXmix1 = roundoff(tXmix1,taur);
   putCmd("tXmix1 = %f\n",tXmix1*1.0e6); 

// Calculate the F1 and F2 Acquisition Times 

   if (d2_index == 0) d2_init = getval("d2"); 
   if (d3_index == 0) d3_init = getval("d3");

   printf("sw1 = %f\n",sw1); 
   printf("sw2 = %f\n",sw2);
   double d2_ = (ni - 1)/sw1 + d2_init;
   putCmd("d2acqret = %f\n",roundoff(d2_,12.5e-9));
   putCmd("d2dwret = %f\n",roundoff(1.0/sw1,12.5e-9));
   double d3_ = (ni2 - 1)/sw2 + d3_init;
   putCmd("d3acqret = %f\n",roundoff(d3_,12.5e-9));
   putCmd("d3dwret = %f\n",roundoff(1.0/sw2,12.5e-9));
      
// Calculate Constant-time Decoupling Period tRF

   char ctd[MAXSTR];
   getstr("ctd",ctd);

   double tRF = 0.0;
   double tRFmax = getval("tRFmax");
   if (!strcmp(ctd,"y")) {
      if (tRFmax <= (d2_ + d3_)) tRFmax = d2_ + d3_;
      tRF = tRFmax - d2 - d3; 
      putCmd("tRFmax = %f\n",tRFmax*1.0e6);
   } 

// Set tRFmax = 0.0 for No Constant-time Decoupling

   else { 
      putCmd("tRFmax = 0.0\n");
   }

// Copy Current Parameters to Processed

   putCmd("groupcopy('current','processed','acquisition')");

// Dutycycle Protection

   double duty = 4.0e-6 + getval("pwH90") + getval("tHX") +  tXmix1 + 
            2.0*getval("pwX90") + getval("ad") + getval("rd") + at + 
            d2 + d3;  
            
   if ((!strcmp(mMix,"darr"))||(!strcmp(mMix,"paris"))) duty = duty + 
            2.0*getval("pwX90") +  tXmix;
   else if (!strcmp(mMix,"c7")) duty = duty + 2.0*getval("pwX90") + tXc7ret;
   else if (!strcmp(mMix,"spc5")) duty = duty + 2.0*getval("pwX90")  + tXspc5ret;
   else if (!strcmp(mMix,"spc5")) duty = duty + 2.0*getval("pwX90")  + tXrfdrret;
   else {
      printf("ABORT: Mixing Sequence Not Found ");
   }                       
   duty = duty/(duty + d1 + 4.0e-6);

   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100.0);
      psg_abort(1);
  }

// Create Phasetables 

   settable(phH90,8,table1);
   settable(phHhx,8,table2);
   settable(phXhx,8,table3);
   settable(ph1Xmix,8,table4);
   settable(phRec,8,table6);
   settable(phXrcpl,8,table7);
   settable(ph3Xmix,8,table10);
   settable(ph4Xmix,8,table11); 
   if ((!strcmp(dqfXspc5,"y"))||(!strcmp(dqfXc7,"y"))) {
      settable(phXrcplref,8,table8);
      settable(ph2Xmix,8,table9);
   }
   else {
      settable(phXrcplref,8,table7);
      settable(ph2Xmix,8,table5);
   } 

// Hypercomplex F1 and F2

   int id2_ = (int) (d2*sw1 + 0.1);
   if ((phase1 == 1) || (phase1 == 2)) {
      tsadd(ph3Xmix,2*id2_,4);
      tsadd(phRec,2*id2_,4);
      if (phase1 == 2) tsadd(ph3Xmix,3,4);
   }

   int id3_ = (int) (d3*sw2 + 0.1);
   if ((phase2 == 1) || (phase2 == 2)) {
      tsadd(ph1Xmix,2*id3_,4);
      tsadd(phRec,2*id3_,4);
      if (phase2 == 2) tsadd(ph1Xmix,3,4);
   }
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90); if (NUMch > 2) dec2phase(zero); 
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization 

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   _cp_(hx,phHhx,phXhx);

// F2 Indirect Period For X

   obspwrf(getval("aX90"));
   _dseqon2(dec);
   delay(d3);
   _dseqoff2(dec);

// Optional Mixing with SPC5 Recoupling

   if (!strcmp(mMix, "spc5")) {
      obspwrf(getval("aX90")); decpwrf(getval("aH90"));
      decon();
      rgpulse(getval("pwX90"),ph1Xmix,0.0,0.0);
      xmtrphase(v1); txphase(phXrcpl);
      obspwrf(getval("aXspc5")); decpwrf(getval("aHZF"));
      obsunblank();
      delay(getval("tZF"));
      decpwrf(getval("aHmixspc5"));
      _mpseq(spc5,phXrcpl);
      if (!strcmp(dqfXspc5,"y")) {
         xmtrphase(v2);
         _mpseq(spc5ref,phXrcplref);
      }
      xmtrphase(zero);
      if (!strcmp(dqfXspc5,"y")) txphase(phXmixdqf);
      else txphase(ph2Xmix);
      obspwrf(getval("aX90")); decpwrf(getval("aHZF"));
      delay(getval("tZF"));
      decpwrf(getval("aH90"));
      if (!strcmp(dqfXspc5,"y")) rgpulse(getval("pwX90"),phXmixdqf,0.0,0.0);
      else rgpulse(getval("pwX90"),ph2Xmix,0.0,0.0);
      decoff();
   }

// Optional Mixing with C7 Recoupling

   if (!strcmp(mMix,"c7")) {
      obspwrf(getval("aX90")); decpwrf(getval("aH90"));
      decon();
      rgpulse(getval("pwX90"),ph1Xmix,0.0,0.0);
      xmtrphase(v1); txphase(phXrcpl);
      obspwrf(getval("aXc7")); decpwrf(getval("aHZF"));
      obsunblank();
      delay(getval("tZF"));
      decpwrf(getval("aHmixc7"));
      _mpseq(c7,phXrcpl);
      if (!strcmp(dqfXc7,"y")) {
         _mpseq(c7ref,phXrcplref);
      }
      xmtrphase(zero);
      if (!strcmp(dqfXc7,"y")) txphase(phXmixdqf);
      else txphase(ph2Xmix);
      obspwrf(getval("aX90")); decpwrf(getval("aHZF"));
      delay(getval("tZF"));
      decpwrf(getval("aH90"));
      if (!strcmp(dqfXc7,"y")) rgpulse(getval("pwX90"),phXmixdqf,0.0,0.0);
      else rgpulse(getval("pwX90"),ph2Xmix,0.0,0.0);
      decoff();
   }

// Optional DARR Mixing

   if (!strcmp(mMix,"darr")) {
      obspwrf(getval("aX90")); decpwrf(getval("aH90"));
      decon();
      rgpulse(getval("pwX90"),ph1Xmix,0.0,0.0);
      txphase(ph2Xmix);
      decpwrf(getval("aHmix"));
      obsunblank();
      delay(tXmix);
      decpwrf(getval("aH90"));
      rgpulse(getval("pwX90"),ph2Xmix,0.0,0.0);
      decoff();
   }
   
// Optional PARIS Mixing

   if (!strcmp(mMix, "paris")) {
      obspwrf(getval("aX90")); decpwrf(getval("aH90"));
      decon();
      rgpulse(getval("pwX90"),ph1Xmix,0.0,0.0);
      txphase(ph2Xmix);
      obsunblank();
      decoff();
      _paris(paris);
      delay(tXmix);
      decprgoff();
      decon();
      decpwrf(getval("aH90"));
      rgpulse(getval("pwX90"),ph2Xmix,0.0,0.0);
      decoff();
   }

// Optional RFDR Mixing 

   if (!strcmp(mMix, "rfdr")) {
      obspwrf(getval("aX90")); decpwrf(getval("aH90"));
      decon();
      rgpulse(getval("pwX90"),ph1Xmix,0.0,0.0);
      txphase(zero);
      decpwrf(getval("aHZF"));
      obsunblank();
      delay(getval("tZF"));
      decpwrf(getval("aHrfdr"));
      _mpseq(rfdr,zero);
      txphase(ph2Xmix); 
      obspwrf(getval("aX90")); decpwrf(getval("aHZF"));
      delay(getval("tZF"));
      decpwrf(getval("aH90"));
      rgpulse(getval("pwX90"),ph2Xmix,0.0,0.0);
      decoff();
   }
   
// F1 Indirect Period for X

   obspwrf(getval("aX90"));
   _dseqon2(dec);
   delay(d2);
   _dseqoff2(dec);

// Optional DARR Mixing tXmix1

   if (!strcmp(mMix1,"darr")) {
      obspwrf(getval("aX90")); decpwrf(getval("aH90"));
      decon();
      rgpulse(getval("pwX90"),ph3Xmix,0.0,0.0);
      txphase(ph4Xmix);
      decpwrf(getval("aHmix"));
      obsunblank();
      delay(tXmix1);
      decpwrf(getval("aH90"));
      rgpulse(getval("pwX90"),ph4Xmix,0.0,0.0);
      decoff();
   }

// Blank DEC3, Start Optional DEC2 Decoupling or Blank DEC2

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqon2(dec2);
   }
   else {
      if (NUMch > 2) dec2blank();
   }
   if (NUMch > 3) dec3blank();

// Begin Acquisition with DEC decoupling

   _dseqon2(dec);
   obsblank();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np,1.0/sw);
   endacq();

// Halt DEC Decoupling 

   _dseqoff2(dec);

// Halt Optional DEC2 Decoupling or Unblank DEC2, if Blanked

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqoff2(dec2);
   }
   else {
      if (NUMch > 2) dec2unblank();
   }

// Make DEC Constant-time with RF Following Acquisition

   decphase(zero);
   if (!strcmp(ctd,"y")) {
      decon(); 
      delay(tRF);
      decoff();
   }
   obsunblank(); decunblank(); _unblank34();
}
