/* ahxtYtX.c                        --Agilent BioSolids
                                                                         */
#include "standard.h"
#include "solidstandard.h"
#include "pboxpulse.h"
#include <CompSens.h> 

// Define Static Value to Hold d2 of First Increment

static double d2_init;

// Define Values for Phasetables

static int table1[4] =  {0,0,2,2};           // phH90
static int table2[8]  = {3,3,3,3,1,1,1,1};   // phXhx
static int table3[4] =  {3,3,3,3};           // phHhx
static int table4[4] =  {0,1,0,1};   	     // ph1Yredor
static int table5[4] =  {0,1,0,1};           // ph2Yredor
static int table6[4] =  {0,0,0,0};           // phX180p1
static int table7[4] =  {3,1,3,1};           // phY90
static int table8[4] =  {0,0,0,0};           // phX90
static int table11[4] = {0,0,0,0};           // phY180p2
static int table12[4] = {3,3,3,3};           // phXzf1
static int table13[4] = {3,3,3,3};           // phXzf2
static int table15[4] = {1,1,1,1};           // phXzf3
static int table16[4]=  {1,1,1,1};           // phYzf1
static int table14[8]=  {0,2,2,0,2,0,0,2};   // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define ph1Yredor t4
#define ph2Yredor t5
#define phX180p1 t6
#define phY90 t7
#define phX90 t8
#define phY180p2 t11
#define phXzf1 t12
#define phXzf2 t13
#define phRec t14
#define phXzf3 t15
#define phYzf1 t16

pulsesequence() { 

// Add NUS for this Sequence for SPARSE='y', (ni > 1) and (nimax >= ni + 1).

   char sparseval[MAXSTR];
   getstr("SPARSE",sparseval);
   if (sparseval[A] == 'y' && getval("ni") > 1.0 && getval("nimax") >= (getval("ni") + 1.0)) {
      (void) set_RS(0);
      ni = getval("nimax");
      if (ni < 1) ni = 1;
   }

// Else Force SPARSE='n'.

   else {          
      strncpy(sparseval,"n",3);
      putCmd("SPARSE='n'\n");
      printf("No F1 Array - Set SPARSE='n'\n");
   }

// Define Variables and Modules and Get Parameter Values

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec ",3);
   strncpy(hx.to,"obs ",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   DSEQ dec = getdseq2("H");
   DSEQ mix = getdseq2("Hmix");

// Choose DEC2 Decoupling

   char ddec2[MAXSTR];
   getstr("ddec2",ddec2);

   DSEQ dec2;
   if (!strcmp(ddec2,"y")) dec2 = getdseq2("Y");

// Determine taur, One Rotor Cycle

   double srate =  getval("srate");
   double taur = 0.0;
   if (srate >= 500.0)
      taur = roundoff((1.0/srate), 0.125e-6);
   else {
      printf("ABORT: Spin Rate (srate) must be greater than 500\n");
      psg_abort(1);
   }

// Calculate REDOR Delays from taur One Rotor Cycle

   double tauY0 =taur/2.0 - getval("pwYredor")/2.0;
   double tauY = taur/2.0 -  getval("pwYredor");

// Calculate Refocusing Delays from taur One Rotor Cycle

   int nzf = floor((getval("pwXredor") + getval("pwYredor"))/taur) + 2.0;
   double tauZ = nzf*taur - getval("pwXredor")/2.0 - getval("pwYredor")/2.0;
   int nbase = floor((getval("pwXshp1") + getval("pwYredor") + 10.0e-6)/taur) + 2.0;
   double tauB = (nbase*taur - getval("pwXshp1") - getval("pwYredor") - 10.0e-6)/2.0;

// Calculate Redor Cycles

   int nredor = (int) (getval("nredor"));
   int nredor_max = (int) (getval("nredor_max"));
   initval(nredor - 1.0,v8);

// Calculate a Band Selective Refocusing Pulse

   PBOXPULSE shp1 = getpboxpulse("shp1X",0,1);
   strncpy(shp1.ch,"obs",3);
   putCmd("chXshp1 ='obs'\n");

// Set the TEDOR Flag

   char tedor_flag[MAXSTR];
   getstr("tedor_flag",tedor_flag);

// Set the Zed-Filter Flag

   char ZF_flag[MAXSTR];
   getstr("ZF_flag",ZF_flag);

// Calculate the F1 Acquisition Time

   if (d2_index == 0) d2_init = getval("d2");
   double d2_ = (ni - 1)/sw1 + d2_init;
   putCmd("d2acqret = %f\n",roundoff(d2_,12.5e-9));
   putCmd("d2dwret = %f\n",roundoff(1.0/sw1,12.5e-9)); 

// Calculate Constant-time F1 with Rotor-synchronized t2max

   double timeZF = getval("tZF");
   if(!strcmp(ZF_flag, "grad")) timeZF = timeZF + getval("tZF2");

   double ncomp = ceil((d2_ + getval("pwY90")*2.0 + getval("pwX90") +
   	                timeZF)/taur);
   double t2max = ncomp*taur;
   double tcomp = t2max - d2_ - getval("pwY90")*2.0 - getval("pwX90") -
                        timeZF;

// Calculate the Constant-time MIX Decoupling Period tredor_comp

   double tredor = taur*4.0*nredor;
   double tredor_max = taur*4.0*nredor_max;
   double tredor_comp = tredor_max - tredor;
   if(tredor_comp < 0.0)tredor_comp = 0.0;

// Calculate the Constant-time DEC Decoupling Period tRF

   char ctd[MAXSTR];
   getstr("ctd",ctd);

   double tRF = 0.0;
   double tRFmax = getval("tRFmax");
   if (!strcmp(ctd,"y")) {
      if (tRFmax <= t2max) tRFmax = t2max;
      tRF = tRFmax - t2max;
      putCmd("tRFmax = %f\n",tRFmax*1.0e6);
   }

// Set tRFmax = 0.0 for No Constant-time Decoupling

   else {
      tRFmax = 0.0;
      putCmd("tRFmax = 0.0\n");
   }

// Copy Current Parameters to Processed

   putCmd("groupcopy('current','processed','acquisition')");

// Dutycycle Protection

   double duty = 4.0e-6 + getval("pwH90") + getval("tHX")
                        + getval("ad") + getval("rd") + at;
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100.0);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,8,table2);
   settable(phHhx,4,table3);
   settable(ph1Yredor,4,table4);
   settable(ph2Yredor,4,table5);
   settable(phX180p1,4,table6);
   settable(phY90,4,table7);
   settable(phX90,4,table8);
   settable(phXzf1,4,table12);
   settable(phXzf2,4,table13);
   settable(phXzf3,4,table15);
   settable(phYzf1,4,table16);
   settable(phRec,8,table14);
   setreceiver(phRec);

   if (phase1 == 2)
     tsadd(phY90,3,4);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   _cp_(hx,phHhx,phXhx);

// First REDOR Period 1

  _dseqon2(mix);
  txphase(phX180p1);
  obspwrf(getval("aXredor")); dec2pwrf(getval("aYredor"));
  sub(v11,v11,v11);
  if (nredor >= 2) {
      delay(tauY0);
      getelem(ph1Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      getelem(ph1Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      delay(tauY);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      loop(v8,v9);
         getelem(ph1Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         delay(tauY);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
         getelem(ph1Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         delay(tauY);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      endloop(v9);
   }

// Hard Square X Refocussing Pulse

   if (!strcmp(tedor_flag, "ZF")) {
      txphase(phX180p1);
      obspwrf(getval("aXredor"));
      delay(tauZ);
      rgpulse(getval("pwXredor"),phX180p1,0.0,0.0);
      txphase(phXzf1);
      obspwrf(getval("aX90"));
      delay(tauZ);
   }

// Soft shaped X Refocussing Pulse

   if (!strcmp(tedor_flag, "BASE")) {
      txphase(phX180p1);
      obsblank();
      obspower(getval("dbXshp1"));
      delay(3.0e-6);
      obsunblank();
      delay(2.0e-6);
      obspwrf(getval("aXshp1"));
      delay(tauB);
      _pboxpulse(shp1,phX180p1);
      obspower(tpwr);
      delay(3.0e-6);
      obsunblank();
      delay(2.0e-6);
      txphase(phXzf1);
      obspwrf(getval("aX90"));
      delay(tauB);
   }

// First REDOR Period 2

   if (nredor >= 2) {
      loop(v8,v9);
         getelem(ph1Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
         delay(tauY);
         getelem(ph1Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
         delay(tauY);
      endloop(v9);
      getelem(ph1Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      delay(tauY);
      getelem(ph1Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      delay(tauY0);
   }
   _dseqoff2(mix);

// TEDOR Transfer with a Zed-filter and Gradient

   if (getval("aHZF") > 0) {
      decpwrf(getval("aHZF"));
      decon();
   }

   rgpulse(getval("pwX90"),phXzf1,0.0,0.0);

   if(!strcmp(ZF_flag, "grad")) {
      rgradient('z',getval("gzlvl1"));
      delay(getval("tZF2"));
      rgradient('z',0.0);
   }

   dec2phase(phYzf1);
   dec2pwrf(getval("aY90"));
   delay(getval("tZF"));
   dec2rgpulse(getval("pwY90"),phYzf1,0.0,0.0);

   if (getval("aHZF") > 0) decoff();

// Standard F1 Period For Y

   _dseqon2(dec);
   dec2phase(phY90);
   dec2pwrf(getval("aY90"));
   delay(d2);
   _dseqoff2(dec);
   _dseqon2(mix);
   dec2rgpulse(getval("pwY90"),phY90,0.0,0.0);

// Delay for Rotor Synchronization

   delay(tcomp);

//Second REDOR Period 1

   txphase(phX180p1);
   obspwrf(getval("aXredor")); dec2pwrf(getval("aYredor"));
   sub(v11,v11,v11);
   if (nredor >= 2) {
      delay(tauY0);
      getelem(ph2Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      getelem(ph2Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      delay(tauY);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      loop(v8,v9);
         delay(tauY);
         getelem(ph2Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
         getelem(ph2Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         delay(tauY);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);                           	   	           
      endloop(v9);
   }

// Hard Square X Refocussing Pulse

   if (!strcmp(tedor_flag, "ZF")) {
      txphase(phX180p1);
      obspwrf(getval("aXredor"));
      delay(tauZ);
      rgpulse(getval("pwXredor"),phX180p1,0.0,0.0);
      txphase(phXzf1);
      obspwrf(getval("aX90"));
      delay(tauZ);
   }

// Soft shaped X Refocussing Pulse

   if (!strcmp(tedor_flag, "BASE")) {
      txphase(phX180p1);
      obsblank();
      obspower(getval("dbXshp1"));
      delay(3.0e-6);
      obsunblank();
      delay(2.0e-6);
      obspwrf(getval("aXshp1"));
      delay(tauB);
      _pboxpulse(shp1,phX180p1);
      obspower(tpwr);
      delay(3.0e-6);
      obsunblank();
      delay(2.0e-6);
      txphase(phXzf1);
      obspwrf(getval("aX90"));
      delay(tauB);
   }

// Second REDOR PERIOD 2

   if (nredor >= 2) {
      loop(v8,v9);
         getelem(ph2Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
         delay(tauY);
         getelem(ph2Yredor,v11,v12);
         dec2phase(v12);
         incr(v11);
         dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
         delay(tauY);
      endloop(v9);
      getelem(ph2Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      delay(tauY);
      getelem(ph2Yredor,v11,v12);
      dec2phase(v12);
      incr(v11);
      dec2rgpulse(getval("pwYredor"),v12,0.0,0.0);
      delay(tauY0);
   }
   _dseqoff2(mix);

// Zed-filter Period No Gradient

   if (getval("aHZF") > 0) {
      decpwrf(getval("aHZF"));
      decon();
   }

   rgpulse(getval("pwX90"),phXzf1,0.0,0.0);
   obspwrf(getval("aX90"));
   txphase(phXzf2);
   delay(getval("tZF"));
   rgpulse(getval("pwX90"),phXzf2,0.0,0.0);

   if (getval("aHZF") > 0) decoff();

 // Blank DEC3, Start Optional DEC2 Decoupling or Blank DEC2

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqon2(dec2);
   }
   else {
      if (NUMch > 2) dec2blank();
   }
   if (NUMch > 3) dec3blank();

// Begin Acquisition with DEC decoupling

   _dseqon2(dec);
   obsblank();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();

// Halt DEC Decoupling 

   _dseqoff2(dec);

// Halt Optional DEC2 Decoupling or Unblank DEC2, if Blanked

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqoff2(dec2);
   }
   else {
      if (NUMch > 2) dec2unblank();
   }

// Make DEC Constant-time with RF Following Acquisition

   decphase(zero);
   if (!strcmp(ctd,"y")) {
      _dseqon2(dec); 
      delay(tRF);
      _dseqoff2(dec);
   }
   _dseqon2(mix);
   delay(tredor_comp);
   _dseqoff2(mix);
   obsunblank(); decunblank(); _unblank34();
}

