//dfs.h - An implementation function for a double frequency sweep that uses
//        make_waveform(). Include make_waveform1.h before this function,
//        after solidstandard.h.  D. Rice 5/17/06

//======================
//   DFS
//======================

MPSEQ getdfs(char *seqName, int iph, double p, double phint, int iRec, int calc)
{
   int i;
   MPSEQ dfs;
   extern MPSEQ MPchopper(MPSEQ dfs);
   char *var;

   if (strlen(seqName) > NSUFFIX  || strlen(seqName) < 1){
      printf("Error in getdfs()! The type name %s is invalid !\n",seqName);
      psg_abort(1);
   }
   sprintf(dfs.seqName,seqName);
   dfs.calc = calc;
   dfs.array = parsearry(dfs.array);

// Obtain Phase Arguments

   dfs.phAccum = p;
   dfs.phInt = phint;
   dfs.iSuper = iph;
   dfs.nRec = iRec;

// Determine the Maximum nphBase from the Pulse Width

//pwXdfs

   var = getname0("pw",dfs.seqName,"");
   double lpw = getval(var);
   lpw = roundoff(lpw,0.2e-6);
   dfs.array = disarry(var, dfs.array);

   if (PWRF_DELAY > 0.0) dfs.n90 = 16; 
   else dfs.n90 = 8;  
   double dstep = dfs.n90*DTCK;
   double steps = lpw/dstep;
   int nsteps = ((int) (steps + 0.5));

// Allocate Arrays

   int nphBase = nsteps;
   int nphSuper = 1;
   int npw = nphBase;
   int nph = nphBase;
   int nof = nphBase;
   int na = nphBase;
   int ng = nphBase;
   MPinitializer(&dfs,npw,nph,nof,na,ng,nphBase,nphSuper);

//of1Xdfs

   var = getname0("of1",dfs.seqName,"");
   double loffset1 = getval(var);
   dfs.array = disarry(var, dfs.array);

//of2Xdfs

   var = getname0("of2",dfs.seqName,"");
   double loffset2 = getval(var);
   dfs.array = disarry(var, dfs.array);

// Parameters for waveform calculation

   double lstep = dfs.n90*DTCK;
   double lminstep = lstep;
   nsteps = (int) (lpw/lstep + 0.5);
   double ldres = 90.0;
   double minstep = ldres*lminstep/lstep;
   double sweeprate = 0.0;
   if (lpw > 0.0) sweeprate = (loffset2 - loffset1)/lpw;

// Begin Calculation

   double amp,phase,gate,delayflag;
   double time = lstep/2.0;
   double phase1 = 0.0;

   initialize_waveform();
   amp = 0.0;
   phase = 0.0;
   gate=0.0;
   delayflag=0.0;
   for(i = 0; i < nsteps; i++)
   {
      phase1 = phase1 + 2*3.14159*(loffset1 + sweeprate*time)*lstep;
      amp = 1023.0*cos(phase1);
      phase = 0.0;
      if (amp < 0.0)
      {
         amp = -amp;
         phase = 180.0;
      }
      amp = round_amp(amp);
      phase = round_phase(phase);
      gate = 1.0;
      delayflag = 0.0;
      make_waveform(amp,phase,gate,delayflag,ldres,minstep);
      time = time + lstep;
   }
   make_waveform(amp,phase,gate,1.0,ldres,minstep);

   compress_steps(ldres);
   dfs.n90 = dfs.n90*dmffactor; 

   if (wstep > NPW) {
      printf("Error in getdfs()! Too many steps, q!");
      psg_abort(1);
   }

   for (i = 0; i < wstep; i++) {
      dfs.phBase[i] = waveform[i].phase;
      dfs.aBase[i] = waveform[i].amp;
      dfs.gateBase[i] = waveform[i].gate;
      dfs.pw[i] = waveform[i].tip*dfs.n90*DTCK/90.0;
      dfs.of[i] = 0.0;
   }

// Set the Actual Number of Steps

   dfs.nphBase = wstep;

// Write Waveform Output to the Text Window

   fprintf(stdout,"\n");
   fprintf(stdout,"DFSWEEP - Double Frequency Sweep - .decpattern\n");
   fprintf(stdout,"waveform step size = %f microseconds.\n",lstep*1e6*dmffactor);
   fprintf(stdout,"waveform steps = %d steps.\n",wstep);
   fprintf(stdout,"sweeptime = %f us \n", lpw*1e6);
   fprintf(stdout,"sweeprate = %e Hz/s \n", sweeprate);
   fprintf(stdout,"total duration = %f microseconds\n",(tduration*lstep*1e6/ldres));
   fprintf(stdout,"ticks per minimum step = %d\n",dfs.n90);

// Set the Supercycle Phase List

   dfs.phSuper[0] = 0.0;

// Set the Overall Amplitude, Elements and Channel

//aXdfs

   var = getname0("a",dfs.seqName,"");
   dfs.a = getval(var);

//Set One Element 

   dfs.nelem = 1;

//chXdfs

   var = getname0("ch",dfs.seqName,"");
   Getstr(var,dfs.ch,sizeof(dfs.ch));

// Create the Shapefile Name

   char lpattern[NPATTERN];
   var = getname0("",dfs.seqName,"");
   sprintf(lpattern,"%s%d",var,dfs.nRec);
   dfs.hasArray = hasarry(dfs.array, lpattern);
   int lix = arryindex(dfs.array);
   if (dfs.calc > 0) {   
      var = getname0("",dfs.seqName,"");
      sprintf(dfs.pattern,"%s%d_%d",var,dfs.nRec,lix);
      if (dfs.hasArray == 1) {
         dfs = MPchopper(dfs);
         dfs.iSuper = iph + dfs.nelem%dfs.nphSuper;
      }
      dfs.t = gett(lix, lpattern);
   }
   return dfs;
}
