/*babadpinad2d.c - A sequence to provide homonuclear correlation with
               a 2Q-1Q presentation using BABA as a double quantum
               preparation and mixing sequence and providing CW decoupling
               during BABA with SPINAL or TPPM decoupling during F1 and
               F2.

               D. Rice 03/18/08                                        */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,0,0,0};           // phHdec
static int table2[4] = {3,3,3,3};           // phXmix1
static int table3[4] = {0,1,2,3};           // phXmix2
static int table4[4] = {0,3,2,1};           // phRec

#define phHdec t1
#define phXmix1 t2
#define phXmix2 t3
#define phRec t4

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   MPSEQ baba = getbaba("babaX",0,0.0,0.0,0,1);
   MPSEQ babaref = getbaba("babaX",baba.iSuper,baba.phAccum,baba.phInt,1,1);
   strncpy(baba.ch,"obs",3);
   putCmd("chXbaba='obs'\n");

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + 2.0*getval("tZF") + baba.t +
          d2 + babaref.t + getval("ad") + getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6 + 2.0*getval("tZF"));
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phHdec,4,table1);
   settable(phXmix1,4,table2);
   settable(phXmix2,4,table3);
   settable(phRec,4,table4);

// Add STATES-TPPI (STATES + "FAD")

   double obsstep = 360.0/(PSD*8192);

   if (phase1 == 2)
      initval((45.0/obsstep),v1);
   else
      initval(0.0,v1);

   initval((d2*baba.of[0]*360.0/obsstep),v2);
   obsstepsize(obsstep);
   setreceiver(phRec);

// Begin Sequence

   xmtrphase(v1); txphase(phXmix1); decphase(phHdec);
   obspwrf(getval("aXbaba")); decpwrf(getval("aHmix"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// Mixing with BABA Recoupling-Period One

   decon();
   _mpseq(baba, phXmix1);
   decoff();

// F1 Indirect Period For X

   xmtrphase(v2); txphase(phXmix2);
   _dseqon(dec);
   delay(d2);
   _dseqoff(dec);

// Mixing with BABA Recoupling-Period Two

   decpwrf(getval("aHmix"));
   decunblank();
   decon();
   _mpseq(babaref, phXmix2);
   decoff();

// Read-out Pulse

   obspwrf(getval("aX90"));
   xmtrphase(zero); txphase(phXmix2);
   delay(getval("tZF"));
   rgpulse(getval("pwX90"),phXmix2,0.0,0.0);

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

