/* grad_profile.c - pulse sequence to measure the gradient profile 
                    using direct polarization and a spin echo, with 
                    TPPM or SPINAL decoupling throughout. 

                    J. Stringer 05/06/2010  

                    RF - pwX90__________pwX180______Acq_____
                    GZ - _____+GZ---__________+GZ-----------
                                                               */
#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,2,1,3};           // phX90
static int table2[4] = {1,3,2,0};           // phXecho
static int table3[4] = {0,2,1,3};           // phRec

#define phX90 t1
#define phXecho t2
#define phRec t3

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;
   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwX90") + 2.0*getval("gpwZgrad") + getval("t1Xecho") + 
                   getval("pwXecho") + getval("t2Xecho") + getval("ad") + 
                   getval("rd") + at;
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Maximum Gradient Time On

   duty = getval("ad") + getval("rd") + at + 2.0*getval("gpwZgrad");
   if (duty > 0.01) {
      printf("Gradient on longer than 10ms. Abort!\n");
      psg_abort(1);
   }

// Set Phase Tables

   settable(phX90,4,table1);
   settable(phXecho,4,table2);
   settable(phRec,4,table3);
   setreceiver(phRec);

// Begin Sequence

   txphase(phX90); decphase(zero);
   obspwrf(getval("aX90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H Decoupler on Before Echo

   _dseqon(dec);

// X Direct Polarization

   rgpulse(getval("pwX90"),phX90,0.0,0.0);
   txphase(phXecho); 
   obspwrf(getval("aXecho")); 
   obsunblank();

// Gradient pulse

   zgradpulse(getval("gaZgrad"),getval("gpwZgrad"));

// X Inversion

   delay(getval("t1Xecho"));
   rgpulse(getval("pwXecho"),phXecho,0.0,0.0);
   obsunblank();
   delay(getval("t2Xecho"));

// Begin Acquisition

   rgradient('z',getval("gaZgrad"));
   delay(getval("gpwZgrad"));
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   rgradient('z',0.0);
   obsunblank(); decunblank(); _unblank34();
}

