/*mqmas3qzf2d.c - A sequence to generate a two pulse MQMAS 2D spectrum
                  with a third Z-filter pulse, using a 3Q phase cycle.

                  D. Rice 02/22/06                                    */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[6] = {0,0,0,0,0,0};               // phHdec
static int table2[6] = {0,60,120,180,240,300};      // phf1Xmqmas
static int table3[6] = {0,0,0,0,0,0};               // ph1Xmqmas
static int table4[6] = {0,0,0,0,0,0};               // phf2Xmqmas
static int table5[6] = {0,0,0,0,0,0};               // ph2Xmqmas
static int table6[24] = {0,0,0,0,0,0,1,1,1,1,1,1,   // phXzfsel
                         2,2,2,2,2,2,3,3,3,3,3,3};
static int table7[24] = {1,3,1,3,1,3,2,0,2,0,2,0,   // phRec
                         3,1,3,1,3,1,0,2,0,2,0,2};

#define phHdec t1
#define phf1Xmqmas t2
#define ph1Xmqmas t3
#define phf2Xmqmas t4
#define ph2Xmqmas t5
#define phXzfsel t6
#define phRec t7

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   double tXzfselinit = getval("tXzfsel"); // Adjust the Z-filter Delay for the
   double tXzfsel = tXzfselinit - 3.0e-6;  // attenuator switch time.
   if (tXzfsel < 0.0) tXzfsel = 0.0;

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pw1Xmqmas") + d2 + getval("pw2Xmqmas") + tXzfselinit +
                   getval("pwXzfsel") + getval("rd") + getval("ad") + at;
   double duty1 = 0.0;
   double aHtppm = getval("aHtppm"); 
   double aHspinal = getval("aHspinal");
   if ((aHtppm == 0.0) || (aHspinal == 0.0)) {
      duty1 = duty1 + duty - d2 - tXzfselinit - getval("rd") - getval("ad") - at;
   }
   else duty1 = duty;
   duty = duty1/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phHdec,6,table1);
   settable(phf1Xmqmas,6,table2);
   settable(ph1Xmqmas,6,table3);
   settable(phf2Xmqmas,6,table4);
   settable(ph2Xmqmas,6,table5);
   settable(phXzfsel,24,table6);
   settable(phRec,24,table7);

   if (phase1 == 2) {
      tsadd(phf1Xmqmas,30,360);
   }
   setreceiver(phRec);
   obsstepsize(1.0);

// Begin Sequence

   xmtrphase(phf1Xmqmas); txphase(ph1Xmqmas); decphase(phHdec);
   obspower(getval("tpwr"));
   obspwrf(getval("aXmqmas"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H Decoupler on Before MQMAS

   _dseqon(dec);

// Two-Pulse MQMAS

   rgpulse(getval("pw1Xmqmas"),ph1Xmqmas,0.0,0.0);
   xmtrphase(phf2Xmqmas); txphase(ph2Xmqmas);
   obsunblank();
   delay(d2);
   rgpulse(getval("pw2Xmqmas"),ph2Xmqmas,0.0,0.0);

// Selective Z-filter Pulse

   txphase(phXzfsel);
   obsblank();
   obspower(getval("dbXzfsel"));
   obspwrf(getval("aXzfsel"));
   delay(3.0e-6);
   obsunblank();
   delay(tXzfsel);
   rgpulse(getval("pwXzfsel"),phXzfsel,0.0,0.0);

// Begin Acquisition

   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

