/*onepulmdfs.c - A sequence to do direct polarization of quadruple nuclei with
                 TPPM and SPINAL decoupling, using a multiple double frequency 
                 sweep pulse

                 D.Rice 03/13/07                                            */

#include "standard.h"
#include "solidstandard.h"
#include "make_waveform1.h"
#include "mdfs.h"

// Define Values for Phasetables

static int table1[4] = {1,1,1,1};           // phXmdfs
static int table2[4] = {0,2,1,3};           // phX90
static int table3[4] = {0,2,1,3};           // phRec

#define phXmdfs t1
#define phX90 t2
#define phRec t3

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;
 
   MPSEQ mdfs = getmdfs("mdfsX",0,0.0,0.0,0,1);
   strncpy(mdfs.ch,"obs",3);
   putCmd("chXmdfs='obs'\n");
   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwX90") + getval("ad") + getval("rd") + at;
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phXmdfs,4,table1);
   settable(phX90,4,table2);
   settable(phRec,4,table3);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXmdfs); decphase(zero);
   obspwrf(getval("aXmdfs"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);  
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// Start Decoupling on H

   _dseqon(dec);

// X Double Frequency Sweep Pulse

   if (getval("pwXmdfs") > 0.0) {
      _mpseq(mdfs,phXmdfs);
   }
   txphase(phX90);
   obspwrf(getval("aX90"));
   delay(200.0e-6);

// X Direct Polarization 

   rgpulse(getval("pwX90"),phX90,0.0,0.0);

// Begin Acquisition 

   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

