/*rocsa2d.c - A 2D Experiment to correlate CH dipole with recoupled CSA,
              with SPINAL and TPPM decoupling.

              D. Rice 7/31/07                                          */
                                                                     
#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,2,0,2};           // phH90
static int table2[4] = {0,0,1,1};           // phXhx
static int table3[4] = {1,1,1,1};           // phHhx
static int table4[4] = {0,0,0,0};           // phHmix
static int table5[4] = {0,0,0,0};           // phXr18
static int table6[4] = {0,0,0,0};           // ph1X90
static int table7[4] = {0,0,0,0};           // pH2X90
static int table8[4] = {0,0,0,0};           // phXrfdr
static int table9[4] = {0,0,0,0};           // ph3X90
static int table10[4] = {0,0,0,0};          // phHlg
static int table11[4] = {0,0,0,0};          // phXlgref
static int table12[4] = {0,0,0,0};          // phHdec
static int table13[4] = {0,2,1,3};          // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHmix t4
#define phXr18 t5
#define ph1X90 t6
#define ph2X90 t7
#define phXrfdr t8
#define ph3X90 t9
#define phHlg t10
#define phXlgref t11
#define phHdec t12
#define phRec t13

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   MPSEQ r18 = getr1825("r18X",0,0.0,0.0,0,1);
   strncpy(r18.ch,"obs",4);
   putCmd("chXr18='obs'\n");

   MPSEQ rfdr = getrfdrxy8("rfdrX",0,0.0,0.0,0,1);
   strncpy(rfdr.ch,"obs",4);
   putCmd("chXrfdr='obs'\n");

   MPSEQ lg = getlg("lgH",0,0.0,0.0,0,1);
   strncpy(lg.ch,"dec",4);
   putCmd("chHlg='dec'\n");

   double aXlgref = getval("aXlgref"); 
   double pwXlgref = getval("pwXlgref");
   double time = getval("tHlg");
   double t1Xlgref = time/2.0;
   double t2Xlgref = time/2.0 - pwXlgref/2.0;

   DSEQ dec = getdseq("H");
   DSEQ mix = getdseq("Hmix");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(phHmix,4,table4);
   settable(phXr18,4,table5);
   settable(ph1X90,4,table6);
   settable(ph2X90,4,table7);
   settable(phXrfdr,4,table8);
   settable(ph3X90,4,table9);
   settable(phHlg,4,table10);
   settable(phXlgref,4,table11);
   settable(phHdec,4,table12);
   settable(phRec,4,table13);
   setreceiver(phRec);
    
// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// R1852 on X for CSA Recoupling

    decphase(phHmix);
   _dseqon(mix);
   _mpseq(r18, phXr18);

// Quadrature Selection and T1 Period

   obspwrf(getval("aX90"));
   rgpulse(getval("pwX90"),ph1X90,0.0,0.0);
   txphase(ph2X90);
   obspwrf(getval("aX90"));
   delay(d2);

// RFDR Mixing Period

   rgpulse(getval("pwX90"),ph2X90,0.0,0.0);
   _mpseq(rfdr,phXrfdr);
   obspwrf(getval("aX90"));
   rgpulse(getval("pwX90"),ph3X90,0.0,0.0);
   txphase(phXlgref);
   obspwrf(aXlgref);

// 2*taur X Refocussing Pulse with taur Lee Goldburg Decoupling

   delay(t1Xlgref);
   _dseqoff(mix);
   _mpseqon(lg,phHlg);
   delay(t2Xlgref);
   rgpulse(pwXlgref,phXlgref,0.0,0.0);
   delay(t2Xlgref);
   _mpseqoff(lg);
   decphase(phHdec);
   _dseqon(dec);
   delay(t1Xlgref);

// Begin Acquisition

   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}
