/*wisetancp2d.c - A sequence to provide correlation between the
                  X chemical-shift and 1H wideline spectrum using 
                  Lee_Goldburg CP and Decoupling on X.

                  D.Rice 12/15/05
                  Full NOESY cycle 06/14/07                          
                  Lee-Goldburg CP and decoupling  04/09/10        */

#include "solidstandard.h"
#include <standard.h>

// Define Values for Phasetables

static int table1[16] = {0,2,2,0,3,1,1,3,2,0,0,2,1,3,3,1}; // phH90
static int table2[16] = {0,0,0,0,3,3,3,3,2,2,2,2,1,1,1,1}; // phHmix1
static int table3[4] = {0,0,2,2};                          // phHmix2
static int table4[4] = {2,2,2,2};                           // phHtilt
static int table5[4] = {0,0,1,1};                          // phXhx
static int table6[4] = {1,1,1,1};                          // phHhx
static int table7[4] = {0,2,1,3};                          // phRec

#define phH90 t1
#define phHmix1 t2
#define phHmix2 t3
#define phHtilt t4
#define phXhx t5
#define phHhx t6
#define phRec t7

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   DSEQ dec = getdseq("H");
   DSEQ xdec = getdseq("X");
   strncpy(xdec.t.ch,"obs",3);    // These four statements assure 
   strncpy(xdec.s.ch,"obs",3);    // that the X decoupling will
   putCmd("chXtppm='obs'\n");     // be on X for either TPPM or 
   putCmd("chXspinal='obs'\n");   // SPINAL. 

// Dutycycle Protection

   duty = 4.0e-6 + 3.0*getval("pwH90") + d2 + getval("tHmix") + getval("tHX")
                 + getval("ad") + getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,16,table1);
   settable(phHmix1,16,table2);
   settable(phHmix2,4,table3);
   settable(phHtilt,4,table4);
   settable(phXhx,4,table5);
   settable(phHhx,4,table6);
   settable(phRec,4,table7);

   if (phase1 == 2) tsadd(phH90,1,4);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H Preparation and tilt

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decunblank();

// Delay for 1H Wideline T2

   _dseqon(xdec);
   delay(d2);
   _dseqoff(xdec); 

// Mix period for Spin Diffison

   decrgpulse(getval("pwH90"),phHmix1,0.0,0.0);
   delay(getval("tHmix"));
   decrgpulse(getval("pwH90"),phHmix2,0.0,0.0);

// Tilt Pulse and Ramped H to X Cross Polarization with LG Offset

   decrgpulse(getval("pwHtilt"),phHtilt,0.0,0.0);
   decphase(phHhx);
   _cp_(hx,phHhx,phXhx);

// Begin Acquisition

   obsblank(); _blank34();
   _dseqon(dec);
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}
