/*xxctuc1sh2ds.c - Constant time uniform crosspeak COSY for
                   Aliphatic Correlation 

            Chen et. al. JACS (2006)
            D. Rice 7/9/08                                */

#include "standard.h"
#include "solidstandard.h"
#include "pboxpulse.h"

// Define Values for Phasetables

static int table1[4] = {1,1,1,1};           // phH90
static int table2[4] = {0,0,0,0};           // phXhx
static int table3[4] = {0,0,0,0};           // phHhx
static int table4[4] = {0,0,0,0};           // phHspnlm
static int table5[4] = {0,0,0,0};           // phXshp1
static int table6[4] = {0,0,0,0};           // phXshp2
static int table7[4] = {1,1,1,1};           // ph1X90
static int table8[4] = {0,0,0,0};           // ph2X90
static int table9[4] = {1,1,1,1};           // phXshp3
static int table10[4] = {0,0,0,0};          // ph3X90
static int table11[4] = {1,2,1,2};          // ph4X90
static int table12[4] = {0,0,0,0};          // phHspnl
static int table13[4] = {0,0,0,0};          // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHspnlm t4
#define phXshp1  t5
#define phXshp2  t6
#define ph1X90 t7
#define ph2X90 t8
#define phXshp3 t9
#define ph3X90 t10
#define ph4X90 t11
#define phHspnl t12
#define phRec t13

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   int decmode = getval("decmode");
   int decmodem = getval("decmodem");

   double tmd22 = getval("tconst") - getval("d2")/2.0;
   if (tmd22 < 0.0) tmd22 = 0.0;
   double tau0 = getval("tconst");
   double d22 = getval("d2")/2.0 - getval("pwX90");
   if (d22 < 0.0) d22 = 0.0;
   double tau1 = getval("tconst") - getval("pwX90");
   if (tau1 < 0.0) tau1 = 0.0;
   double tau2 = getval("tconst") - getval("pwX90")/2.0;
   if (tau2 < 0.0) tau2 = 0.0;
   double tZF = getval("tconst") - getval("pwX90");

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   PBOXPULSE shp1 = getpboxpulse("shp1X",0,1);
   strncpy(shp1.ch,"obs",3);
   putCmd("chHshp1 ='obs'\n");

   PBOXPULSE shp2 = getpboxpulse("shp2X",0,1);
   strncpy(shp2.ch,"obs",3);
   putCmd("chHshp2 ='obs'\n");

   PBOXPULSE shp3 = getpboxpulse("shp3X",0,1);
   strncpy(shp3.ch,"obs",3);
   putCmd("chHshp3 ='obs'\n");

   MPSEQ spnlm;
   if (decmodem>1) {
      spnlm = getspnl("spnlmH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

   MPSEQ spnl;
   if (decmode>1) {
      spnl = getspnl("spnlH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(phHspnlm,4,table4);
   settable(phXshp1,4,table5);
   settable(phXshp2,4,table6);
   settable(ph1X90,4,table7);
   settable(ph2X90,4,table8);
   settable(phXshp3,4,table9);
   settable(ph3X90,4,table10);
   settable(ph4X90,4,table11);
   settable(phHspnl,4,table12);
   settable(phRec,4,table13);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));  
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization 

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// F1 Period

   if (decmodem>0){ decpwrf(getval("aHspnlm")); decon(); if (decmodem>1){ _mpseqon(spnlm,phHspnlm);}}
   txphase(phXshp1);
   obspwrf(getval("aXshp1"));
   delay(tmd22);
   _pboxpulse(shp1,phXshp1);
   txphase(phXshp2);
   obspwrf(getval("aXshp2"));
   delay(tau0);
   _pboxpulse(shp2,phXshp2);
   txphase(ph1X90);
   obspwrf(getval("aX90"));
   delay(d22);
   rgpulse(getval("pwX90"),ph1X90,0.0,0.0);

// Refocus Period

   rgpulse(getval("pwX90"),ph2X90,0.0,0.0);
   txphase(phXshp3);
   obspwrf(getval("aXshp3"));
   obsunblank();
   delay(tau1);
   _pboxpulse(shp3,phXshp3);
   txphase(ph3X90);
   obspwrf(getval("aX90"));
   delay(tau2);
   if (decmodem>0){ decoff(); if (decmodem>1){ _mpseqoff(spnlm);}}

// Zed-Filter

   if (decmode>0){ decpwrf(getval("aHspnl")); decon(); if (decmode>1){ _mpseqon(spnl,phHspnl);}}
   rgpulse(getval("pwX90"),ph3X90,0.0,0.0); 
   txphase(ph3X90);
   obsunblank();
   delay(tZF);
   rgpulse(getval("pwX90"),ph4X90,0.0,0.0);

// Begin Acquisition

   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   obsunblank(); decunblank(); _unblank34();
}

