/*mqmas3q2d.c - A sequence to generate a two pulse MQMAS 2D spectrum
                using a 3Q phase cycle.

                D. Rice 06/14/06                                    */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[24] = {0,60,120,180,240,300,90,150,210,270,330,30,
                        180,240,300,0,60,120,270,330,30,90,150,210};
                                                    // phf1Xmqmas
static int table2[24] = {1,1,1,1,1,1,2,2,2,2,2,2,
                        3,3,3,3,3,3,0,0,0,0,0,0};   // ph2Xmqmas
static int table3[24] = {0,2,0,2,0,2,1,3,1,3,1,3,
                        2,0,2,0,2,0,3,1,3,1,3,1};   // phRec

#define phf1Xmqmas t1
#define ph2Xmqmas t2
#define phRec t3

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pw1Xmqmas") + d2 + getval("pw2Xmqmas") +
                   getval("rd") + getval("ad") + at;
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phf1Xmqmas,24,table1);
   settable(ph2Xmqmas,24,table2);
   settable(phRec,24,table3);

   if (phase1 == 2) {
      tsadd(phf1Xmqmas,30,360);
   }
   setreceiver(phRec);
   obsstepsize(1.0);

// Begin Sequence

   xmtrphase(phf1Xmqmas); decphase(zero);
   obspower(getval("tpwr"));
   obspwrf(getval("aXmqmas"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H Decoupler on Before MQMAS

   _dseqon(dec);

// Two-Pulse MQMAS with DFS Conversion

   rgpulse(getval("pw1Xmqmas"),zero,0.0,0.0);
   xmtrphase(zero); txphase(ph2Xmqmas);
   delay(d2);
   rgpulse(getval("pw2Xmqmas"),ph2Xmqmas,0.0,0.0);

// Begin Acquisition

   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

