#include "weight.h"
/*
trap.c -	trapezoidal window function

Contact:	Douglas E. Brown
		Eastman Kodak
		Rochester, NY 14650-2132
		(716)477-5175
		debrown@kodak.com

           ----------------------------
         /                              \
        /                                \
       /                                  \
______/                                    \___________________
      a   b                            c   d

a = wtconst[0] b = wtconst[1] c = wtconst[2] d = wtconst[3]
a-d correspond to the break points shown above as integer
data points of the real data; i.e. d will often be np/2 to
have the data converge to zero regardless of what fn is.

for a trapezoidal window that looks like:

---------------------------------------
                                        \
                                         \
                                          \
                                           \___________________
set a=1 and b=1

Installation: Put this file in the wtlib directory and type wtgen
trap.c then create a file in the current experiment called trap.wtp
that defines a,b,c, and d (as integers) so that trap.wtp typically
looks like this when np=32768:

1
1
14000
16384

Don't forget to set wtfile (or wtfile1) ='trap' and use wti to see
what it looks like! To use in f1 and f2 with different values you
can rename trap something like trap1 and effectively have two
different window functions using different .wtp files.

*/

wtcalc(wtpntr,npoints,a,b,c,d)
int npoints;
float *wtpntr,a,b,c,d;

{
	int i,ia,ib,ic,id;
        float nn,z;

        nn=(float)npoints;
	ia = (int)wtconst[0];
	ib = (int)wtconst[1];
	ic = (int)wtconst[2];
	id = (int)wtconst[3];
	a  = (float)ia;
	b  = (float)ib;
	c  = (float)ic;
	d  = (float)id;
/*
	printf("a = %12.3f\n",a);
	printf("b = %12.3f\n",b);
	printf("c = %12.3f\n",c);
	printf("d = %12.3f\n",d);
	printf("nn = %12.3f\n",nn);
*/
	if ((a<1) || (b<1) || (c<1) || (d<1))
	{
		printf("wtconsts must be greater than or equal to 1\n");
		abort();
	}
	if ((a>nn) || (b>nn) || (c>nn) || (d>nn))
	{
		printf("wtconsts must be less than fn\n");
		abort();
	}
	if ((a>b) || (b>c) || (c>d) || (a>c) || (a>d) || (b>d))
	{
		printf("wtconsts must be ordered a<b<c<d\n");
		abort();
	}

	for (i = 0; i < ia; i++)
		*wtpntr++ = 0;

	z=0;
	for (i = ia; i < ib; i++)
	{
		z=z+(1/(b-a));
		*wtpntr++ = z;
	}

	for (i = ib; i < ic; i++)
		*wtpntr++ = 1;

	z=1;
	for (i = ic; i < id; i++)
	{
		z=z-(1/(d-c));
		*wtpntr++ = z;
	}

}
