/*exsy2d.c - A sequence for EXSY experiments in solids.

               V. Zorin 09/14/10                                      */ 

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[16] = {0,2,0,2,0,2,0,2,1,3,1,3,1,3,1,3};           				// phX90_1
static int table2[32] = {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3};   	// phX90_2
static int table3[16] = {0,0,1,1,2,2,3,3,1,1,2,2,3,3,0,0};   					// phX90_3
static int table4[32] = {2,0,3,1,0,2,1,3,3,1,0,2,1,3,2,0,0,2,1,3,2,0,3,1,1,3,2,0,3,1,0,2};      // phRec

#define phX90_1 t1
#define phX90_2 t2
#define phX90_3 t3
#define phRec t4

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;
   double tXmix=getval("tXmix");

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + 3.0*getval("pwX90") + d2 +
                   getval("rd") + getval("ad") + at;       
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phX90_1,16,table1);
   settable(phX90_2,32,table2);
   settable(phX90_3,16,table3);
   settable(phRec,32,table4);
   
   if (phase1 == 2) tsadd(phX90_1,1,4);
   setreceiver(phRec);

// Begin Sequence

   txphase(phX90_1); decphase(zero);
   obspwrf(getval("aX90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// X Direct Polarization

   rgpulse(getval("pwX90"),phX90_1,0.0,0.0);
   _dseqon(dec);

// X Evolution

   delay(d2);

   txphase(phX90_2);
   _dseqoff(dec);
   if (getval("aHmix")>0.0) {
     decpwrf(getval("aHmix"));
     decon();
   }
   rgpulse(getval("pwX90"),phX90_2,0.0,0.0);
   delay(tXmix);
   if (getval("aHmix")>0.0)
     decoff();
   _dseqon(dec);
   txphase(phX90_3);
   rgpulse(getval("pwX90"),phX90_3,0.0,0.0);

// Begin Acquisition

   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}
