/*hetcortancp2d.c - A sequence to provide correlation between the
               X chemical-shift and 1H- chenmical shift obtained with
	       FSLG. Uses a nonselective ramped CP for mixing.

               D.Rice 12/15/05                                       */

#include "solidstandard.h"
#include <standard.h>

// Define Values for Phasetables

static int table1[4] = {1,1,3,3};           // phH90
static int table2[4] = {1,1,1,1};           // phHtilt
static int table3[4] = {0,0,0,0};           // phHfslg
static int table4[4] = {3,3,3,3};           // phHtilt2
static int table5[4] = {0,1,0,1};           // phXhx
static int table6[4] = {0,0,0,0};           // phHhx
static int table7[4] = {0,1,2,3};           // phRec

#define phH90 t1
#define phHtilt t2
#define phHfslg t3
#define phHtilt2 t4
#define phXhx t5
#define phHhx t6
#define phRec t7

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   MPSEQ fh = getfslg("fslgH",0,0.0,0.0,0,1);
   strncpy(fh.ch,"dec",3);
   putCmd("chHfslg='dec'\n");

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   DSEQ dec = getdseq("H");

// Dutycycle Protection 

   duty = 4.0e-6 + getval("pwH90") + d2 + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phHtilt,4,table2);
   settable(phHfslg,4,table3);
   settable(phHtilt2,4,table4);
   settable(phXhx,4,table5);
   settable(phHhx,4,table6);
   settable(phRec,4,table7);
   setreceiver(phRec);

if (phase1 == 2) tsadd(phHhx,3,4);

//  Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank();decunblank();_unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H Preparation and tilt

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decrgpulse(getval("pwHtilt"),phHtilt,0.0,0.0);   

// FSLG spinlock on H and reverse tilt

   _mpseqon(fh,phHfslg);
   delay(d2);
   _mpseqoff(fh);
   decpwrf(getval("aH90"));
   decrgpulse(getval("pwHtilt"),phHtilt2,0.0,0.0);

// Ramped H to X Cross Polarization

   decphase(phHhx);
   _cp_(hx,phHhx,phXhx);

// Begin Acquisition

   obsblank(); _blank34();
   _dseqon(dec);
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}
