/*onepulref.c - A sequence execute direct polarization, DP followed by a shaped
                refocusing pulse, with TPPM or SPINAL decoupling.

                D. Rice 05/05/11                                               */

#include "standard.h"
#include "solidstandard.h"
#include "pboxpulse.h"

// Define Values for Phasetables

static int table1[8] = {0,3,0,3,2,1,2,1};           // phX90    
static int table2[8] = {0,0,1,1,0,0,1,1};           // phXshp1
static int table3[8] = {0,1,2,3,2,3,0,1};           // phRec 

#define phX90 t1
#define phXshp1 t2
#define phRec t3

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   PBOXPULSE shp1 = getpboxpulse("shp1X",0,1); 

   DSEQ dec = getdseq("H");   
   DSEQ mix = getdseq("Hmix");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwX90") + getval("ad") + getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables


   settable(phX90,8,table1);
   settable(phXshp1,8,table2);
   settable(phRec,8,table3);
   setreceiver(phRec);

// Begin Sequence

   txphase(phX90); decphase(zero);
   obspower(tpwr);
   obspwrf(getval("aX90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// X Direct Polarization

   rgpulse(getval("pwX90"),phX90,0.0,0.0);

// Shaped Refocussing Pulse

   _dseqon(mix);
   delay(getval("tau1"));
   _pboxpulse(shp1,phXshp1);
   delay(getval("tau2"));
   _dseqoff(mix);

// Begin Acquisition
 
   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

