/*r2inv1ds.c - A sequence to do rotational resonance using a selective
               inversion with MPSEQ TPPM or SPINAL decoupling.

             Replaces r2inv1d and uses a PBOXPULE and
             replaces the DSEQ module with the MPSEQ module
             D. Rice for UIUC 23/07/08
*/

#include "standard.h"
#include "solidstandard.h"
#include "pboxpulse.h"

// Define Values for Phasetables

static int table1[4] = {0,2,0,2};           // phH90
static int table2[4] = {0,0,1,1};           // phXhx
static int table3[4] = {1,1,1,1};           // phHhx
static int table4[4] = {1,1,1,1};           // phHspnlm
static int table5[4] = {1,3,2,0};           // phX180
static int table6[4] = {1,3,2,0};           // phXshp1
static int table7[4] = {0,2,1,3};           // phX90
static int table8[4] = {1,1,1,1};           // phHspnl
static int table9[4] = {0,2,1,3};           // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHspnlm t4
#define phX180 t5
#define phXshp1 t6
#define phX90 t7
#define phHspnl t8
#define phRec t9

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   int decmode = getval("decmode");
   int decmodem = getval("decmodem");

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   PBOXPULSE shp1 = getpboxpulse("shp1X",0,1);
   strncpy(shp1.ch,"obs",3);
   putCmd("chHshp1 ='obs'\n");

   MPSEQ spnlm;
   if (decmodem>1) {
      spnlm = getspnl("spnlmH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

   MPSEQ spnl;
   if (decmode>1) {
      spnl = getspnl("spnlH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

// Define a Synchronized Mix Period

   double srate = getval("srate");
   double taur = 0.0;
   if (srate >= 500.0)
      taur = roundoff((1.0/srate), 0.0125e-6);
   else {
      printf("ABORT: Spin Rate (srate) must be greater than 500\n");
      psg_abort(1);
   }
   double mix = getval("mix");
   mix = roundoff(mix,taur);
   if (mix < getval("pwX180")) {
      mix = 0.0;
      shp1.t2 = shp1.t2 - getval("pwX180")/2.0;
      if (shp1.t2 < 0.0) shp1.t2 = 0.0;
   }
   else {
      mix = mix - getval("pwX180")/2.0;
      if (mix < 0.0) mix = 0.0; 
   }

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;
           
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHspnlm,4,table3);
   settable(phHhx,4,table4);
   settable(phX180,4,table5);
   settable(phXshp1,4,table6);
   settable(phX90,4,table7);
   settable(phHspnl,4,table8);
   settable(phRec,4,table9);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// Hard 180 and Selective Inversion Pulse

    if (decmodem>0){ decpwrf(getval("aHspnl")); decon(); if (decmodem>1){ _mpseqon(spnlm,phHspnlm);}}
    obspwrf(getval("aX180"));
    rgpulse(getval("pwX180"),phX180,0.0,0.0);
    txphase(phXshp1);
    obspwrf(getval("aXshp1"));
    obsunblank();
    _pboxpulse(shp1,phXshp1);

// Rotational Resonance Mixing

   txphase(phX90);
   obspwrf(getval("aX90"));
   if (decmodem>0){ decoff(); if (decmodem>1){ _mpseqoff(spnlm);}}
   delay(mix);
   if (decmodem>0){decpwrf(getval("aHspnl")); decon(); if (decmodem>1){ _mpseqon(spnlm,phHspnlm);}};

// Rotational Resonance Detection Pulse

   rgpulse(getval("pwX90"), phX90, 0.0, 0.0);
   if (decmodem>0){ decoff(); if (decmodem>1){ _mpseqoff(spnlm);}}

// Begin Acquisition

   if (decmode>0){ decpwrf(getval("aHspnl")); decon(); if (decmode>1){ _mpseqon(spnl,phHspnl);}}
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   if (decmode>0){ decoff(); if (decmode>1){ _mpseqoff(spnl);}}
   obsunblank(); decunblank(); _unblank34();
}

