/*redor2tancp.c - A sequence to do REDOR with a single pi pulse on X and
                  XY8 on Y with twp pulses per rotor period.

                  D. Rice 03/25/06                                     */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {1,1,3,3};           // phH90
static int table2[4] = {3,0,3,0};           // phXhx
static int table3[4] = {0,0,0,0};           // phHhx
static int table4[8] = {0,1,0,1,1,0,1,0};   // ph1Yxy8
static int table5[4] = {0,0,0,0};           // ph2Yxy8
static int table6[4] = {0,1,0,1};           // phX180
static int table7[4] = {2,3,0,1};           // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define ph1Yxy8 t4
#define ph2Yxy8 t5
#define phX180 t6
#define phRec t7

pulsesequence() {

//Define Variables and Objects and Get Parameter Values

   double duty;

   double aYxy8 = getval("aYxy8");  // Define the xy8XY object in the Sequence
   double pwYxy8 = getval("pwYxy8");
   double nYxy8 = getval("nYxy8");
   int cycles = (int) nYxy8/2.0;
   nYxy8 = 2.0*cycles;              // Define total cycles in pairs
   int counter = (int) (nYxy8 - 1.0);
   initval((nYxy8 - 1.0),v8);
   double onYxy8 = getval("onYxy8");
   double srate = getval("srate");

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec ",3);
   strncpy(hx.to,"obs ",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   DSEQ dec = getdseq("H");
   DSEQ mix = getdseq("Hmix");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
          nYxy8/srate + getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(ph1Yxy8,8,table4);
   settable(ph2Yxy8,4,table5);
   settable(phX180,4,table6);
   settable(phRec,4,table7);

   if (counter < 0) tsadd(phRec,2,4);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
   _cp_(hx,phHhx,phXhx);

// xy8Y Period One

  obspwrf(getval("aX180"));
  txphase(phX180);
  if (counter >= 0) {
      _dseqon(mix);
      delay(pwYxy8/2.0);
      dec2pwrf(aYxy8);
      sub(v1,v1,v1);                           
      if (counter >= 1) {
         if (counter > 1) loop(v8,v9);
	    getelem(ph1Yxy8,v1,v4);
	    incr(v1);
	    getelem(ph2Yxy8,ct,v2);
	    add(v4,v2,v2);
	    dec2phase(v2);
	    delay(0.5/srate - pwYxy8);
	    if (onYxy8 == 2)
               dec2rgpulse(pwYxy8,v2,0.0,0.0);
            else
               delay(pwYxy8);
	 if (counter > 1) endloop(v9);
      }

// X Refocussing Pulse

      delay(0.5/srate - pwYxy8/2.0 - getval("pwX180")/2.0);
      rgpulse(getval("pwX180"),phX180,0.0,0.0);
      delay(0.5/srate - pwYxy8/2.0 - getval("pwX180")/2.0);

// xy8Y Period Two

      dec2pwrf(aYxy8);
      if (counter >= 1) {
         if (counter > 1) loop(v8,v9);

	    if (onYxy8 == 2) 
               dec2rgpulse(pwYxy8,v2,0.0,0.0);
            else
               delay(pwYxy8);
            getelem(ph1Yxy8,v1,v4);
	    incr(v1);
	    getelem(ph2Yxy8,ct,v2);
	    add(v4,v2,v2);
	    dec2phase(v2);
	    delay(0.5/srate - pwYxy8);
	 if (counter > 1) endloop(v9);
      }
      delay(pwYxy8/2.0);
      _dseqoff(mix);
   }

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

