/*tancpxdec2.c - A sequence to form a constant, linear or tangent ramped CP
               with simultaneous dec and dec2 SPINAL or TPPM decoupling. 

             CEB 06/28/05 for VNMRJ2.1A-B for the NMR SYSTEM
             Edited  D. Rice 6/28/05
             Edited  D. Rice 10/12/05                                  
             INOVA Optimized D.Rice 10/28/08                          
             Add dec2 decoupling 03/12/09                              */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,2,0,2};           // phH90
static int table2[4] = {0,0,1,1};           // phXhx
static int table3[4] = {1,1,1,1};           // phHhx
static int table4[4] = {0,2,1,3};           // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phRec t4

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;
   
    CP hx = getcp("HX",0.0,0.0,0,1);
    strncpy(hx.fr,"dec",3);
    strncpy(hx.to,"obs",3);
    putCmd("frHX='dec'\n");
    putCmd("toHX='obs'\n");

    DSEQ dec = getdseq("H"); 
    DSEQ dec2 = getdseq("Y"); 

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(phRec,4,table4);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90); dec2phase(zero);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// Begin Acquisition

   _dseqon(dec);
   if (NUMch > 2) _dseqon(dec2);
   if (NUMch > 3) dec3blank();
   obsblank();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   if (NUMch > 2) _dseqoff(dec2);
   if (NUMch > 3) dec3unblank();
   obsunblank(); decunblank();
}

