/*trapdor1d.c - Trapdor on X with H modulation with SPINAL or 
                TPPM decoupling.

                Uses the standard channel identifiers X = obs,
                H = dec. Note, however, that this sequence would
                nevertheless most often be used for high-band
                observe. In this case aXxhtrap would be the high-band
                amplitude and aHxhtrap would be the low-band quadrupole
                nucleus.

             Edited  D. Rice 01/10/05                             */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,2,1,3};           // ph1Xxhtrap
static int table2[4] = {0,0,0,0};           // phHxhtrap
static int table3[4]=  {0,0,0,0};           // ph2Xxhtrap
static int table4[4] = {2,0,1,3};           // phRec

#define ph1Xxhtrap t1
#define phHxhtrap t2
#define ph2Xxhtrap t3
#define phRec t4

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pw1Xxhtrap") + getval("t1XHtrap") + getval("pw1XHtrap") +
                   getval("t2XHtrap") + getval("ad") + getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6 + getval("t2XHtrap"));
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(ph1Xxhtrap,4,table1);
   settable(phHxhtrap,4,table2);
   settable(ph2Xxhtrap,4,table3);
   settable(phRec,4,table4);
   setreceiver(phRec);

// Begin Sequence

   txphase(ph1Xxhtrap); decphase(phHxhtrap);
   obspwrf(getval("aXxhtrap")); decpwrf(getval("aHxhtrap"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// TRAPDOR on H with Y Modulation

   rgpulse(getval("pw1Xxhtrap"),ph1Xxhtrap,0.0,0.0);
   txphase(ph2Xxhtrap);
   obsunblank();
   decon();
   delay(getval("t1XHtrap"));
   decoff();
   rgpulse(getval("pw2Xxhtrap"),ph2Xxhtrap,0.0,0.0);
   obsunblank();
   delay(getval("t2XHtrap"));

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd")); 
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}
