/*twopul.c - A sequence to measure T1 by inversion recovery using direct
             polarization with TPPM and SPINAL decoupling throughout.

             D. Rice 3/14/06                                          */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,0,0,0};           // phX180
static int table2[4] = {0,2,1,3};           // phX90
static int table3[4] = {0,2,1,3};           // phRec

#define phX180 t1
#define phX90 t2
#define phRec t3

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwX180") + getval("pwX90") + getval("ad") + getval("rd") + at;
   duty = duty/(duty + d1 + d2 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phX180,4,table1);
   settable(phX90,4,table2);
   settable(phRec,4,table3);
   setreceiver(phRec);

// Begin Sequence

   txphase(phX180); decphase(zero);
   obspwrf(getval("aX180"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// X Inversion Pulse

   rgpulse(getval("pwX180"),phX180,0.0,0.0);
   txphase(phX90);
   obspwrf(getval("aX90"));
   delay(d2);

// X Direct Polarization

   rgpulse(getval("pwX90"),phX90,0.0,0.0);

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

