/*wpmlgxmx1d1.c - A sequence to perform PMLG with windowed aquisition
              and quadrature detection. Uses a Z-rotation supercycle and shapes in the loops.
	      CAUTION: shapes in the loop require VNMRJ 3.1 or higher
		       use wmplgxmx1d.c for older versions

              V.Zorin 08/10
		      11/06/10                                 */

#include "standard.h"
#include "solidstandard.h"


// Define Values for Phasetables

static int table1[4] = {2,0,3,1};           // phXprep
static int table2[4] = {0,0,0,0};           // phXwpmlg
static int table3[4] = {2,0,3,1};           // phRec

#define phXprep t1
#define phXwpmlg t2
#define phRec t3

pulsesequence() {

// Set the Maximum Dynamic Table and v-var Numbers

   settablenumber(10);
   setvvarnumber(30);

// Define Variables and Objects and Get Parameter Values

   double duty;

   double aXprep = getval("aXprep");
   double pwXprep = getval("pwXprep");
   double phvXprep = getval("phXprep");

   WMPSEQ wpmlg = getwpmlgxmx1("wpmlgX");
   strncpy(wpmlg.wvsh.mpseq.ch,"obs",3); 
   putCmd("chXwpmlg='obs'\n");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwXprep") + (np/sw)*(wpmlg.wvsh.mpseq.t/(wpmlg.tau + 2.0*wpmlg.wvsh.mpseq.t));
   duty = duty/(duty + d1 + np/sw + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phXprep,4,table1);
   settable(phXwpmlg,4,table2);
   settable(phRec,4,table3);
   setreceiver(phRec);

// Set the Small-Angle Step

   double obsstep = 360.0/(PSD*8192);
   obsstepsize(obsstep);
   int phfXprep = initphase(phvXprep, obsstep);
   int phXzero = initphase(0.0, obsstep);

// Begin Sequence

   xmtrphase(phfXprep); txphase(phXprep);
   obspwrf(aXprep);
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// Standard 90-degree prepX pulse for PMLGxmx"

   startacq(5.0e-6);
   rcvroff();
   delay(wpmlg.r1);
   rgpulse(pwXprep, phXprep, 0.0, 0.0);
   xmtrphase(phXzero);
   delay(wpmlg.r2);

// Apply WPMLG Cycles

   decblank(); _blank34();
   _wpmlg1(wpmlg, phXwpmlg);
   endacq();
   obsunblank(); decunblank(); _unblank34();
}
