/*xxctuc1sh2ds.c - Constant time uniform crosspeak COSY for
                   Aliphatic Correlation 

            Chen et. al. JACS (2006)
            D. Rice 7/9/08 
	    Modified by G. Comellas 12/06/09 to include 2H dec, 
	    phase cycle and soft-hard pair                                 */

#include "standard.h"
#include "solidstandard.h"
#include "pboxpulse.h"

// Define Pbox Shape Structure for Special Shape

static shape shXsp;

// Define Static Value to Hold d2 of First Increment

static double d2_init;

//Define Values for Phase Tables 

static int table1[4]  = {1,1,1,1};                           // phH90
static int table2[4]  = {0,2,0,2};                           // phXhx
static int table3[4]  = {0,0,0,0};                           // phHhx
static int table4[4]  = {0,0,0,0};                           // phHspnlm
static int table5[8]  = {0,2,1,3,2,0,3,1};                   // phXshp1
static int table15[8] = {0,2,1,3,2,0,3,1};                   // phX180_1

static int table6[4]  = {0,0,0,0};                           // phXshp2
static int table14[4] = {0,0,0,0};                           // phX180

static int table7[4]  = {1,3,1,3};                           // ph1X90
static int table8[4]  = {0,0,0,0};                           // ph2X90
static int table9[32] = {1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,
                         3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0};   // phXshp3
static int table16[32]= {1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,
                         3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0};   // phX180_2
static int table10[4] = {0,0,0,0};          // ph3X90
static int table11[4] = {2,2,2,2};          // ph4X90
static int table12[16]= {0,0,2,2,0,0,2,2,2,2,0,0,2,2,0,0};   // phHspnl
static int table13[16]= {0,0,2,2,0,0,2,2,2,2,0,0,2,2,0,0};   // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHspnlm t4
#define phXshp1  t5
#define phXshp2  t6
#define phX180 t14
#define ph1X90 t7
#define ph2X90 t8
#define phXshp3 t9
#define ph3X90 t10
#define ph4X90 t11
#define phHspnl t12
#define phX180_1 t15
#define phX180_2 t16
#define phRec t13

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   DSEQ dec = getdseq("H");
   DSEQ mix = getdseq("Hmix");
   
// Choose DEC2 Decoupling

   char ddec2[MAXSTR];
   getstr("ddec2",ddec2);

   DSEQ dec2;
   if (!strcmp(ddec2,"y")) dec2 = getdseq2("Y");

// Calculate the F1 Acquisition Time 

   if (d2_index == 0) d2_init = getval("d2");   
   double d2_ = (ni - 1)/sw1 + d2_init;
   putCmd("d2acqret = %f\n",roundoff(d2_,12.5e-9));
   putCmd("d2dwret = %f\n",roundoff(1.0/sw1,12.5e-9));
   
// Choose the Z-filter Flag   

   int ZF_flag = getval("ZF_flag"); 
   
// Set Homospoil Limit
   
   if (ZF_flag == 1) {    
      if (getval("hst") > (.01)) { 
         printf(" Homospoil tZF can't be longer than 10 ms!\n");
      	 psg_abort(1);
      }
   }
       
// Adjust Acquisition Timing for 4 Soft-pulses Modes

   int soft_flag = getval("soft_flag"); 
   
   double tmd22 = 0.0;
   double tau0 = 0.0; 
   double d22 = 0.0;     
   double tau1 = 0.0;
   double tau2 = 0.0; 
   
   if (soft_flag == 0) {
      tmd22 = getval("tconst") - getval("d2")/2.0 - getval("pwX90");
      if (tmd22 < 0.0) tmd22 = 0.0;
      tau0 = getval("tconst") - getval("pwX90");
      if (tau0 < 0.0) tau0 = 0.0;
      d22 = getval("d2")/2.0 - getval("pwX90");
      if (d22 < 0.0) d22 = 0.0;
      tau1 = getval("tconst") - getval("pwX90");
      if (tau1 < 0.0) tau1 = 0.0;
      tau2 = getval("tconst") - getval("pwX90")/2.0;
      if (tau2 < 0.0) tau2 = 0.0;
   }  
   
   if ((soft_flag == 1)||(soft_flag == 3)){

      tmd22 = getval("tconst") - getval("d2")/2.0;
      if (tmd22 < 0.0) tmd22 = 0.0;
      tau0 = getval("tconst");
      if (tau0 < 0.0) tau0 = 0.0;
      d22 = getval("d2")/2.0;
      if (d22 < 0.0) d22 = 0.0;
      tau1 = getval("tconst");
      if (tau1 < 0.0) tau1 = 0.0;
      tau2 = getval("tconst");
      if (tau2 < 0.0) tau2 = 0.0;  
   }
   
   if (soft_flag == 2) {
      tmd22 = getval("tconst") - getval("d2")/2.0;
      if (tmd22 < 0.0) tmd22 = 0.0;
      tau0 = getval("tconst");
      if (tau0 < 0.0) tau0 = 0.0;
      d22 = getval("d2")/2.0;
      if (d22 < 0.0) d22 = 0.0;
      tau1 = getval("tconst");
      if (tau1 < 0.0) tau1 = 0.0;
      tau2 = getval("tconst");
      if (tau2 < 0.0) tau2 = 0.0;
   }

// Create Shaped Pulses 

   PBOXPULSE shp1 = getpboxpulse("shp1X",0,1);
   strncpy(shp1.ch,"obs",3);
   putCmd("chXshp1 ='obs'\n");

   PBOXPULSE shp2 = getpboxpulse("shp2X",0,1);
   strncpy(shp2.ch,"obs",3);
   putCmd("chXshp2 ='obs'\n");

   PBOXPULSE shp3 = getpboxpulse("shp3X",0,1);
   strncpy(shp3.ch,"obs",3);
   putCmd("chXshp3 ='obs'\n");

// Create and Load the Special Shape shXshp

   char tshape[MAXSTR];
   getstr("Xshape",tshape);
   double pwXsp = getval("pwXsp");
   double ofXsp = getval("ofXsp");
   char   cmd[MAXSTR];
   int ixs = ix;
   if (getval("arraydim") < 1.5 || (ix==1) || isarry("ofXsp") || isarry("pwXsp")) {
      sprintf(shXsp.name, "%s_%ld", "spX", ixs);
      sprintf(cmd, "Pbox %s -w \"%s %.7f %.1f\" -0\n", shXsp.name,tshape,pwXsp,ofXsp); 
      system(cmd);
      shXsp = getRsh(shXsp.name);
   }

// Dutycycle Protection

   double duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Create Phasetables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(phHspnlm,4,table4);
   settable(phXshp1,8,table5);
   settable(phXshp2,16,table6);
   settable(phX180,16,table14);
   settable(ph1X90,4,table7);
   settable(ph2X90,4,table8);
   settable(phXshp3,32,table9);
   settable(ph3X90,4,table10);
   settable(ph4X90,4,table11);
   settable(phHspnl,16,table12);
   settable(phX180_1,8,table15);
   settable(phX180_2,32,table16);
   settable(phRec,16,table13);

   int id2_ = (int) (d2 * getval("sw1") + 0.1);
   if ((phase1 == 1) || (phase1 == 2)) {
     tsadd(phRec,2*id2_,4);
     tsadd(phXhx,2*id2_,4);
   }  
   if (phase1 == 2) tsadd(phXhx,3,4);
   setreceiver(phRec);
   
// Begin Sequence

// Set Status A for Optional Homospoil Pulse

   if(ZF_flag == 1) status(A);
   
// Begin Sequence
     
   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));  
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization 

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
   
// Blank DEC3, Start Optional DEC2 Decoupling or Blank DEC2

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqon2(dec2);
   }
   else {
      if (NUMch > 2) dec2blank();
   }
   if (NUMch > 3) dec3blank(); 
   
// Finish HX CP

   _cp_(hx,phHhx,phXhx);

// F1 Period
 
   _dseqon2(dec);
    
   if (soft_flag == 0) {
      txphase(phX180_1);
      obspwrf(getval("aX180"));
      delay(tmd22);
      rgpulse(getval("pwX180"),phX180_1,0.0,0.0);
      delay(tau0);
   }
   
   if (soft_flag == 1) {
      txphase(phXshp1);
      obspwrf(getval("aXshp1"));
      delay(tmd22);
      _pboxpulse(shp1,phXshp1);
      txphase(phXshp2);
      obspwrf(getval("aXshp2"));
      delay(tau0);
      _pboxpulse(shp2,phXshp2);
      txphase(phX180);
      obspwrf(getval("aX180"));
      rgpulse(getval("pwX180"),phX180,0.0,0.0);
   }

   if (soft_flag == 2) {
      txphase(phX180_1);
      obspwrf(getval("aX180"));
      delay(tmd22);
      rgpulse(getval("pwX180"),phX180_1,0.0,0.0);
      txphase(phX180);
      obspwrf(getval("aX180"));
      delay(tau0);
      rgpulse(getval("pwX180"),phX180,0.0,0.0);
      obspwrf(getval("aX180_off"));
      rgpulse(getval("pwX180_off"),0.0,0.0,0.0);
   }

   if (soft_flag==3) {
      txphase(phXshp1);
      obspower(getval("dbXsp"));     
      obspwrf(getval("aXsp"));
      delay(tmd22);
      delay(getval("tXsp"));
      shaped_pulse(shXsp.name,getval("pwXsp"),phXshp1,0.0,0.0);
      delay(getval("tXsp"));
      txphase(phXshp2);
      delay(tau0);
      delay(getval("tXsp"));
      shaped_pulse(shXsp.name,getval("pwXsp"),phXshp2,0.0,0.0);
      obspower(getval("tpwr"));
      delay(getval("tXsp"));
      txphase(phX180);
      obspwrf(getval("aX180"));
      rgpulse(getval("pwX180"),phX180,0.0,0.0);
   }

   txphase(ph1X90);
   obspwrf(getval("aX90"));
   delay(d22);
   rgpulse(getval("pwX90"),ph1X90,0.0,0.0);
   delay(getval("tdqf"));
   rgpulse(getval("pwX90"),ph2X90,0.0,0.0);

 // Refocus Period  

   if (soft_flag == 0) {
      txphase(phX180_2);
      obspwrf(getval("aX180"));
      delay(tau1);
      rgpulse(getval("pwX180"),phX180_2,0.0,0.0);
   } 
   
   if (soft_flag == 1) {
      txphase(phXshp3);
      obspwrf(getval("aXshp3"));
      obsunblank();
      delay(tau1);
      _pboxpulse(shp3,phXshp3);
   }
   
   if (soft_flag == 2) {
      txphase(phX180_2);
      obspwrf(getval("aX180"));
      delay(tau1);
      rgpulse(getval("pwX180"),phX180_2,0.0,0.0);
   } 
   
   if(soft_flag == 3) {
      txphase(phXshp3);
      obspower(getval("dbXsp"));     
      obspwrf(getval("aXsp"));
      obsunblank();
      delay(tau1);
      delay(getval("tXsp"));
      shaped_pulse(shXsp.name,getval("pwXsp"),phXshp3,0.0,0.0);
      obspower(getval("tpwr"));
      delay(getval("tXsp"));
   }
   txphase(ph3X90);
   obspwrf(getval("aX90"));
   delay(tau2);
   _dseqoff2(dec);

// Z-filter with Homospoil Delay and No Decoupling (1)
   
   if (ZF_flag == 1) {
      rgpulse(getval("pwX90"),ph3X90,0.0,0.0); 
      txphase(ph4X90);
      obsunblank();
      status(B);
      hsdelay(getval("hst"));
      status(A);
      delay(getval("hstconst"));
      _dseqon2(mix);
   }
   
// Z-filter with mixH Decoupling (0) and Optional Gradient Pulse (2)

   else {
      _dseqon2(mix);
      rgpulse(getval("pwX90"),ph3X90,0.0,0.0); 
      txphase(ph4X90);
      obsunblank();
   }

// Z-filter Time tZF

   if (ZF_flag == 0) delay(getval("tZF")); 
   
// Z-filter Time tZF + tZF2
   
   if (ZF_flag==2) {
      rgradient('z',getval("gzlvl1"));
      delay(getval("tZF2"));
      rgradient('z',0.0);
      delay(getval("tZF"));
   }
   rgpulse(getval("pwX90"),ph4X90,0.0,0.0);
   _dseqoff2(mix);

// Begin Acquisition DEC Decoupling 

   _dseqon2(dec);
   
// Begin Acquisition
      
   obsblank();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   
// Halt DEC Decoupling

   _dseqoff2(dec); 
   
// Halt Optional DEC2 Decoupling or Unblank DEC2, if Blanked

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqoff2(dec2);
   }
   else {
      if (NUMch > 2) dec2unblank();
   }      
   obsunblank(); decunblank(); _unblank34();
}

