/*xxctuc2ds.c - Constant time uniform crosspeak COSY

            Chen et. al. JACS (2006)
            D. Rice 7/9/08                               */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {1,1,1,1};           // phH90
static int table2[4] = {0,0,0,0};           // phXhx
static int table3[4] = {0,0,0,0};           // phHhx
static int table4[4] = {0,0,0,0};           // phHspnlm
static int table5[4] = {0,0,0,0};           // ph1X180
static int table6[4] = {1,1,1,1};           // ph1X90
static int table7[4] = {0,0,0,0};           // ph2X90
static int table8[4] = {1,1,1,1};           // ph2X180
static int table9[4] = {0,0,0,0};           // ph3X90
static int table10[4] = {1,2,1,2};          // ph4X90
static int table11[4] = {0,0,0,0};          // phHspnl
static int table12[4] = {0,0,0,0};          // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHspnlm t4
#define ph1X180  t5
#define ph1X90 t6
#define ph2X90 t7
#define ph2X180 t8
#define ph3X90 t9
#define ph4X90 t10
#define phHspnl t11
#define phRec t12

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   int decmode = getval("decmode");
   int decmodem = getval("decmodem");

   double d2m = getval("tconst") - getval("d2")/2.0 - getval("pwX180")/2.0;
   if (d2m < 0.0) d2m = 0.0;
   double d2p = getval("tconst") + getval("d2")/2.0 - getval("pwX180")/2.0 - getval("pwX90");
   if (d2p < 0.0) d2p = 0.0;
   double tau1 = getval("tconst") - getval("pwX180")/2.0 - getval("pwX90");
   if (tau1 < 0.0) tau1 = 0.0;
   double tau2 = getval("tconst") - getval("pwX180")/2.0 - getval("pwX90")/2.0;
   if (tau2 < 0.0) tau2 = 0.0;
   double tZF = getval("tconst") - getval("pwX90");

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   MPSEQ spnlm;
   if (decmodem>1) {
      spnlm = getspnl("spnlmH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

   MPSEQ spnl;
   if (decmode>1) {
      spnl = getspnl("spnlH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(phHspnlm,4,table4);
   settable(ph1X180,4,table5);
   settable(ph1X90,4,table6);
   settable(ph2X90,4,table7);
   settable(ph2X180,4,table8);
   settable(ph3X90,4,table9);
   settable(ph4X90,4,table10);
   settable(phHspnl,4,table11);
   settable(phRec,4,table12);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// F1 Period

   if (decmodem>0){ decpwrf(getval("aHspnlm")); decon(); if (decmodem>1){ _mpseqon(spnlm,phHspnlm);}}
   delay(d2m);
   txphase(ph1X180);
   obspwrf(getval("aX180"));
   rgpulse(getval("pwX180"),ph1X180,0.0,0.0);
   txphase(ph1X90);
   obspwrf(getval("aX90"));
   obsunblank();
   delay(d2p);
   rgpulse(getval("pwX90"),ph1X90,0.0,0.0);

// Refocus Period

   rgpulse(getval("pwX90"),ph2X90,0.0,0.0);
   txphase(ph2X180);
   obspwrf(getval("aX180"));
   obsunblank();
   delay(tau1);
   rgpulse(getval("pwX180"),ph2X180,0.0,0.0);
   txphase(ph3X90);
   obspwrf(getval("aX90"));
   obsunblank();
   delay(tau2);
   if (decmodem>0){ decoff(); if (decmodem>1){ _mpseqoff(spnlm);}}

// Zed-Filter

   if (decmode>0){ decpwrf(getval("aHspnl")); decon(); if (decmode>1){ _mpseqon(spnl,phHspnl);}}
   rgpulse(getval("pwX90"),ph3X90,0.0,0.0);
   txphase(ph3X90);
   obsunblank();
   delay(tZF);
   rgpulse(getval("pwX90"),ph4X90,0.0,0.0);

// Begin Acquisition

   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   obsunblank(); decunblank(); _unblank34();
}

