/*bhXH.c -  HX correlation with H detection using MISS (Multiple
            Intense Solvent Suppression), constant time with X
            decoupling.

                    D. Rice 7/3/04   AJN 3/29/10           
                    D.Rice (a-version) 5/25/10

                    Revised with new input from UIUC
                    D. Rice (b-version) 11/30/11

            This sequence is bassed on hYXH provided by Chad Rienstra, UIUC.
 
Changes: Remove decmode and decmodem - unused anyway
Changes: Add spinal2 with alp to replace spinal (X and H)
Question: use d2_index? But no change.
Changes: Homospoil to rgradient - add gzlvl1
Changes: Fixed phase for indirect X refocussing pulse "1" to "one"
Changes: Fixed phase for indirect Y refocussing pulse "0" to "zero"
Changes: Separate getvals for pwH90, pwX90 and pwY90
Changes: Place obsblank and obsunblank in the Hecho module.
Changes: Added gradient duty cycle calculation. 11/30/11
Changes: Replace spinal2 with getdseq2(). 11/30/11
Changes: Added new UIUC phase cycle 11/30/11
Changes: Added homospoil option in new sequence 11/30/11
Changes: Added Constant-time Decoupling. 11/30/11
Changes: Added Optional Y decoupling. 11/30/11
Changes: changed dec(H) to obs and dec2 (X) to dec for getdseq 11/30/11.
Changes: Adjusted the calculation of d2_ and d3_ 11/30/11
Changes: Fixed the word modules and variable duty 11/30/11
Changes: Fixed tRFmax in duty cycle (not tRF) 11/30/11
Changes: Added teturn times for rfdr, pxy and pxy2 11/30/11
changes: Add mixing sequences to the duty calculation 11/30/11
                                                                      */
#include "standard.h"
#include "solidstandard.h"

// Define Static Value to Hold d2 First Increment

static double d2_init;

// Define Values for Phasetables

static int table1[4] = {0,0,2,2};           // phH90
static int table2[8] = {0,0,0,0,2,2,2,2};   // phXhx
static int table3[2] = {1,1};               // phHhx
static int table5[2] = {3,3};               // ph1X90
static int table6[2] = {0,0};               // phHpxy
static int table7[2] = {1,3};               // ph2X90
static int table8[2] = {1,1};               // phHxh
static int table9[2] = {0,0};               // phXxh
static int table10[2] = {0,0};              // ph1H90
static int table11[4] = {0,2,1,3};          // phHrfdr
static int table12[2] = {2,2};              // ph2H90
static int table14[8] = {0,2,2,0,2,0,0,2};  // phRec
static int table15[2] = {0,0};              // phHecho - solid echo cycle

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define ph1X90 t5
#define phHpxy t6
#define ph2X90 t7
#define phHxh t8
#define phXxh t9
#define ph1H90 t10
#define phHrfdr t11
#define ph2H90 t12
#define phRec t14
#define phHecho t15

pulsesequence() {

// Define Variables and Modules and Get Parameter Values

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"obs",3);
   strncpy(hx.to,"dec",3);
   putCmd("frHX='obs'\n");
   putCmd("toHX='dec'\n");
   
   CP xh = getcp("XH",0.0,0.0,0,1);
   strncpy(xh.fr,"dec",3);
   strncpy(xh.to,"obs",3);
   putCmd("frXH='dec'\n");
   putCmd("toXH='obs'\n");

   MPSEQ pxy = getpxy("pxyH",0,0.0,0.0,0,1);
   strncpy(pxy.ch,"obs",3);
   putCmd("chHpxy='obs'\n");

   MPSEQ pxy2;
   if (hst > 0.0) {   
      pxy2 = getpxy("pxy2H",0,0.0,0.0,0,1);
      strncpy(pxy2.ch,"obs",3);
      putCmd("chHpxy2='obs'\n");
   }

   MPSEQ rfdr = getrfdrxy8("rfdrH",0,0.0,0.0,0,1);
   double tHrfdrret = rfdr.t;
   strncpy(rfdr.ch,"obs",3);
   putCmd("chHrfdr='obs'\n");
   putCmd("tHrfdrret = %f\n",tHrfdrret*1.0e6);

   DSEQ obs = getdseq2("H");
   DSEQ dec = getdseq2("X");
   
// Obtain the 90-degree Pulse Calibrations  
 
   double pwY90 = getval("pwY90");
   double pwX90 = getval("pwX90");
   double pwH90 = getval("pwH90"); 
   
// Calculate the H Spin-echo Times

   double t1Hechoinit = getval("tHecho")/2.0;
   double t2Hechoinit = getval("tHecho")/2.0;
   double t1Hecho  = t1Hechoinit - pwH90;
   if (t1Hecho < 0.0) t1Hecho = 0.0;
   double t2Hecho  = t2Hechoinit - pwH90 - getval("rd");
   if (t2Hecho < 0.0) t2Hecho = 0.0;
 
// Set the Gradient Mode (Homospoil or Gradient) and Times

   char HS[MAXSTR];  
   getstr("HS",HS);     

   double hst = getval("hst");
   double hstconst = getval("hstconst");
   double hstdelay = hstconst - hst;
   if (hstdelay < 0.0) hstdelay = 0.0;   
   
   double hst2 = getval("hst2");
   double hst2const = getval("hst2const");
   double hst2delay = hst2const - hst2;
   if (hst2delay < 0.0) hst2delay = 0.0;    

// Choose DEC2 Decoupling

   char ddec2[MAXSTR];
   getstr("ddec2",ddec2);

   DSEQ dec2;
   if (!strcmp(ddec2,"y")) dec2 = getdseq2("Y");   

// Calculate the F1 Acquisition Time 

   if (d2_index == 0) d2_init = getval("d2"); 

   double d2_ = (ni - 1)/sw1 + d2_init;
   putCmd("d2acqret = %f\n",roundoff(d2_,12.5e-9));
   putCmd("d2dwret = %f\n",roundoff(1.0/sw1,12.5e-9));

 // Calculate Constant-time Acquisition Window for F1
 
   double tconstd2 = getval("tconstd2"); 
   if (tconstd2 < (d2_+ pwX90)) tconstd2 = d2_ + pwX90;
   putCmd("tconstd2 = %f\n",roundoff(tconstd2,12.5e-9));
   
   char CT[MAXSTR];  
   getstr("CT",CT);
   
   double tmd2 = 0.0; 
   if (!strcmp(CT,"n")) {
      tmd2 = tmd2 + tconstd2 - getval("d2") - pwX90;
      if (tmd2 < 0.0) tmd2 = 0.0; 
   }
   
// Calculate Constant-time Decoupling tRFmax
   
   char ctd[MAXSTR];
   getstr("ctd",ctd);
   
   double tRF = 0.0;
   double tRFmax = getval("tRFmax");
   if (!strcmp(ctd,"y")) {
      if (tRFmax <= tconstd2) tRFmax = tconstd2;
      tRF = tRFmax - tconstd2; 
      putCmd("tRFmax = %f\n",tRFmax*1.0e6);  
   } 

// Set tRFmax = 0.0 for No Constant-time Decoupling

   else { 
      putCmd("tRFmax = 0.0\n");
   }

// Dutycycle Protection

   double duty = 4.0e-6 + 3.0*pwH90 + getval("tHX") + getval("tXH") + 
                 hst + hstdelay + hst2 + hst2delay + tHrfdrret + t1Hecho + 
                 t2Hecho + getval("ad") + getval("rd") + at;
                 
   if (!strcmp(ctd,"y")) duty = duty + tRFmax; 
   else duty = duty + tconstd2;
                  
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,8,table2);
   settable(phHhx,2,table3);
   settable(ph1X90,2,table5);
   settable(phHpxy,2,table6);
   settable(ph2X90,2,table7);
   settable(phHxh,2,table8);
   settable(phXxh,2,table9);
   settable(ph1H90,2,table10);
   settable(phHrfdr,4,table11);
   settable(ph2H90,2,table12);
   settable(phRec,8,table14);
   settable(phHecho,2,table15);

   int id2_ = (int) (d2 * getval("sw1") + 0.1);
   if ((phase1 == 1) || (phase1 == 2)) {
     tsadd(phRec,2*id2_,4);  /* invert the phases of the CP and */
     tsadd(phXhx,2*id2_,4);  /* the receiver for FAD to displace the axial peaks */
   }  
   if (phase1 == 2) {tsadd(ph1X90,3,4);}  /* hypercomplex*/

   setreceiver(phRec);

// Begin Sequence

   txphase(phH90); decphase(phXhx);
   obspwrf(getval("aH90")); decpwrf(getval("aXhx"));
   obsunblank(); decunblank(); _unblank34();

// Initial Homospoil Pulse

   if (!strcmp(HS,"z")) {
      rgradient('z',getval("gzlvl1"));
      delay(hst);
      rgradient('z',0.0);
      delay(hstdelay);
      printf("Executing Zed Gradient Homospoil\n");
   }
   else if (!strcmp(HS,"hs")) {
      status(B);
      hsdelay(hst);
      status(A);
      delay(hstdelay);
      printf("Executing hsdelay Homospoil\n");   
   }	  
   else {
      delay(hst);
      delay(hstdelay); 
      printf("Executing No Homospoil\n");  
   }
   	     	   
// Recycle Delay

   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   rgpulse(pwH90,phH90,0.0,0.0);
   _cp_(hx,phHhx,phXhx);
   decphase(ph1X90);
   decpwrf(getval("aX90"));

// F1 Indirect Period for X with Constant-time Option

   _dseqon2(dec);  
   dec2pwrf(getval("aY90"));
   if (!strcmp(CT,"n")) {
      if (d2 > 0.0) {
         if (d2 > 2.0*pwY90) {
            delay(0.5*d2 - pwY90);
            dec2rgpulse(2.0*pwY90,zero,0.0,0.0); 
            dec2unblank();
            delay(0.5*d2 - pwY90);
         }
      }
      else {
         delay(d2);
      }   
      decrgpulse(pwX90,ph1X90,0.0,0.0);
      decphase(ph2X90);
      delay(tmd2);
   }
   if (!strcmp(CT,"y")) {
      delay((tconstd2 + d2)/2.0);
      decrgpulse(2.0*pwX90,one,0.0,0.0);
      delay((tconstd2 - d2)/2.0);
      decrgpulse(pwX90,ph1X90,0.0,0.0);
      decphase(ph1X90);
   }
   _dseqoff2(dec);
   txphase(phHxh);

// Second Homospoil Delay with H Saturation Pulses

   if (!strcmp(HS,"z")) {
      rgradient('z',getval("gzlvl1"));
      _mpseqon(pxy,phHpxy);
      delay(hst);
      _mpseqoff(pxy);
      rgradient('z',0.0);
      delay(hstdelay);
      printf("Executing pxy2 Saturation Pulses with Zed Gradient\n");
   }
   else if (!strcmp(HS,"hs")) {
      status(B);
      hsdelay(hst);
      status(A);
      obspwrf(getval("aHpxy"));  
      delay(hstdelay);
      printf("Executing 2nd hsdelay Homospoil\n");
   }	  
   else {
      hsdelay(hst);  
      delay(hstdelay);   
      printf("Executing No 2nd Homospoil\n");  
   }
   
// More H Saturation Pulses and a Delay

   if (hst > 0.0) {
      _mpseqon(pxy2,phHpxy);
      delay(hst);
      _mpseqoff(pxy2);
   }
   txphase(phHxh); decphase(ph2X90);
   delay(hst2delay); 

// X to H Cross Polarization

   obspwrf(getval("aH90"));
   obsunblank(); xmtron();
   decrgpulse(pwX90,ph2X90,0.0,0.0);
   xmtroff();
   decphase(phXxh);
   _cp_(xh,phXxh,phHxh);

// XY8 Mixing
  
   if (getval("qHrfdr")>0)
   {
      obspwrf(getval("aH90"));
      rgpulse(pwH90,ph1H90,0.0,0.0);
      _mpseq(rfdr,phHrfdr);
      obspwrf(getval("aH90"));
      rgpulse(pwH90,ph2H90,0.0,0.0);
   }

// Begin X Decoupling

   if (!strcmp(HS,"hs")) status(C);
   _dseqon2(dec);
   obsblank(); _blank34();

// Blank DEC3, Start Optional DEC2 Decoupling or Blank DEC2

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqon2(dec2);
   }
   else {
      if (NUMch > 2) dec2blank();
   }
   if (NUMch > 3) dec3blank();


// H Hahn Echo

   if (t1Hecho > 0.0) {
      txphase(phHecho);
      obspwrf(getval("aH90"));
      obsunblank();
      delay(t1Hecho);
      rgpulse(2.0*pwH90,phHecho,0.0,0.0);
      obsunblank();
      delay(t2Hecho);
      obsblank();
   }

// Begin H Acquisition
 
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   
// Halt X Decoupling on DEC  

   _dseqoff2(dec);
   
// Halt Optional Y DEC2 Decoupling or Unblank DEC2, if Blanked

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqoff2(dec2);
   }
   else {
      if (NUMch > 2) dec2unblank();
   }
   
 // Make OBS (H) Constant-time with RF Following Acquisition

   decphase(zero);
   _dseqon2(obs); _dseqoff2(obs); // Set the decoupler amplitude
   if (!strcmp(ctd,"y")) {
      decon(); 
      delay(tRF);
      decoff();
   }  
   obsunblank(); decunblank(); _unblank34();
}
