/*hxr18ct2ds.c -   A sequence to do constant time HX correlation using
                   Transverse MREV5 on H with MPSEQ SPINAL and TPPM Decoupling.

                  D. Rice 6/25/08 with MPSEQ SPINAl decoupling for UIUC */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,2,0,2};           // phH90
static int table2[4] = {0,0,1,1};           // phXhx
static int table3[4] = {0,0,0,0};           // phHhx
static int table4[4] = {0,0,0,0};           // phHspnlm
static int table5[4] = {0,0,0,0};           // phHrtm5
static int table6[4] = {0,0,0,0};           // phX180
static int table7[4] = {0,0,0,0};           // phHspnl
static int table8[4] = {0,2,1,3};           // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHspnlm t4
#define phHtm5 t5
#define phX180 t6
#define phHspnl t7
#define phRec t8

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty; 

   int decmode = getval("decmode");
   int decmodem = getval("decmodem");

   double tmd2 = getval("tconst")/2.0 - getval("d2") - getval("pwX180")/2.0;
   if (tmd2 < 0.0) tmd2 = 0.0;
   double tau = getval("tconst")/2.0 - getval("pwX180")/2.0;
   if (tau < 0.0) tau = 0.0;

   CP hx = getcp("HX",0.0,0.0,0,1); 
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   MPSEQ tm5 = gettmrev5("tm5H",0,0.0,0.0,0,1);
   strncpy(tm5.ch,"dec",3);
   putCmd("chHtm5 ='dec'\n");

   MPSEQ spnlm;
   if (decmodem>1) {
      spnlm = getspnl("spnlmH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

   MPSEQ spnl;
   if (decmode>1) {
      spnl = getspnl("spnlH",0,0.0,0.0,0,1);
      strncpy(spnl.ch,"dec",3);
      putCmd("chHspnl ='dec'\n");
   }

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(phHspnlm,4,table4);
   settable(phHtm5,4,table5);
   settable(phX180,4,table6);
   settable(phHspnl,4,table7);
   settable(phRec,4,table8);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// Begin TMREV Decoupling

   obspwrf(getval("aX180"));
   _mpseqon(tm5,phHtm5);
   delay(d2);
   _mpseqoff(tm5);

// Continue Constant-Time Refocussing

   if (decmode>0){ decpwrf(getval("aHspnlm"));decon(); if (decmode>1){ _mpseqon(spnlm,phHspnlm);}}
   delay(tmd2);
   rgpulse(getval("pwX180"),phX180,0.0,0.0);
   delay(tau);
   if (decmode>0){ decon(); if (decmode>1){ _mpseqoff(spnlm);}}

// Begin Acquisition

   if (decmode>0){ decpwrf(getval("aHspnl")); decon(); if (decmode>1){ _mpseqon(spnl,phHspnl);}}
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   if (decmode>0){ decoff(); if (decmode>1){ _mpseqoff(spnl);}}
   obsunblank(); decunblank(); _unblank34();
}
