/*satrec1d.c - A sequence to measure T1 by saturation recovery using direct
             polarization with TPPM and SPINAL decoupling during acquisition.

	     V. Zorin	04/28/09                                           */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,0,0,0};           // phXsat
static int table2[4] = {0,2,1,3};           // phX90
static int table3[4] = {0,2,1,3};           // phRec

#define phXsat t1
#define phX90 t2
#define phRec t3

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   MPSEQ sat = getsat("satX",0.0,0.0,0,1);
   strncpy(sat.ch,"obs",3);
   putCmd("chXsat='obs'\n"); 

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = getval("qXsat")*getval("pwXsat") + getval("pwX90") + 
           getval("ad") + getval("rd") + at;
   duty = duty/(duty + d1 + d2 + getval("qXsat")*getval("tXsat") + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phXsat,4,table1);
   settable(phX90,4,table2);
   settable(phRec,4,table3);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXsat); decphase(zero);
   obspwrf(getval("aXsat"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// X saturation pulses

   _mpseq(sat,phXsat);
   txphase(phX90);
   obspwrf(getval("aX90"));
   delay(d2);

// X Direct Polarization

   rgpulse(getval("pwX90"),phX90,0.0,0.0);

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

