/*tancp1dfprfdr.c  Preparation of X with CP,  finite-pulse XY4 RFDR
                   mixing with SPINAL or TPPM decoupling

      Y. Ishii, J. Chem. Phys, 114,8473 (2007)

                   D. Rice 01/15/08                                  */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {1,3,1,3};           // phH90
static int table2[4] = {0,0,0,0};           // phHhx
static int table3[8] = {0,0,1,1,2,2,3,3};   // phXhx
static int table4[4] = {0,0,0,0};           // phXmix
static int table5[8] = {0,2,1,3,2,0,3,1};   // phRec

#define phH90 t1
#define phHhx t2
#define phXhx t3
#define phXmix t4
#define phRec t5

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   MPSEQ fp = getfprfdr("fprfdrX",0,0.0,0.0,0,1);
   strncpy(fp.ch,"obs",3);
   putCmd("chXfprfdr='obs'\n");

   DSEQ dec = getdseq("H");
   DSEQ mix = getdseq("Hmix");

// Round tXmix to the element length, 12*pwXfprfdr

   double tXmix = getval("tXmix");
   tXmix = roundoff(tXmix,12.0*getval("pwXfprfdr"));
   putCmd("tXmix = 12.0*pwXfprfdr");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + d2 + tXmix +
   + getval("ad") + getval("rd") + at;
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
  }

// Create Phasetables

   settable(phH90,4,table1);
   settable(phHhx,4,table2);
   settable(phXhx,8,table3);
   settable(phXmix,4,table4);
   settable(phRec,8,table5);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// Finite-Pulse RFDR Mixing

   _dseqon(mix);
   _mpseqon(fp,phXmix);
   delay(tXmix);
   _mpseqoff(fp);
   _dseqoff(mix);

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

