

// =============================
// Structure for DUTY
// =============================

typedef struct {
   double duty;         // percentage duty cycle (%)
   double dutyon;       // total possible time on
   double dutyoff;      // total timeoff
   int    c1;           // conditional for time off (1) 
   double t1;           // time off for conditional (1)
   int    c2;           // conditional for time off (2)
   double t2;           // time off for conditional (2)
   int    c3;           // conditional for time off (3)
   double t3;           // time off for conditional (3)
   int    c4;           // conditional for time off (4)
   double t4;           // time off for conditional (4)
   int    c5;           // conditional for time off (5)
   double t5;           // time off for conditional (5)
   int    c6;           // conditional for time off (6)
   double t6;           // time off for conditional (6)
   int    c7;           // conditional for time off (7)
   double t7;           // time off for conditional (7)
   int    c8;           // conditional for time off (8)
   double t8;           // time off for conditional (8)
} DUTY;

DUTY init_dutycycle()
{

   DUTY d; 
     
   d.c1 = 0;
   d.c2 = 0;
   d.c3 = 0;
   d.c4 = 0;
   d.c5 = 0;
   d.c6 = 0;
   d.c7 = 0;
   d.c8 = 0;
     
   d.t1 = 0.0;
   d.t2 = 0.0;
   d.t3 = 0.0;
   d.t4 = 0.0;
   d.t5 = 0.0;
   d.t6 = 0.0;
   d.t7 = 0.0;
   d.t8 = 0.0;

   d.duty = 105.0;
   d.dutyon = 0.0;
   d.dutyoff = 0.0;
   return d;
}

DUTY update_dutycycle(DUTY d)
{

   d.duty = d.dutyon + d.t1 + d.t2 + d.t3 + d.t4 + d.t5 + d.t6 + d.t7 + d.t8;
   d.dutyon = d.duty;
   if ((d.duty + d.dutyoff) == 0.0) {
      printf("Warning: Total time Is 0.0, Exiting update_dutycycle()\n");
      return d;
   }

   if (d.c1 > 0) d.dutyon = d.dutyon - d.t1;
   if (d.c2 > 0) d.dutyon = d.dutyon - d.t2;
   if (d.c3 > 0) d.dutyon = d.dutyon - d.t3;
   if (d.c4 > 0) d.dutyon = d.dutyon - d.t4;
   if (d.c5 > 0) d.dutyon = d.dutyon - d.t5;
   if (d.c6 > 0) d.dutyon = d.dutyon - d.t6;
   if (d.c7 > 0) d.dutyon = d.dutyon - d.t7;
   if (d.c8 > 0) d.dutyon = d.dutyon - d.t8;
   d.duty = 100.0*d.dutyon/(d.duty + d.dutyoff);
   return d; 
}

double abort_dutycycle(DUTY d, double percent)
{
   printf("Duty Cycle is %.1f%%\n", d.duty); 
   if (d.duty > 100.0) {
      abort_message("Abort: The duty cycle has not been determined\n");
   }
   if (d.duty > percent) {
      abort_message("Abort: The duty cycle of %.1f%% is greater than %.1f%%.\n", d.duty, percent);
   }
   return d.duty; 
}


