/*ahXH.c -  HX correlation with H detection using MISS (Multiple
            Intense Solvent Suppression), constant time with X
            decoupling.

                    D. Rice 7/3/04   AJN 3/29/10                 
                    D.Rice (a-version) 5/25/10     

Changes: Remove decmode and decmodem - unused anyway 
Changes: Add spinal2 with alp to replace spinal (X and H)
Question: use d2_index? But no change.
Changes: Homospoil to rgradient - add gzlvl1      
Changes: Fixed phase for indirect X refocussing pulse "1" to "one"
Changes: Fixed phase for indirect Y refocussing pulse "0" to "zero"
Changes: Separate getvals for pwH90, pwX90 and pwY90
Changes: Place obsblank and obsunblank in the Hecho module. 
                                                               */
#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[2] = {0,0};           // phH90
static int table2[2] = {0,0};           // phXhx
static int table3[2] = {1,1};           // phHhx
static int table5[2] = {3,3};           // ph1X90
static int table6[2] = {0,0};           // phHpxy
static int table7[2] = {1,3};           // ph2X90
static int table8[2] = {1,1};           // phHxh
static int table9[2] = {0,0};           // phXxh
static int table10[2] = {0,0};          // ph1H90
static int table11[4] = {0,2,1,3};      // phHrfdr
static int table12[2] = {2,2};          // ph2H90
static int table14[2] = {0,2};          // phRec
static int table15[2] = {0,0};          // phHecho - solid echo cycle

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define ph1X90 t5
#define phHpxy t6
#define ph2X90 t7
#define phHxh t8
#define phXxh t9
#define ph1H90 t10
#define phHrfdr t11
#define ph2H90 t12
#define phRec t14
#define phHecho t15

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   double tmd2 = getval("tconst") - getval("d2") - getval("pwX90");
   if (tmd2 < 0.0) tmd2 = 0.0; 
 
   char CT[MAXSTR];  
   getstr("CT",CT);   

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"obs",3);
   strncpy(hx.to,"dec",3);
   putCmd("frHX='obs'\n");
   putCmd("toHX='dec'\n");

   MPSEQ pxy = getpxy("pxyH",0,0.0,0.0,0,1);
   strncpy(pxy.ch,"obs",3);
   putCmd("chHpxy='obs'\n");

   MPSEQ rfdr = getrfdrxy8("rfdrH",0,0.0,0.0,0,1);
   strncpy(rfdr.ch,"obs",3);
   putCmd("chHrfdr='obs'\n");

   CP xh = getcp("XH",0.0,0.0,0,1);
   strncpy(xh.fr,"dec",3);
   strncpy(xh.to,"obs",3);
   putCmd("frXH='dec'\n");
   putCmd("toXH='obs'\n");

   DSEQ dec = getdseq("H");	// For t1 X evolution
   DSEQ dec2 = getdseq("X");	// For acq H evolution

   double t1Hechoinit = getval("tHecho")/2.0;
   double t2Hechoinit = getval("tHecho")/2.0;
   double t1Hecho  = t1Hechoinit - getval("pwH90");
   if (t1Hecho < 0.0) t1Hecho = 0.0;
   double t2Hecho  = t2Hechoinit - getval("pwH90") - getval("rd");
   if (t2Hecho < 0.0) t2Hecho = 0.0;

   double hst = getval("hst");
   double pwY90 = getval("pwY90");
   double pwX90 = getval("pwX90");
   double pwH90 = getval("pwH90"); 

// Dutycycle Protection

   duty = 4.0e-6 + 3.0*getval("pwH90") + getval("tHX") + getval("tconst") +
                   getval("tXH") + t1Hecho + t2Hecho + getval("ad") + 
                   getval("rd") + at;
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,2,table1);
   settable(phXhx,2,table2);
   settable(phHhx,2,table3);
   settable(ph1X90,2,table5);
   settable(phHpxy,2,table6);
   settable(ph2X90,2,table7);
   settable(phHxh,2,table8);
   settable(phXxh,2,table9);
   settable(ph1H90,2,table10);
   settable(phHrfdr,4,table11);
   settable(ph2H90,2,table12);
   settable(phRec,2,table14);
   settable(phHecho,2,table15);

   int id2_ = (int) (d2 * getval("sw1") + 0.1);
   if ((phase1 == 1) || (phase1 == 2)) {
     tsadd(phRec,2*id2_,4);  /* invert the phases of the CP and */
     tsadd(phXhx,2*id2_,4);  /* the receiver for FAD to displace the axial peaks */
   }  
   if (phase1 == 2) {tsadd(ph1X90,3,4);}  /* hypercomplex*/

   setreceiver(phRec);

// Begin Sequence

   txphase(phH90); decphase(phXhx);
   obspwrf(getval("aH90")); decpwrf(getval("aXhx"));
   obsunblank(); decunblank(); _unblank34();

// Initial Homospoil Pulse

   rgradient('z',getval("gzlvl1"));
   delay(getval("hst"));
   rgradient('z',0.0);

// Recycle Delay

   delay(d1 - hst);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   rgpulse(getval("pwH90"),phH90,0.0,0.0);
   txphase(phHhx);
   _cp_(hx,phHhx,phXhx);
   decphase(ph1X90);
   decpwrf(getval("aX90"));

// X F1 Period with H XiX Decoupling and Constant Time N Evolution

   _dseqon(dec);  
   dec2pwrf(getval("aY90"));
   if (!strcmp(CT,"n")) {
      if (d2 > 0.0) {
         if (d2 > 2.0*pwY90) {
            delay(0.5*d2 - pwY90);
            dec2rgpulse(2.0*pwY90,zero,0.0,0.0); // What is the "0" phase argument? 
            dec2unblank();
            delay(0.5*d2 - pwY90);
         }
      }
      else {
         delay(d2);
      }   
      decrgpulse(pwX90,ph1X90,0.0,0.0);
      decphase(ph2X90);
      decunblank();
      delay(tmd2);
   }
   if (!strcmp(CT,"y")) {
      if (getval("tconst") < ni/sw1) {
         printf("tconst < tmd2 evol!! abort.\nMay consider setting ni=0.");
         psg_abort(1);
      }
      if (getval("tconst") < d2) {
         printf("tconst < d2 evol!! abort.\n");
         psg_abort(1);
      }
      delay((getval("tconst") + d2)/2.0);
      decrgpulse(2.0*pwX90,one,0.0,0.0);            // What is the "1" phase argument? 
      delay((getval("tconst") - d2)/2.0);
      decrgpulse(pwX90,ph1X90,0.0,0.0);
      decphase(ph1X90);
   }
   _dseqoff(dec);
   txphase(phHxh);
   obspwrf(getval("aHpxy"));

// Second Homospoil Delay

   rgradient('z',getval("gzlvl1"));
   delay(getval("hst"));
   rgradient('z',0.0);
   delay(getval("hstconst"));

// Saturation Pulses

   _mpseq(pxy,phHpxy);
   txphase(phHxh);

// X to H Cross Polarization

   obspwrf(getval("aH90"));
   obsunblank(); xmtron();
   decrgpulse(pwX90,ph2X90,0.0,0.0);
   xmtroff();
   decphase(phXxh);
   _cp_(xh,phXxh,phHxh);

// XY8 Mixing
  
   if (getval("qHrfdr")>0)
   {
      obspwrf(getval("aH90"));
      rgpulse(getval("pwH90"),ph1H90,0.0,0.0);
      _mpseq(rfdr,phHrfdr);
      obspwrf(getval("aH90"));
      rgpulse(getval("pwH90"),ph2H90,0.0,0.0);
   }

// Begin X Decoupling

   status(C);
   _dseqon(dec2);
   obsblank(); _blank34();

// H Hahn Echo

   if (t1Hecho > 0.0) {
      txphase(phHecho);
      obspwrf(getval("aH90"));
      obsunblank();
      delay(t1Hecho);
      rgpulse(2.0*pwH90,phHecho,0.0,0.0);
      obsunblank();
      delay(t2Hecho);
      obsblank(); 
   }

// Begin H Acquisition
 
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec2);
   obsunblank(); decunblank(); _unblank34();
}
