/*ahYXH.c - YXH correlation with H detection using MISS,
            (Multiple Intense Solvent Suppression), constant time 
            with X decoupling.

                    HY cp, t1 Y evolution H dec
		    YX cp, t2 X evolution H dec
		    XH cp, potential HH rfdr mixing
		    H acq with X dec. 		    
		    no Y-Y dream mixing yet but will add

                    from hXH.c      AJN 03/29/10    
		    based on hYXH.c DHZ 02/07 for inova            
                    D. Rice (a-version)  05/27/10     
      
Changes: Remove decmode - unused anyway.                                      
Changes: Add spinal2 with alp to replace spinal (X and H)
Question: use d2_index? But no change.
Changes: Homospoil to rgradient - add gzlvl1 
Changes: Fixed phase for indirect X refocussing pulse "1" to "one"
Changes: Fixed phase for indirect Y refocussing pulse "0" to "zero"
Changes: Separate getvals for pwH90, pwX90 and pwY90
Changes: Remove status statements.
Changes: Place obsblank and obsunblank in the Hecho module. 
     
                                                           */
#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = 	{0,0,2,2};      // phH90
static int table2[2] = 	{1,1};          // phHhy
static int table3[2] = 	{0,0};          // phYhy
static int table4[2] = 	{3,3};          // ph1Y90 store 
static int table17[2] = {1,1};          // ph2Y90 recover
static int table5[2] = 	{0,0};          // phYyx
static int table6[2] = 	{0,0};          // phXyx
static int table7[2] = 	{1,1};          // ph1X90 store
static int table8[2] = 	{1,3};          // ph2X90 recover
static int table9[2] = 	{0,0};          // phXxh
static int table10[2] = {1,1};          // phHxh
static int table11[2] = {0,0};          // ph1H90
static int table12[2] = {2,2};          // ph2H90

static int table13[4] = {0,2,2,0};      // phRec
static int table14[4] = {0,2,1,3};      // phHrfdr - H-H mixing
static int table15[8] = {0,0};          // phHecho - solid echo cycle
static int table16[2] = {0,1};          // phHpxy - H presat pulses

#define phH90 t1
#define phHhy t2
#define phYhy t3
#define ph1Y90 t4
#define ph2Y90 t17
#define phYyx t5
#define phXyx t6
#define ph1X90 t7
#define ph2X90 t8
#define phXxh t9
#define phHxh t10
#define ph1H90 t11
#define ph2H90 t12
#define phRec t13
#define phHrfdr t14
#define phHecho t15
#define phHpxy  t16

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double d2_ = getval("d2max") - getval("d2") - getval("pwX90");
   double d3_ = getval("d3max") - getval("d3") - getval("pwY90");
   if (d2_ < 0.0) d2_ = 0.0;
   if (d3_ < 0.0) d3_ = 0.0;

   CP hy = getcp("HY",0.0,0.0,0,1);
   strncpy(hy.fr,"obs",3);
   strncpy(hy.to,"dec2",3);
   putCmd("frHY='obs'\n");
   putCmd("toHY='dec2'\n");

   CP yx = getcp("YX",0.0,0.0,0,1);
   strncpy(yx.fr,"dec2",3);
   strncpy(yx.to,"dec",3);
   putCmd("frYX='dec2'\n");
   putCmd("toYX='dec'\n");

   CP xh = getcp("XH",0.0,0.0,0,1);
   strncpy(xh.fr,"dec",3);
   strncpy(xh.to,"obs",3);
   putCmd("frXH='dec'\n");
   putCmd("toXH='obs'\n");

   MPSEQ pxy = getpxy("pxyH",0,0.0,0.0,0,1);
   strncpy(pxy.ch,"obs",3);
   putCmd("chHpxy='obs'\n");

   MPSEQ rfdr = getrfdrxy8("rfdrH",0,0.0,0.0,0,1);
   strncpy(rfdr.ch,"obs",3);
   putCmd("chHrfdr='obs'\n");

   DSEQ dec = getdseq("H");
   DSEQ dec2 = getdseq("X");

   double t1Hechoinit = getval("tHecho")/2;
   double t2Hechoinit = getval("tHecho")/2;
   double t1Hecho  = t1Hechoinit - getval("pwH90");
   if (t1Hecho < 0.0) t1Hecho = 0.0;
   double t2Hecho  = t2Hechoinit - getval("pwH90") - getval("rd");
   if (t2Hecho < 0.0) t2Hecho = 0.0;

   double hst = getval("hst");
   double pwY90 = getval("pwY90");
   double pwX90 = getval("pwX90");
   double pwH90 = getval("pwH90"); 

// Copy Current Parameters to Processed

   putCmd("groupcopy('current','processed','acquisition')");

// Dutycycle Protection

   double duty = 4.0e-6 + 3.0* getval("pwH90") + getval("tHX") + 
                   getval("tXH") + t1Hecho + t2Hecho + getval("ad") +
                   getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phHhy,2,table2);
   settable(phYhy,2,table3);
   settable(ph1Y90,2,table4);
   settable(ph2Y90,2,table17);
   settable(phYyx,2,table5);
   settable(phXyx,2,table6);
   settable(ph1X90,2,table7);
   settable(ph2X90,2,table8);
   settable(phXxh,2,table9);
   settable(phHxh,2,table10);
   settable(ph1H90,2,table11);
   settable(ph2H90,2,table12);
   settable(phRec,4,table13);   
   settable(phHrfdr,4,table14);
   settable(phHecho,2,table15);
   settable(phHpxy,2,table16);

   int id2_ = (int) (d2 * getval("sw1") + 0.1);
   if ((phase1 == 1) || (phase1 == 2)) {
     tsadd(phRec,2*id2_,4);  /* invert the phases of the storage 90 and */
     tsadd(ph1X90,2*id2_,4); /* the receiver for FAD to displace the axial peaks */
   }  
   if (phase1 == 2) {tsadd(ph1X90,3,4);} /* hypercomplex*/

   int id3_ = (int) (d3 * getval("sw2") + 0.1);
   if ((phase2 == 1) || (phase2 == 2)) {
     tsadd(phRec,2*id2_,4);  /* invert the phases of the storage and */
     tsadd(ph1Y90,2*id2_,4); /* the receiver for FAD to displace the axial peaks */
   }  
   if (phase2 == 2) {tsadd(ph1Y90,3,4);} /* hypercomplex*/
   setreceiver(phRec);

//AJN - Establish the preferred order of phase2,phase. 
//DMR - wft2da requires phase,phase2.

//  char array[MAXSTR];  
//  getstr("array",array);
//  if(!strcmp(array,"phase,phase2")) {putCmd("array='phase2,phase'\n");}  
   
// Begin Sequence

   txphase(phH90); decphase(zero); dec2phase(phYhy);
   obspwrf(getval("aH90")); decpwrf(getval("aX90")); decpwrf(getval("aYhy"));
   obsunblank(); decunblank(); _unblank34();

// Initial Homospoil Pulse

   rgradient('z',getval("gzlvl1"));
   delay(getval("hst"));
   rgradient('z',0.0);

// Recycle Delay

   delay(d1 - hst);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to Y Cross Polarization

   rgpulse(pwH90,phH90,0.0,0.0);
   txphase(phHhy);
   _cp_(hy,phHhy,phYhy);
   dec2phase(ph1Y90);
   dec2pwrf(getval("aY90"));

// Y F1 Period with H XiX Decoupling

   _dseqon(dec);   
   if (d3 > 0) {
      if (d3 > 2.0*pwX90) {
         delay(0.5*d3 - pwX90);
         decrgpulse(2.0*pwX90,zero,0.0,0.0);
         decunblank();
         delay(0.5*d3 - pwX90);
      }
   }
   else {
     delay(d3);
   }
   dec2rgpulse(pwY90,ph1Y90,0.0,0.0);
   dec2phase(ph2Y90);
   dec2unblank(); 
   delay(d3_);      
   dec2rgpulse(pwY90,ph2Y90,0.0,0.0);
   dec2phase(phYyx);
   dec2unblank();
   _dseqoff(dec);

// Y to X Cross Polarization

   decphase(phXyx); txphase(one);
   obspwrf(getval("aHyx"));
   obsunblank(); 
   xmtron();
   _cp_(yx,phYyx,phXyx);
   xmtroff();
   dec2pwrf(getval("aY90"));

// X F2 Period with H XiX Decoupling

   _dseqon(dec);
   decphase(ph1X90);
   decpwrf(getval("aX90"));
   if (d2 > 0.0) {
      if (d2 > 2.0*pwY90) {
         delay(0.5*d2 - pwY90);
         dec2rgpulse(2.0*getval("pwY90"),0,0.0,0.0);
         dec2unblank();
         delay(0.5*d2 - pwY90);
      }
   }
   else {
      delay(d2);
   }  
   decrgpulse(pwX90,ph1X90,0.0,0.0);
   txphase(phHxh);
   decunblank();
   delay(d2_);     
   _dseqoff(dec);

// Second Homospoil Delay

   rgradient('z',getval("gzlvl1"));
   delay(getval("hst"));
   rgradient('z',0.0);
   delay(getval("hstconst"));

// Saturation Pulses

   _mpseq(pxy,phHpxy);
   txphase(phHxh);

// X to H Cross Polarization

   obspwrf(getval("aH90"));
   obsunblank(); 
   xmtron();
   decrgpulse(pwX90,ph2X90,0.0,0.0);
   xmtroff();
   decphase(phXxh);
   _cp_(xh,phXxh,phHxh);

// XY8 Mixing
  
   if (getval("qHrfdr") > 0) {
      obspwrf(getval("aH90"));
      rgpulse(getval("pwH90"),ph1H90,0.0,0.0);
      _mpseq(rfdr,phHrfdr);
      obspwrf(getval("aH90"));
      rgpulse(pwH90,ph2H90,0.0,0.0);
      obsunblank();
   }

// Begin X Decoupling

   _dseqon(dec2); 
   obsblank(); _blank34();

// H Hahn Echo

   if(t1Hecho > 0.0) {
      txphase(phHecho);
      obspwrf(getval("aH90"));
      obsunblank();
      delay(t1Hecho);
      rgpulse(2*getval("pwH90"),phHecho,0.0,0.0);
      obsunblank();
      delay(t2Hecho);
      obsblank(); 
   }

// Begin H Acquisition
 
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec2);
   obsunblank(); decunblank(); _unblank34();
}
