/*bhYXH.c - YXH correlation with H detection using MISS,
            (Multiple Intense Solvent Suppression), constant time 
            with X decoupling.

                    HY cp, t1 Y evolution H dec
		    YX cp, t2 X evolution H dec
		    XH cp, potential HH rfdr mixing
		    H acq with X dec. 		    
		    no Y-Y dream mixing yet but will add

                    from hXH.c      AJN 03/29/10    
		    based on hYXH.c DHZ 02/07 for inova            
                    D. Rice (a-version)  05/27/10     
                    
                    Revised with new input from UIUC
                    D. Rice (b-version) 11/30/11
                    
            This sequence is bassed on hYXH provided by Chad Rienstra, UIUC.
      
Changes: Remove decmode - unused anyway.                                      
Changes: Add spinal2 with alp to replace spinal (X and H)
Question: use d2_index? But no change.
Changes: Homospoil to rgradient - add gzlvl1 
Changes: Fixed phase for indirect X refocussing pulse "1" to "one"
Changes: Fixed phase for indirect Y refocussing pulse "0" to "zero"
Changes: Separate getvals for pwH90, pwX90 and pwY90
Changes: Remove status statements.
Changes: Place obsblank and obsunblank in the Hecho module. 
Changes: Added gradient duty cycle calculation. 11/30/11
Changes: Replace spinal2 with getdseq2(). 11/30/11
Changes: Added new UIUC phase cycle 11/30/11
Changes: Added homospoil option in new sequence 11/30/11 
Changes: Added Constant-time Decoupling. 11/30/11
Changes: Added Optional Y decoupling. 11/30/11
Changes: changed dec(H) to obs and dec2 (X) to dec for getdseq 11/30/11. 
Changes: Adjusted the calculation of d2_ and d3_ 11/30/11
Changes: Fixed the word modules and variable duty 11/30/11
Changes: Fixed tRFmax in duty cycle (not tRF) 11/30/11
Changes: Added teturn times for rfdr, pxy and pxy2 11/30/11
changes: Add mixing sequences to the duty calculation 11/30/11
                                                           */
#include "standard.h"
#include "solidstandard.h"
#include <CompSens.h> 

// Define Static Values to Hold d2 and d3 First Increments

static double d2_init;
static double d3_init;

// Define Values for Phasetables

static int table1[4] = 	{0,0,2,2};         // phH90
static int table2[2] = 	{1,1};             // phHhy
static int table3[2] = 	{0,0};             // phYhy
static int table4[2] = 	{3,3};             // ph1Y90 store 
static int table17[2] = {1,1};             // ph2Y90 recover
static int table5[8] = 	{0,0,0,0,2,2,2,2}; // phYyx
static int table6[2] = 	{0,0};             // phXyx
static int table7[2] = 	{1,1};             // ph1X90 store
static int table8[2] = 	{1,3};             // ph2X90 recover
static int table9[2] = 	{0,0};             // phXxh
static int table10[2] = {1,1};             // phHxh
static int table11[4] = {0,0,2,2};         // ph1H90
static int table12[4] = {2,2,0,0};         // ph2H90
static int table13[8] = {0,2,2,0,2,0,0,2}; // phRec
static int table14[4] = {0,2,1,3};         // phHrfdr - H-H mixing
static int table15[2] = {0,0};             // phHecho - solid echo cycle
static int table16[2] = {0,1};             // phHpxy - H presat pulses

#define phH90 t1
#define phHhy t2
#define phYhy t3
#define ph1Y90 t4
#define ph2Y90 t17
#define phYyx t5
#define phXyx t6
#define ph1X90 t7
#define ph2X90 t8
#define phXxh t9
#define phHxh t10
#define ph1H90 t11
#define ph2H90 t12
#define phRec t13
#define phHrfdr t14
#define phHecho t15
#define phHpxy  t16

pulsesequence() {

// Add NUS for this Sequence for SPARSE='y' and: 
//     (ni > 1) and (nimax > ni + 1) or  
//     (ni2 > 1) and (nimax > ni2 + 1)  

   char sparseval[MAXSTR];
   getstr("SPARSE",sparseval);
   double ni2 = getval("ni2");
   if (sparseval[A] == 'y' && ((getval("ni") > 1.0 && getval("nimax") >= getval("ni") + 1.0) || 
      (ni2 > 1.0 && getval("ni2max") >= ni2 + 1.0))) {
      (void) set_RS(0);
      ni = getval("nimax");
      if (ni < 1) ni = 1;
      ni2= getval("ni2max"); 
      if (ni2 < 1) ni2 = 1;
      sw1 = getval("sw1");
      sw2 = getval("sw2");
   }

// Else Force SPARSE='n'.

   else {                     
      strncpy(sparseval,"n",3);
      putCmd("SPARSE='n'\n");   
      printf("No F1 Array - Set SPARSE='n'\n");
   }

// Define Variables and Modules and Get Parameter Values
  
   CP hy = getcp("HY",0.0,0.0,0,1);
   strncpy(hy.fr,"obs",3);
   strncpy(hy.to,"dec2",3);
   putCmd("frHY='obs'\n");
   putCmd("toHY='dec2'\n");

   CP yx = getcp("YX",0.0,0.0,0,1);
   strncpy(yx.fr,"dec2",3);
   strncpy(yx.to,"dec",3);
   putCmd("frYX='dec2'\n");
   putCmd("toYX='dec'\n");
   
   CP xh = getcp("XH",0.0,0.0,0,1);
   strncpy(xh.fr,"dec",3);
   strncpy(xh.to,"obs",3);
   putCmd("frXH='dec'\n");
   putCmd("toXH='obs'\n");

   MPSEQ pxy = getpxy("pxyH",0,0.0,0.0,0,1);
   strncpy(pxy.ch,"obs",3);
   putCmd("chHpxy='obs'\n");
   
   MPSEQ pxy2 = getpxy("pxy2H",0,0.0,0.0,0,1);
   strncpy(pxy2.ch,"obs",3);
   putCmd("chHpxy2='obs'\n");

   MPSEQ rfdr = getrfdrxy8("rfdrH",0,0.0,0.0,0,1);
   double tHrfdrret = rfdr.t;
   strncpy(rfdr.ch,"obs",3);
   putCmd("chHrfdr='obs'\n");
   putCmd("tHrfdrret = %f\n",tHrfdrret*1.0e6);
   
   DSEQ obs = getdseq2("H");
   DSEQ dec = getdseq2("X");
   
// Obtain the 90-degree Pulse Calibrations
   
   double pwY90 = getval("pwY90");
   double pwX90 = getval("pwX90");
   double pwH90 = getval("pwH90"); 

// Calculate the H Spin-echo Times
   
   double t1Hechoinit = getval("tHecho")/2;
   double t2Hechoinit = getval("tHecho")/2;
   double t1Hecho  = t1Hechoinit - pwH90;
   if (t1Hecho < 0.0) t1Hecho = 0.0;
   double t2Hecho  = t2Hechoinit - pwH90 - getval("rd");
   if (t2Hecho < 0.0) t2Hecho = 0.0;
      
// Set the Gradient Mode (Homospoil or Gradient) and Times

   char HS[MAXSTR];  
   getstr("HS",HS);  
   
   double hst = getval("hst");
   double hstconst = getval("hstconst");
   double hstdelay = hstconst - hst;
   if (hstdelay < 0.0) hstdelay = 0.0; 
   
   double hst2 = getval("hst2");
   double hst2const = getval("hst2const");
   double hst2delay = hst2const - hst2;
   if (hst2delay < 0.0) hst2delay = 0.0; 
   
// Choose DEC2 Decoupling

   char ddec2[MAXSTR];
   getstr("ddec2",ddec2);

   DSEQ dec2;
   if (!strcmp(ddec2,"y")) dec2 = getdseq2("Y");
   
// Calculate the F1 and F2 Acquisition Times 

   if (d2_index == 0) d2_init = getval("d2"); 
   if (d3_index == 0) d3_init = getval("d3"); 
   
   double d2_ = (ni - 1)/sw1 + d2_init;
   putCmd("d2acqret = %f\n",roundoff(d2_,12.5e-9));
   putCmd("d2dwret = %f\n",roundoff(1.0/sw1,12.5e-9));
   double d3_ = (getval("ni2") - 1)/sw2 + d3_init;
   putCmd("d3acqret = %f\n",roundoff(d3_,12.5e-9));
   putCmd("d3dwret = %f\n",roundoff(1.0/sw2,12.5e-9));
   
 // Calculate Constant-time Acquisition Window for F1 and F2
 
   double tconstd3 = getval("tconstd3"); 
   if (tconstd3 < (d3_ + 2.0*pwX90)) tconstd3 = d3_ + 2.0*pwX90;
   putCmd("tconstd3 = %f\n",roundoff(tconstd3,12.5e-9));
   double tmd3 =  tconstd3 - getval("d2") - 2.0*pwY90;
   if (tmd3 < 0.0) tmd3 = 0.0;
 
   double tconstd2 = getval("tconstd2"); 
   if (tconstd2 < (d2_ + pwX90)) tconstd2 = d2_ + pwX90;
   putCmd("tconstd2 = %f\n",roundoff(tconstd2,12.5e-9));  
   double tmd2 =  tconstd2 - getval("d2") - pwX90;
   if (tmd2 < 0.0) tmd2 = 0.0;
    
// Calculate Constant-time Decoupling Period tRFmax

   char ctd[MAXSTR];
   getstr("ctd",ctd);

   double tRF = 0.0;
   double tRFmax = getval("tRFmax");
   if (!strcmp(ctd,"y")) {
      if (tRFmax <= (d2_ + d3_)) tRFmax = d2_ + d3_;
      tRF = tRFmax - d2 - d3; 
      putCmd("tRFmax = %f\n",tRFmax*1.0e6);  
   } 

// Set tRFmax = 0.0 for No Constant-time Decoupling

   else { 
      putCmd("tRFmax = 0.0\n");
   }

// Copy Current Parameters to Processed

   putCmd("groupcopy('current','processed','acquisition')");
   
// Dutycycle Protection

   double duty = 4.0e-6 + 3.0*pwH90 + getval("tHY") + 
                   getval("tYX") + hst2 + getval("tXH") + tHrfdrret + 
                   t1Hecho + t2Hecho + getval("ad") + getval("rd") + at;
               
   if (!strcmp(ctd,"y")) duty = duty + tRFmax; 
   else duty = duty + d2 + d3;
   
   if (!strcmp(HS,"r")) duty = duty + hst;     

   duty = duty/(duty + d1 + 2.0*hstdelay + 2.0*hst + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phHhy,2,table2);
   settable(phYhy,2,table3);
   settable(ph1Y90,2,table4);
   settable(ph2Y90,2,table17);
   settable(phYyx,8,table5);
   settable(phXyx,2,table6);
   settable(ph1X90,2,table7);
   settable(ph2X90,2,table8);
   settable(phXxh,2,table9);
   settable(phHxh,2,table10);
   settable(ph1H90,4,table11);
   settable(ph2H90,4,table12);
   settable(phRec,8,table13);   
   settable(phHrfdr,4,table14);
   settable(phHecho,2,table15);
   settable(phHpxy,2,table16);

   int id2_ = (int) (d2 * getval("sw1") + 0.1);
   if ((phase1 == 1) || (phase1 == 2)) {
     tsadd(phRec,2*id2_,4);  
     tsadd(ph1X90,2*id2_,4); 
   }  
   if (phase1 == 2) {tsadd(ph1X90,3,4);} 

   int id3_ = (int) (d3 * getval("sw2") + 0.1);
   if ((phase2 == 1) || (phase2 == 2)) {
     tsadd(phRec,2*id2_,4);  
     tsadd(ph1Y90,2*id2_,4);
   }  
   if (phase2 == 2) {tsadd(ph1Y90,3,4);}
   setreceiver(phRec);
  
// Begin Sequence

   txphase(phH90); decphase(zero); dec2phase(phYhy);
   obspwrf(getval("aH90")); decpwrf(getval("aX90")); decpwrf(getval("aYhy"));
   obsunblank(); decunblank(); _unblank34();

// Initial Homospoil Pulse

   if (!strcmp(HS,"z")) {
      rgradient('z',getval("gzlvl1"));
      delay(hst);
      rgradient('z',0.0);
      delay(hstdelay);
      printf("Executing Zed Gradient Homospoil\n");
   }
   else if (!strcmp(HS,"hs")) {
      status(B);
      hsdelay(hst);
      status(A);
      delay(hstdelay);
      printf("Executing hsdelay Homospoil\n");   
   }	  
   else {
      delay(hst); 
      delay(hstdelay); 
      printf("Executing No Homospoil\n");  
   }

// Recycle Delay

   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to Y Cross Polarization

   rgpulse(pwH90,phH90,0.0,0.0);
   _cp_(hy,phHhy,phYhy);
   dec2phase(ph1Y90);
   dec2pwrf(getval("aY90"));

// F2 Indirect Period for Y

   _dseqon2(obs);
   if (d3 > 0) {
      if (d3 > 2.0*pwX90) {
         delay(0.5*d3 - pwX90);
         decrgpulse(2.0*pwX90,zero,0.0,0.0);
         decunblank();
         delay(0.5*d3 - pwX90);
      }
   }
   else {
      delay(d3);
   }
   dec2rgpulse(pwY90,ph1Y90,0.0,0.0);
   dec2phase(ph2Y90);
   dec2unblank(); 
   delay(tmd3);      
   dec2rgpulse(pwY90,ph2Y90,0.0,0.0);
   dec2phase(phYyx);
   dec2unblank();
   _dseqoff2(obs);

// Y to X Cross Polarization

   decphase(phXyx); txphase(one);
   obspwrf(getval("aHyx"));
   obsunblank(); 
   xmtron();
   _cp_(yx,phYyx,phXyx);
   xmtroff();
   dec2pwrf(getval("aY90"));
   
// F1 Indirect Detection Period for X

   _dseqon2(obs);
   decphase(ph1X90);
   decpwrf(getval("aX90"));
   if (d2 > 0.0) {
      if (d2 > 2.0*pwY90) {
         delay(0.5*d2 - pwY90);
         dec2rgpulse(2.0*getval("pwY90"),0,0.0,0.0);
         dec2unblank();
         delay(0.5*d2 - pwY90);
      }
   }
   else {
      delay(d2);
   }  
   decrgpulse(pwX90,ph1X90,0.0,0.0);
   txphase(phHxh);
   decunblank();
   delay(tmd2);     
   _dseqoff2(dec);

// Second Homospoil Delay with Saturation Pulses

   if (!strcmp(HS,"z")) {
      rgradient('z',getval("gzlvl1"));
      _mpseqon(pxy,phHpxy);
      delay(hst);
      _mpseqoff(pxy); 
      rgradient('z',0.0);
      delay(hstdelay);
      printf("Executing pxy2 Saturation Pulses with Zed Gradient\n");
   }
   else if (!strcmp(HS,"hs")) {
      status(B);
      hsdelay(hst);
      status(A);
      delay(hstdelay);
      printf("Executing 2nd hsdelay Homospoil\n");   
   }
   else {
      hsdelay(hst);
      delay(hstdelay);   
      printf("Executing No 2nd Homospoil\n");  
   }
   
// More H Saturation Pulses and a Delay

   _mpseqon(pxy2,phHpxy);
   delay(hst2); 
   _mpseqoff(pxy2);
   txphase(phHxh); decphase(ph2X90);
   delay(hst2delay); 
   
// X to H Cross Polarization

   obspwrf(getval("aH90"));
   obsunblank(); 
   xmtron();
   decrgpulse(pwX90,ph2X90,0.0,0.0);
   xmtroff();
   decphase(phXxh);
   _cp_(xh,phXxh,phHxh);

// XY8 Mixing on H
  
   if (getval("qHrfdr") > 0) {
      obspwrf(getval("aH90"));
      rgpulse(pwH90,ph1H90,0.0,0.0);
      _mpseq(rfdr,phHrfdr);
      obspwrf(getval("aH90"));
      rgpulse(pwH90,ph2H90,0.0,0.0);
      obsunblank();
   }
   
// Blank DEC3, Start Optional Y DEC2 Decoupling or Blank DEC2

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqon2(dec2);
   }
   else {
      if (NUMch > 2) dec2blank();
   }
   if (NUMch > 3) dec3blank();   

// Begin X Decoupling on DEC

   if (!strcmp(HS,"hs")) status(C); 
   _dseqon2(dec); 
   obsblank(); _blank34();

// H Hahn Echo

   if(t1Hecho > 0.0) {
      txphase(phHecho);
      obspwrf(getval("aH90"));
      obsunblank();
      delay(t1Hecho);
      rgpulse(2.0*pwH90,phHecho,0.0,0.0);
      obsunblank();
      delay(t2Hecho);
      obsblank(); 
   }

// Begin H Acquisition
 
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   
// Halt X Decoupling on DEC

   _dseqoff2(dec);  
   
// Halt Optional Y DEC2 Decoupling or Unblank DEC2, if Blanked

   if (!strcmp(ddec2,"y")) {
      if (NUMch > 2) _dseqoff2(dec2);
   }
   else {
      if (NUMch > 2) dec2unblank();
   }
   
// Make OBS (H) Constant-time with RF Following Acquisition

   decphase(zero);
   _dseqon2(obs); _dseqoff2(obs); // Set the decoupler amplitude
   if (!strcmp(ctd,"y")) {
      decon(); 
      delay(tRF);
      decoff();
   }
   obsunblank(); decunblank(); _unblank34();
}  


