/*grad_rec.c - Single pulse X preparation following a gradient pulse 
               with SPINAL or TPPM decoupling during acquisition. 
               Used to measure gradient recovery with an MAS solid
               sample. 
  
               J. Stringer 05/06/2010                             */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,2,1,3};           // phX90
static int table2[4] = {0,2,1,3};           // phRec

#define phX90 t1
#define phRec t2

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwX90") + getval("ad") + getval("rd") + at;
   duty = duty/(duty + d1 + getval("gtZgrad") + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Maximum Gradient Time On

   duty = getval("gpwZgrad");
   if (duty > 0.01) {
      printf("Gradient on longer than 10ms. Abort!\n");
      psg_abort(1);
   }

// Set Phase Tables

   settable(phX90,4,table1);
   settable(phRec,4,table2);
   setreceiver(phRec);

// Begin Sequence

   txphase(phX90); decphase(zero);
   obspwrf(getval("aX90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// Gradient Pulse and Recovery Delay

   zgradpulse(getval("gaZgrad"),getval("gpwZgrad"));
   delay(getval("gtZgrad"));

// X Direct Polarization

   rgpulse(getval("pwX90"),phX90,0.0,0.0);

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

